/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import ucar.array.Array;
import ucar.array.ArrayType;
import ucar.array.InvalidRangeException;
import ucar.array.StructureDataArray;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.EnhancementsImpl;
import ucar.nc2.dataset.SequenceDS;
import ucar.nc2.dataset.StructureDataEnhancer;
import ucar.nc2.dataset.StructureEnhanced;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.internal.dataset.CoordinatesHelper;
import ucar.nc2.internal.dataset.StructureDataArrayEnhancer;
import ucar.nc2.util.CancelTask;

@Immutable
public class StructureDS
extends Structure
implements StructureEnhanced {
    protected final EnhancementsImpl proxy;
    protected final Structure orgVar;
    protected final String orgName;
    private ImmutableList<CoordinateSystem> coordinateSystems;

    @Override
    @Nullable
    public Variable getOriginalVariable() {
        return this.orgVar;
    }

    @Deprecated
    public DataType getOriginalDataType() {
        return DataType.STRUCTURE;
    }

    public ArrayType getOriginalArrayType() {
        return ArrayType.STRUCTURE;
    }

    @Override
    public String getOriginalName() {
        return this.orgName;
    }

    @Override
    @Deprecated
    public ucar.ma2.Array reallyRead(Variable client, CancelTask cancelTask) throws IOException {
        ucar.ma2.Array result;
        if (this.hasCachedData()) {
            result = super.reallyRead(client, cancelTask);
        } else if (this.orgVar != null) {
            result = this.orgVar.read();
        } else {
            throw new IllegalStateException("StructureDS has no way to get data");
        }
        StructureDataEnhancer enhancer = new StructureDataEnhancer(this);
        return enhancer.enhance((ArrayStructure)result, null);
    }

    @Override
    public Array<?> proxyReadArray(Variable client, CancelTask cancelTask) throws IOException {
        Array<?> result;
        if (this.hasCachedData()) {
            result = super.proxyReadArray(client, cancelTask);
        } else if (this.orgVar != null) {
            result = this.orgVar.readArray();
        } else {
            throw new IllegalStateException("StructureDS has no way to get data");
        }
        StructureDataArrayEnhancer enhancer = new StructureDataArrayEnhancer(this, (StructureDataArray)result);
        return enhancer.enhance();
    }

    @Override
    @Deprecated
    public ucar.ma2.Array reallyRead(Variable client, Section section, CancelTask cancelTask) throws IOException, ucar.ma2.InvalidRangeException {
        ucar.ma2.Array result;
        if (section.computeSize() == this.getSize()) {
            return this._read();
        }
        if (this.hasCachedData()) {
            result = super.reallyRead(client, section, cancelTask);
        } else if (this.orgVar != null) {
            result = this.orgVar.read(section);
        } else {
            throw new IllegalStateException("StructureDS has no way to get data");
        }
        StructureDataEnhancer enhancer = new StructureDataEnhancer(this);
        return enhancer.enhance((ArrayStructure)result, section);
    }

    @Override
    public Array<?> proxyReadArray(Variable client, ucar.array.Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
        Array<?> result;
        if (section.computeSize() == this.getSize()) {
            return this.proxyReadArray(client, cancelTask);
        }
        if (this.hasCachedData()) {
            result = super.proxyReadArray(client, section, cancelTask);
        } else if (this.orgVar != null) {
            result = this.orgVar.readArray(section);
        } else {
            throw new IllegalStateException("StructureDS has no way to get data");
        }
        StructureDataArrayEnhancer enhancer = new StructureDataArrayEnhancer(this, (StructureDataArray)result);
        return enhancer.enhance();
    }

    @Override
    public ImmutableList<CoordinateSystem> getCoordinateSystems() {
        return this.coordinateSystems == null ? ImmutableList.of() : this.coordinateSystems;
    }

    @Override
    public String getDescription() {
        return this.proxy.getDescription();
    }

    @Override
    public String getUnitsString() {
        return this.proxy.getUnitsString();
    }

    void setCoordinateSystems(CoordinatesHelper coords) {
        if (this.coordinateSystems != null) {
            throw new RuntimeException("Cant call twice");
        }
        this.coordinateSystems = coords.makeCoordinateSystemsFor(this);
    }

    protected StructureDS(Builder<?> builder, Group parentGroup) {
        super((Structure.Builder<?>)builder, parentGroup);
        this.orgVar = ((Builder)builder).orgVar;
        this.orgName = builder.orgName;
        this.proxy = new EnhancementsImpl(this, builder.units, builder.desc);
    }

    @Override
    public Builder<?> toBuilder() {
        return this.addLocalFieldsToBuilder(StructureDS.builder());
    }

    protected Builder<?> addLocalFieldsToBuilder(Builder<? extends Builder<?>> b) {
        ((Builder)((Builder)b.setOriginalVariable(this.orgVar).setOriginalName(this.orgName)).setUnits(this.proxy.getUnitsString())).setDesc(this.proxy.getDescription());
        return (Builder)super.addLocalFieldsToBuilder((Structure.Builder<? extends Structure.Builder<?>>)b);
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Structure.Builder<T> {
        private Structure orgVar;
        protected String orgName;
        protected String units;
        protected String desc;
        private boolean built;

        public T setOriginalVariable(Structure orgVar) {
            this.orgVar = orgVar;
            return (T)((Builder)this.self());
        }

        public T setOriginalName(String orgName) {
            this.orgName = orgName;
            return (T)((Builder)this.self());
        }

        public T setUnits(String units) {
            this.units = units;
            if (units != null) {
                this.addAttribute(new Attribute("units", units));
            }
            return (T)((Builder)this.self());
        }

        public T setDesc(String desc) {
            this.desc = desc;
            if (desc != null) {
                this.addAttribute(new Attribute("long_name", desc));
            }
            return (T)((Builder)this.self());
        }

        public T copyFrom(Structure orgVar) {
            super.copyFrom(orgVar);
            for (Variable v : orgVar.getVariables()) {
                Object newVar = v instanceof Sequence ? SequenceDS.builder().copyFrom((Sequence)v) : (v instanceof Structure ? StructureDS.builder().copyFrom((Structure)v) : VariableDS.builder().copyFrom(v));
                this.addMemberVariable((Variable.Builder<?>)newVar);
            }
            this.setOriginalVariable(orgVar);
            this.setOriginalName(orgVar.getShortName());
            return (T)((Builder)this.self());
        }

        @Override
        public StructureDS build(Group parentGroup) {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            this.setArrayType(ArrayType.STRUCTURE);
            return new StructureDS(this, parentGroup);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }
}

