/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureMA;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureDataW;
import ucar.ma2.StructureMembers;
import ucar.nc2.Variable;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.StructureEnhanced;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;

@Deprecated
class StructureDataEnhancer {
    private static final Logger logger = LoggerFactory.getLogger(StructureDataEnhancer.class);
    private final StructureEnhanced topStructure;

    StructureDataEnhancer(StructureEnhanced topStructure) {
        this.topStructure = topStructure;
    }

    ArrayStructure enhance(ArrayStructure orgAS, Section section) throws IOException {
        Array mdata;
        if (!(orgAS instanceof ArraySequence) && orgAS.getSize() == 0L || !StructureDataEnhancer.convertNeeded(this.topStructure, orgAS.getStructureMembers())) {
            StructureDataEnhancer.convertMemberInfo(this.topStructure, orgAS.getStructureMembers());
            return orgAS;
        }
        ArrayStructureMA newAS = ArrayStructureMA.factoryMA(orgAS);
        for (StructureMembers.Member m : newAS.getMembers()) {
            VariableEnhanced v2 = (VariableEnhanced)((Object)this.topStructure.findVariable(m.getName()));
            if (v2 == null && this.topStructure.getOriginalVariable() != null) {
                v2 = StructureDataEnhancer.findVariableFromOrgName(this.topStructure, m.getName());
            }
            if (v2 == null) continue;
            if (v2 instanceof VariableDS) {
                VariableDS vds = (VariableDS)v2;
                if (!vds.needConvert()) continue;
                mdata = newAS.extractMemberArray(m);
                mdata = vds.convert(mdata, vds.getEnhanceMode());
                newAS.setMemberArray(m, mdata);
                continue;
            }
            if (!(v2 instanceof StructureDS)) continue;
            StructureDS innerStruct = (StructureDS)v2;
            if (StructureDataEnhancer.convertNeeded(innerStruct, null)) {
                if (innerStruct.getDataType() == DataType.SEQUENCE) {
                    ArrayObject.D1 seqArray = (ArrayObject.D1)newAS.extractMemberArray(m);
                    ArrayObject.D1 newSeq = (ArrayObject.D1)Array.factory(DataType.SEQUENCE, new int[]{(int)seqArray.getSize()});
                    m.setDataArray(newSeq);
                    int i = 0;
                    while ((long)i < seqArray.getSize()) {
                        ArraySequence innerSeq = (ArraySequence)seqArray.get(i);
                        newSeq.set(i, new SequenceConverter(innerStruct, innerSeq));
                        ++i;
                    }
                } else {
                    mdata = newAS.extractMemberArray(m);
                    StructureDataEnhancer innerEnhancer = new StructureDataEnhancer(innerStruct);
                    mdata = innerEnhancer.enhance((ArrayStructure)mdata, null);
                    newAS.setMemberArray(m, mdata);
                }
            }
            StructureDataEnhancer.convertMemberInfo(innerStruct, m.getStructureMembers());
        }
        StructureMembers sm = newAS.getStructureMembers();
        StructureDataEnhancer.convertMemberInfo(this.topStructure, sm);
        for (Variable v : this.topStructure.getVariables()) {
            if (StructureDataEnhancer.varHasData(v, sm)) continue;
            try {
                Variable completeVar = this.topStructure.getParentGroup().findVariableLocal(v.getShortName());
                mdata = completeVar.read(section);
                StructureMembers.Member m = sm.addMember(v.getShortName(), v.getDescription(), v.getUnitsString(), v.getDataType(), v.getShape());
                newAS.setMemberArray(m, mdata);
            }
            catch (InvalidRangeException e) {
                throw new IOException(e.getMessage());
            }
        }
        return newAS;
    }

    StructureData enhance(StructureData orgData, int recno) throws IOException {
        if (!StructureDataEnhancer.convertNeeded(this.topStructure, orgData.getStructureMembers())) {
            StructureDataEnhancer.convertMemberInfo(this.topStructure, orgData.getStructureMembers());
            return orgData;
        }
        StructureMembers smResult = orgData.getStructureMembers().toBuilder(false).build();
        StructureDataW result = new StructureDataW(smResult);
        for (StructureMembers.Member m : orgData.getMembers()) {
            Array mdata;
            VariableEnhanced v2 = (VariableEnhanced)((Object)this.topStructure.findVariable(m.getName()));
            if (v2 == null && this.topStructure.getOriginalVariable() != null) {
                v2 = StructureDataEnhancer.findVariableFromOrgName(this.topStructure, m.getName());
            }
            if (v2 == null) {
                StructureDataEnhancer.findVariableFromOrgName(this.topStructure, m.getName());
                logger.warn("StructureDataDS.convert Cant find member " + m.getName());
                continue;
            }
            StructureMembers.Member mResult = smResult.findMember(m.getName());
            if (v2 instanceof VariableDS) {
                VariableDS vds = (VariableDS)v2;
                mdata = orgData.getArray(m);
                if (vds.needConvert()) {
                    mdata = vds.convert(mdata, vds.getEnhanceMode());
                }
                result.setMemberData(mResult, mdata);
            }
            if (!(v2 instanceof StructureDS)) continue;
            StructureDS innerStruct = (StructureDS)v2;
            if (innerStruct.getDataType() == DataType.SEQUENCE) {
                Array seqArray;
                Array a = orgData.getArray(m);
                if (a instanceof ArrayObject.D1) {
                    seqArray = (ArrayObject.D1)a;
                    ArrayObject.D1 newSeq = (ArrayObject.D1)Array.factory(DataType.SEQUENCE, new int[]{(int)seqArray.getSize()});
                    mResult.setDataArray(newSeq);
                    int i = 0;
                    while ((long)i < seqArray.getSize()) {
                        ArraySequence innerSeq = (ArraySequence)((ArrayObject.D1)seqArray).get(i);
                        newSeq.set(i, new SequenceConverter(innerStruct, innerSeq));
                        ++i;
                    }
                } else {
                    seqArray = (ArraySequence)a;
                    result.setMemberData(mResult, (Array)new SequenceConverter(innerStruct, (ArraySequence)seqArray));
                }
            } else {
                mdata = orgData.getArray(m);
                StructureDataEnhancer innerEnhancer = new StructureDataEnhancer(innerStruct);
                mdata = innerEnhancer.enhance((ArrayStructure)mdata, null);
                result.setMemberData(mResult, mdata);
            }
            StructureDataEnhancer.convertMemberInfo(innerStruct, mResult.getStructureMembers());
        }
        StructureMembers sm = result.getStructureMembers();
        StructureDataEnhancer.convertMemberInfo(this.topStructure, sm);
        for (Variable v : this.topStructure.getVariables()) {
            if (StructureDataEnhancer.varHasData(v, sm)) continue;
            try {
                Variable completeVar = this.topStructure.getParentGroup().findVariableLocal(v.getShortName());
                Array mdata = completeVar.read(Section.builder().appendRange(recno, recno).build());
                StructureMembers.Member m = sm.addMember(v.getShortName(), v.getDescription(), v.getUnitsString(), v.getDataType(), v.getShape());
                result.setMemberData(m, mdata);
            }
            catch (InvalidRangeException e) {
                throw new IOException(e.getMessage());
            }
        }
        return result;
    }

    private static void convertMemberInfo(StructureEnhanced structureEn, StructureMembers wrapperSm) {
        for (StructureMembers.Member m : wrapperSm.getMembers()) {
            Variable v = structureEn.findVariable(m.getName());
            if (v == null && structureEn.getOriginalVariable() != null) {
                v = (Variable)((Object)StructureDataEnhancer.findVariableFromOrgName(structureEn, m.getName()));
            }
            if (v != null) {
                m.setVariableInfo(v.getShortName(), v.getDescription(), v.getUnitsString(), v.getDataType());
            }
            if (!(v instanceof StructureDS)) continue;
            StructureDS innerStruct = (StructureDS)v;
            StructureDataEnhancer.convertMemberInfo(innerStruct, m.getStructureMembers());
        }
    }

    private static VariableEnhanced findVariableFromOrgName(StructureEnhanced structureEn, String orgName) {
        UnmodifiableIterator unmodifiableIterator = structureEn.getVariables().iterator();
        while (unmodifiableIterator.hasNext()) {
            Variable vTop;
            Variable v = vTop = (Variable)unmodifiableIterator.next();
            while (v instanceof VariableEnhanced) {
                VariableEnhanced ve = (VariableEnhanced)((Object)v);
                if (ve.getOriginalName() != null && ve.getOriginalName().equals(orgName)) {
                    return (VariableEnhanced)((Object)vTop);
                }
                v = ve.getOriginalVariable();
            }
        }
        return null;
    }

    private static boolean varHasData(Variable v, StructureMembers sm) {
        if (sm.findMember(v.getShortName()) != null) {
            return true;
        }
        while (v instanceof VariableEnhanced) {
            VariableEnhanced ve = (VariableEnhanced)((Object)v);
            if (sm.findMember(ve.getOriginalName()) != null) {
                return true;
            }
            v = ve.getOriginalVariable();
        }
        return false;
    }

    private static boolean convertNeeded(StructureEnhanced structureEn, StructureMembers smData) {
        for (Variable v : structureEn.getVariables()) {
            StructureDS nested;
            VariableDS vds;
            if (v instanceof VariableDS ? (vds = (VariableDS)v).needConvert() : v instanceof StructureDS && StructureDataEnhancer.convertNeeded(nested = (StructureDS)v, null)) {
                return true;
            }
            if (smData == null || StructureDataEnhancer.varHasData(v, smData)) continue;
            return true;
        }
        return false;
    }

    static class StructureDataIteratorEnhanced
    implements StructureDataIterator {
        private StructureDataIterator orgIter;
        private final StructureDataEnhancer enhancer;
        private int count;

        StructureDataIteratorEnhanced(StructureEnhanced newStruct, StructureDataIterator orgIter) {
            this.enhancer = new StructureDataEnhancer(newStruct);
            this.orgIter = orgIter;
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.orgIter.hasNext();
        }

        @Override
        public StructureData next() throws IOException {
            StructureData sdata = this.orgIter.next();
            return this.enhancer.enhance(sdata, this.count++);
        }

        @Override
        public void setBufferSize(int bytes) {
            this.orgIter.setBufferSize(bytes);
        }

        @Override
        public StructureDataIterator reset() {
            this.orgIter = this.orgIter.reset();
            return this.orgIter == null ? null : this;
        }

        @Override
        public int getCurrentRecno() {
            return this.orgIter.getCurrentRecno();
        }

        @Override
        public void close() {
            this.orgIter.close();
        }
    }

    private static class SequenceConverter
    extends ArraySequence {
        StructureDS orgStruct;
        ArraySequence orgSeq;

        SequenceConverter(StructureDS orgStruct, ArraySequence orgSeq) {
            super(orgSeq.getStructureMembers(), orgSeq.getShape());
            this.orgStruct = orgStruct;
            this.orgSeq = orgSeq;
            this.nelems = orgSeq.getStructureDataCount();
            this.members = orgSeq.getStructureMembers().toBuilder(false).build();
            StructureDataEnhancer.convertMemberInfo(orgStruct, this.members);
        }

        @Override
        public StructureDataIterator getStructureDataIterator() {
            return new StructureDataIteratorEnhanced(this.orgStruct, this.orgSeq.getStructureDataIterator());
        }
    }
}

