/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.Set;
import javax.annotation.Nullable;
import ucar.array.Array;
import ucar.array.ArrayType;
import ucar.array.ArraysConvert;
import ucar.array.InvalidRangeException;
import ucar.ma2.DataType;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.EnhanceScaleMissingUnsigned;
import ucar.nc2.dataset.EnhanceScaleMissingUnsignedImpl;
import ucar.nc2.dataset.EnhancementsImpl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.internal.dataset.CoordinatesHelper;
import ucar.nc2.internal.dataset.DataEnhancer;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.Indent;

public class VariableDS
extends Variable
implements EnhanceScaleMissingUnsigned,
VariableEnhanced {
    private final EnhancementsImpl enhanceProxy;
    private final EnhanceScaleMissingUnsignedImpl scaleMissingUnsignedProxy;
    private final Set<NetcdfDataset.Enhance> enhanceMode;
    private final DataEnhancer dataEnhancer;
    @Nullable
    protected final Variable orgVar;
    protected final ArrayType orgDataType;
    @Nullable
    protected final String orgName;
    final String orgFileTypeId;
    private ImmutableList<CoordinateSystem> coordinateSystems;

    public static VariableDS fromVar(Group group, Variable orgVar, boolean enhance) {
        String units;
        Preconditions.checkArgument((!(orgVar instanceof Structure) ? 1 : 0) != 0, (Object)("VariableDS must not wrap a Structure; name=" + orgVar.getFullName()));
        Variable.Builder builder = VariableDS.builder().copyFrom(orgVar);
        if (enhance) {
            ((Builder)builder).setEnhanceMode(NetcdfDataset.getDefaultEnhanceMode());
        }
        if ((units = orgVar.getUnitsString()) != null) {
            ((Builder)builder).setUnits(units.trim());
        }
        return ((Builder)builder).build(group);
    }

    @Override
    public NetcdfFile getNetcdfFile() {
        return this.getParentGroup() == null ? null : this.getParentGroup().getNetcdfFile();
    }

    public boolean convertNeeded() {
        if (this.enhanceMode.contains((Object)NetcdfDataset.Enhance.ConvertEnums) && (this.dataType.isEnum() || this.orgDataType != null && this.orgDataType.isEnum())) {
            return true;
        }
        if (this.enhanceMode.contains((Object)NetcdfDataset.Enhance.ConvertMissing) && this.hasMissing()) {
            return true;
        }
        if (this.enhanceMode.contains((Object)NetcdfDataset.Enhance.ApplyScaleOffset) && this.hasScaleOffset()) {
            return true;
        }
        return this.enhanceMode.contains((Object)NetcdfDataset.Enhance.ConvertUnsigned) && this.dataType.isUnsigned();
    }

    boolean needConvert() {
        Set<NetcdfDataset.Enhance> enhancements = this.getEnhanceMode();
        return enhancements.contains((Object)NetcdfDataset.Enhance.ConvertEnums) || enhancements.contains((Object)NetcdfDataset.Enhance.ConvertUnsigned) || enhancements.contains((Object)NetcdfDataset.Enhance.ApplyScaleOffset) || enhancements.contains((Object)NetcdfDataset.Enhance.ConvertMissing);
    }

    ucar.ma2.Array convert(ucar.ma2.Array data) {
        return this.dataEnhancer.convert(data, this.enhanceMode);
    }

    ucar.ma2.Array convert(ucar.ma2.Array data, Set<NetcdfDataset.Enhance> enhancements) {
        return this.dataEnhancer.convert(data, enhancements);
    }

    public Array<?> convertArray(Array<?> data) {
        return this.dataEnhancer.convertArray(data, this.enhanceMode);
    }

    public Set<NetcdfDataset.Enhance> getEnhanceMode() {
        if (!(this.orgVar instanceof VariableDS)) {
            return Collections.unmodifiableSet(this.enhanceMode);
        }
        VariableDS orgVarDS = (VariableDS)this.orgVar;
        return Sets.union(this.enhanceMode, orgVarDS.getEnhanceMode());
    }

    @Override
    @Nullable
    public Variable getOriginalVariable() {
        return this.orgVar;
    }

    public DataType getOriginalDataType() {
        return this.getOriginalArrayType().getDataType();
    }

    public ArrayType getOriginalArrayType() {
        return this.orgDataType != null ? this.orgDataType : this.getArrayType();
    }

    @Override
    @Nullable
    public String getOriginalName() {
        return this.orgName;
    }

    @Override
    public String lookupEnumString(int val) {
        if (this.dataType.isEnum()) {
            return super.lookupEnumString(val);
        }
        return this.orgVar.lookupEnumString(val);
    }

    @Override
    public String toStringDebug() {
        return this.orgVar != null ? this.orgVar.toStringDebug() : "";
    }

    @Override
    public String getDatasetLocation() {
        String result = super.getDatasetLocation();
        if (result != null) {
            return result;
        }
        if (this.orgVar != null) {
            return this.orgVar.getDatasetLocation();
        }
        return null;
    }

    @Override
    public void setCaching(boolean caching) {
        if (caching && this.orgVar != null) {
            this.orgVar.setCaching(true);
        }
    }

    @Override
    public String toString() {
        Formatter f = new Formatter();
        this.writeCDL(f, new Indent(2), false, false);
        if (this.orgVar != null) {
            f.format("%nOriginal: %s %s%n", new Object[]{this.orgDataType, this.orgVar.getNameAndDimensions()});
        }
        f.format("Coordinate Systems%n", new Object[0]);
        for (CoordinateSystem csys : this.getCoordinateSystems()) {
            f.format(" %s (%d)%n", csys.getName(), csys.getCoordinateAxes().size());
        }
        return f.toString();
    }

    @Override
    @Deprecated
    protected ucar.ma2.Array _read() throws IOException {
        ucar.ma2.Array result = this.hasCachedData() ? super._read() : this.proxyReader.reallyRead(this, null);
        return this.convert(result);
    }

    @Override
    public Array<?> readArray() throws IOException {
        Array<?> result = this.hasCachedData() ? super.readArray() : this.proxyReader.proxyReadArray(this, null);
        return this.convertArray(result);
    }

    @Override
    @Deprecated
    public ucar.ma2.Array reallyRead(Variable client, CancelTask cancelTask) throws IOException {
        if (this.orgVar == null) {
            return this.getMissingDataArray(this.shape);
        }
        return this.orgVar.read();
    }

    @Override
    public Array<?> proxyReadArray(Variable client, CancelTask cancelTask) throws IOException {
        if (this.orgVar == null) {
            return ArraysConvert.convertToArray(this.getMissingDataArray(this.shape));
        }
        return this.orgVar.readArray();
    }

    @Override
    @Deprecated
    protected ucar.ma2.Array _read(Section section) throws IOException, ucar.ma2.InvalidRangeException {
        if (null == section || section.computeSize() == this.getSize()) {
            return this._read();
        }
        ucar.ma2.Array result = this.hasCachedData() ? super._read(section) : this.proxyReader.reallyRead(this, section, null);
        return this.convert(result);
    }

    @Override
    @Deprecated
    public ucar.ma2.Array reallyRead(Variable client, Section section, CancelTask cancelTask) throws IOException, ucar.ma2.InvalidRangeException {
        if (null == section || section.computeSize() == this.getSize()) {
            return this.reallyRead(client, cancelTask);
        }
        if (this.orgVar == null) {
            return this.getMissingDataArray(section.getShape());
        }
        return this.orgVar.read(section);
    }

    @Override
    public Array<?> readArray(ucar.array.Section section) throws IOException, InvalidRangeException {
        if (null == section || section.computeSize() == this.getSize()) {
            return this.readArray();
        }
        Array<?> result = this.hasCachedData() ? super.readArray(section) : this.proxyReader.proxyReadArray(this, section, null);
        return this.convertArray(result);
    }

    @Override
    public Array<?> proxyReadArray(Variable client, ucar.array.Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
        if (null == section || section.computeSize() == this.getSize()) {
            return this.proxyReadArray(client, cancelTask);
        }
        if (this.orgVar == null) {
            return ArraysConvert.convertToArray(this.getMissingDataArray(section.getShape()));
        }
        return this.orgVar.readArray(section);
    }

    @Override
    @Deprecated
    public long readToStream(Section section, OutputStream out) throws IOException, ucar.ma2.InvalidRangeException {
        if (this.orgVar == null) {
            return super.readToStream(section, out);
        }
        return this.orgVar.readToStream(section, out);
    }

    @Deprecated
    public ucar.ma2.Array getMissingDataArray(int[] shape) {
        Object[] storage;
        switch (this.getDataType()) {
            case BOOLEAN: {
                storage = new boolean[1];
                break;
            }
            case BYTE: 
            case UBYTE: 
            case ENUM1: {
                storage = new byte[1];
                break;
            }
            case CHAR: {
                storage = new char[1];
                break;
            }
            case SHORT: 
            case USHORT: 
            case ENUM2: {
                storage = new short[1];
                break;
            }
            case INT: 
            case UINT: 
            case ENUM4: {
                storage = new int[1];
                break;
            }
            case LONG: 
            case ULONG: {
                storage = new long[1];
                break;
            }
            case FLOAT: {
                storage = new float[1];
                break;
            }
            case DOUBLE: {
                storage = new double[1];
                break;
            }
            default: {
                storage = new Object[1];
            }
        }
        ucar.ma2.Array array = ucar.ma2.Array.factoryConstant(this.getDataType(), shape, storage);
        if (this.scaleMissingUnsignedProxy.hasFillValue()) {
            array.setObject(0, (Object)this.scaleMissingUnsignedProxy.getFillValue());
        }
        return array;
    }

    @Deprecated
    public void showScaleMissingProxy(Formatter f) {
        f.format("has missing = %s%n", this.scaleMissingUnsignedProxy.hasMissing());
        if (this.scaleMissingUnsignedProxy.hasMissing()) {
            if (this.scaleMissingUnsignedProxy.hasMissingValue()) {
                f.format("   missing value(s) = ", new Object[0]);
                for (double d : this.scaleMissingUnsignedProxy.getMissingValues()) {
                    f.format(" %f", d);
                }
                f.format("%n", new Object[0]);
            }
            if (this.scaleMissingUnsignedProxy.hasFillValue()) {
                f.format("   fillValue = %f%n", this.scaleMissingUnsignedProxy.getFillValue());
            }
            if (this.scaleMissingUnsignedProxy.hasValidData()) {
                f.format("   valid min/max = [%f,%f]%n", this.scaleMissingUnsignedProxy.getValidMin(), this.scaleMissingUnsignedProxy.getValidMax());
            }
        }
        f.format("FillValue or default = %s%n", this.scaleMissingUnsignedProxy.getFillValue());
        f.format("%nhas scale/offset = %s%n", this.scaleMissingUnsignedProxy.hasScaleOffset());
        if (this.scaleMissingUnsignedProxy.hasScaleOffset()) {
            double offset = this.scaleMissingUnsignedProxy.applyScaleOffset(0.0);
            double scale = this.scaleMissingUnsignedProxy.applyScaleOffset(1.0) - offset;
            f.format("   scale_factor = %f add_offset = %f%n", scale, offset);
        }
        f.format("original data type = %s%n", new Object[]{this.orgDataType});
        f.format("converted data type = %s%n", new Object[]{this.getDataType()});
    }

    @Override
    public String getDescription() {
        return this.enhanceProxy.getDescription();
    }

    @Override
    public String getUnitsString() {
        return this.enhanceProxy.getUnitsString();
    }

    @Override
    public ImmutableList<CoordinateSystem> getCoordinateSystems() {
        return this.coordinateSystems == null ? ImmutableList.of() : this.coordinateSystems;
    }

    @Override
    @Deprecated
    public boolean hasScaleOffset() {
        return this.scaleMissingUnsignedProxy.hasScaleOffset();
    }

    @Override
    @Deprecated
    public double getScaleFactor() {
        return this.scaleMissingUnsignedProxy.getScaleFactor();
    }

    @Override
    @Deprecated
    public double getOffset() {
        return this.scaleMissingUnsignedProxy.getOffset();
    }

    @Override
    @Deprecated
    public boolean hasMissing() {
        return this.scaleMissingUnsignedProxy.hasMissing();
    }

    @Override
    @Deprecated
    public boolean isMissing(double val) {
        return this.scaleMissingUnsignedProxy.isMissing(val);
    }

    @Override
    public boolean hasValidData() {
        return this.scaleMissingUnsignedProxy.hasValidData();
    }

    @Override
    @Deprecated
    public double getValidMin() {
        return this.scaleMissingUnsignedProxy.getValidMin();
    }

    @Override
    @Deprecated
    public double getValidMax() {
        return this.scaleMissingUnsignedProxy.getValidMax();
    }

    @Override
    @Deprecated
    public boolean isInvalidData(double val) {
        return this.scaleMissingUnsignedProxy.isInvalidData(val);
    }

    @Override
    @Deprecated
    public boolean hasFillValue() {
        return this.scaleMissingUnsignedProxy.hasFillValue();
    }

    @Override
    @Deprecated
    public double getFillValue() {
        return this.scaleMissingUnsignedProxy.getFillValue();
    }

    @Override
    @Deprecated
    public boolean isFillValue(double val) {
        return this.scaleMissingUnsignedProxy.isFillValue(val);
    }

    @Override
    @Deprecated
    public boolean hasMissingValue() {
        return this.scaleMissingUnsignedProxy.hasMissingValue();
    }

    @Override
    @Deprecated
    public double[] getMissingValues() {
        return this.scaleMissingUnsignedProxy.getMissingValues();
    }

    @Override
    @Deprecated
    public boolean isMissingValue(double val) {
        return this.scaleMissingUnsignedProxy.isMissingValue(val);
    }

    @Override
    @Deprecated
    @Nullable
    public DataType getScaledOffsetType() {
        return this.scaleMissingUnsignedProxy.getScaledOffsetType();
    }

    @Override
    @Deprecated
    public DataType getUnsignedConversionType() {
        return this.scaleMissingUnsignedProxy.getUnsignedConversionType();
    }

    @Override
    @Deprecated
    public DataType.Signedness getSignedness() {
        return this.scaleMissingUnsignedProxy.getSignedness();
    }

    @Override
    @Deprecated
    public double applyScaleOffset(Number value) {
        return this.scaleMissingUnsignedProxy.applyScaleOffset(value);
    }

    @Override
    @Deprecated
    public ucar.ma2.Array applyScaleOffset(ucar.ma2.Array data) {
        return this.scaleMissingUnsignedProxy.applyScaleOffset(data);
    }

    @Override
    @Deprecated
    public Number convertUnsigned(Number value) {
        return this.scaleMissingUnsignedProxy.convertUnsigned(value);
    }

    @Override
    @Deprecated
    public ucar.ma2.Array convertUnsigned(ucar.ma2.Array in) {
        return this.scaleMissingUnsignedProxy.convertUnsigned(in);
    }

    @Override
    @Deprecated
    public Number convertMissing(Number value) {
        return this.scaleMissingUnsignedProxy.convertMissing(value);
    }

    @Override
    @Deprecated
    public ucar.ma2.Array convertMissing(ucar.ma2.Array in) {
        return this.scaleMissingUnsignedProxy.convertMissing(in);
    }

    @Override
    @Deprecated
    public ucar.ma2.Array convert(ucar.ma2.Array in, boolean convertUnsigned, boolean applyScaleOffset, boolean convertMissing) {
        return this.scaleMissingUnsignedProxy.convert(in, convertUnsigned, applyScaleOffset, convertMissing);
    }

    protected VariableDS(Builder<?> builder, Group parentGroup) {
        super(builder, parentGroup);
        this.enhanceMode = builder.enhanceMode != null ? builder.enhanceMode : EnumSet.noneOf(NetcdfDataset.Enhance.class);
        this.orgVar = builder.orgVar;
        this.orgDataType = builder.orgDataType;
        this.orgName = builder.orgName;
        Attribute units = builder.getAttributeContainer().findAttributeIgnoreCase("units");
        if (units != null && units.isString()) {
            builder.getAttributeContainer().addAttribute(Attribute.builder("units").setStringValue(units.getStringValue().trim()).build());
        }
        this.orgFileTypeId = builder.orgFileTypeId;
        this.enhanceProxy = new EnhancementsImpl(this, ((Builder)builder).units, builder.getDescription());
        this.scaleMissingUnsignedProxy = new EnhanceScaleMissingUnsignedImpl(this, this.enhanceMode);
        this.scaleMissingUnsignedProxy.setFillValueIsMissing(((Builder)builder).fillValueIsMissing);
        this.scaleMissingUnsignedProxy.setInvalidDataIsMissing(((Builder)builder).invalidDataIsMissing);
        this.scaleMissingUnsignedProxy.setMissingDataIsMissing(((Builder)builder).missingDataIsMissing);
        if (this.enhanceMode.contains((Object)NetcdfDataset.Enhance.ConvertEnums) && this.dataType.isEnum()) {
            this.dataType = ArrayType.STRING;
        }
        if (this.enhanceMode.contains((Object)NetcdfDataset.Enhance.ConvertUnsigned) && !this.dataType.isEnum()) {
            this.dataType = this.scaleMissingUnsignedProxy.getUnsignedConversionType().getArrayType();
        }
        if (this.enhanceMode.contains((Object)NetcdfDataset.Enhance.ApplyScaleOffset) && (this.dataType.isNumeric() || this.dataType == ArrayType.CHAR) && this.scaleMissingUnsignedProxy.hasScaleOffset()) {
            this.dataType = this.scaleMissingUnsignedProxy.getScaledOffsetType().getArrayType();
        }
        this.dataEnhancer = new DataEnhancer(this, this.scaleMissingUnsignedProxy);
    }

    public Builder<?> toBuilder() {
        return this.addLocalFieldsToBuilder(VariableDS.builder());
    }

    protected Builder<?> addLocalFieldsToBuilder(Builder<? extends Builder<?>> builder) {
        ((Builder)((Builder)((Builder)((Builder)((Builder)builder.setOriginalVariable(this.orgVar).setOriginalArrayType(this.orgDataType)).setOriginalName(this.orgName)).setOriginalFileTypeId(this.orgFileTypeId)).setEnhanceMode(this.enhanceMode)).setUnits(this.enhanceProxy.getUnitsString())).setDesc(this.enhanceProxy.getDescription());
        return (Builder)super.addLocalFieldsToBuilder(builder);
    }

    void setCoordinateSystems(CoordinatesHelper coords) {
        if (this.coordinateSystems != null) {
            throw new RuntimeException("Cant call twice");
        }
        this.coordinateSystems = coords.makeCoordinateSystemsFor(this);
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Variable.Builder<T> {
        public Set<NetcdfDataset.Enhance> enhanceMode = EnumSet.noneOf(NetcdfDataset.Enhance.class);
        public Variable orgVar;
        public ArrayType orgDataType;
        public String orgFileTypeId;
        String orgName;
        private String units;
        private String desc;
        private boolean invalidDataIsMissing = NetcdfDataset.invalidDataIsMissing;
        private boolean fillValueIsMissing = NetcdfDataset.fillValueIsMissing;
        private boolean missingDataIsMissing = NetcdfDataset.missingDataIsMissing;
        private boolean built;

        @Override
        protected abstract T self();

        public T setEnhanceMode(Set<NetcdfDataset.Enhance> enhanceMode) {
            this.enhanceMode = enhanceMode;
            return (T)this.self();
        }

        public T addEnhanceMode(Set<NetcdfDataset.Enhance> enhanceMode) {
            this.enhanceMode.addAll(enhanceMode);
            return (T)this.self();
        }

        public T setOriginalVariable(Variable orgVar) {
            this.orgVar = orgVar;
            return (T)this.self();
        }

        @Deprecated
        public T setOriginalDataType(DataType orgDataType) {
            this.orgDataType = orgDataType.getArrayType();
            return (T)this.self();
        }

        public T setOriginalArrayType(ArrayType orgDataType) {
            this.orgDataType = orgDataType;
            return (T)this.self();
        }

        public T setOriginalName(String orgName) {
            this.orgName = orgName;
            return (T)this.self();
        }

        public T setOriginalFileTypeId(String orgFileTypeId) {
            this.orgFileTypeId = orgFileTypeId;
            return (T)this.self();
        }

        public T setUnits(String units) {
            this.units = units;
            if (units != null) {
                this.units = units.trim();
                this.addAttribute(new Attribute("units", this.units));
            }
            return (T)this.self();
        }

        public T setDesc(String desc) {
            this.desc = desc;
            if (desc != null) {
                this.addAttribute(new Attribute("long_name", desc));
            }
            return (T)this.self();
        }

        public void setFillValueIsMissing(boolean b) {
            this.fillValueIsMissing = b;
        }

        public void setInvalidDataIsMissing(boolean b) {
            this.invalidDataIsMissing = b;
        }

        public void setMissingDataIsMissing(boolean b) {
            this.missingDataIsMissing = b;
        }

        @Override
        public Variable.Builder<?> copy() {
            return new Builder2().copyFrom(this);
        }

        @Override
        public T copyFrom(Variable orgVar) {
            super.copyFrom(orgVar);
            this.setSPobject(null);
            this.setOriginalVariable(orgVar);
            this.setOriginalArrayType(orgVar.getArrayType());
            this.setOriginalName(orgVar.getShortName());
            this.orgFileTypeId = orgVar.getFileTypeId();
            return (T)this.self();
        }

        @Override
        public T copyFrom(Builder<?> builder) {
            super.copyFrom(builder);
            this.setDesc(builder.desc);
            this.setEnhanceMode(builder.enhanceMode);
            this.setFillValueIsMissing(builder.fillValueIsMissing);
            this.setInvalidDataIsMissing(builder.invalidDataIsMissing);
            this.setMissingDataIsMissing(builder.missingDataIsMissing);
            this.orgVar = builder.orgVar;
            this.orgDataType = builder.orgDataType;
            this.orgFileTypeId = builder.orgFileTypeId;
            this.orgName = builder.orgName;
            this.setUnits(builder.units);
            return (T)this.self();
        }

        public String getUnits() {
            String result = this.units;
            if (result == null) {
                result = this.getAttributeContainer().findAttributeString("units", null);
            }
            if (result == null && this.orgVar != null) {
                result = this.orgVar.attributes().findAttributeString("units", null);
            }
            return result == null ? null : result.trim();
        }

        public String getDescription() {
            String result = this.desc;
            if (result == null) {
                result = this.getAttributeContainer().findAttributeString("long_name", null);
            }
            if (result == null && this.orgVar != null) {
                result = this.orgVar.attributes().findAttributeString("long_name", null);
            }
            return result == null ? null : result.trim();
        }

        @Override
        public VariableDS build(Group parentGroup) {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            return new VariableDS(this, parentGroup);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }
}

