/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import javax.annotation.concurrent.Immutable;
import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.internal.dataset.transform.vertical.VerticalTransformBuilder;
import ucar.unidata.geoloc.VerticalTransform;

@Immutable
public class VerticalCT
extends CoordinateTransform {
    private final Type type;
    private final VerticalTransformBuilder transformBuilder;

    protected VerticalCT(String name, String authority, Type type, AttributeContainer params) {
        super(name, authority, TransformType.Vertical, params);
        this.type = type;
        this.transformBuilder = null;
    }

    public Type getVerticalTransformType() {
        return this.type;
    }

    public VerticalTransform makeVerticalTransform(NetcdfDataset ds, Dimension timeDim) {
        return this.transformBuilder.makeMathTransform(ds, timeDim, this);
    }

    @Override
    public String toString() {
        return "VerticalCT {type=" + (Object)((Object)this.type) + ", builder=" + this.transformBuilder + '}';
    }

    protected VerticalCT(Builder<?> builder) {
        super(builder);
        this.type = builder.type;
        this.transformBuilder = ((Builder)builder).transformBuilder;
    }

    public Builder<?> toBuilder() {
        return this.addLocalFieldsToBuilder(VerticalCT.builder());
    }

    protected Builder<?> addLocalFieldsToBuilder(Builder<? extends Builder<?>> b) {
        b.setVerticalType(this.type).setTransformBuilder(this.transformBuilder);
        return (Builder)super.addLocalFieldsToBuilder(b);
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public static abstract class Builder<T extends Builder<T>>
    extends CoordinateTransform.Builder<T> {
        public Type type;
        private VerticalTransformBuilder transformBuilder;
        private boolean built;

        @Override
        protected abstract T self();

        public Builder<?> setVerticalType(Type type) {
            this.type = type;
            return this.self();
        }

        public Builder<?> setTransformBuilder(VerticalTransformBuilder transformBuilder) {
            this.transformBuilder = transformBuilder;
            return this.self();
        }

        @Override
        public VerticalCT build() {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            return new VerticalCT(this);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    public static enum Type {
        HybridSigmaPressure("atmosphere_hybrid_sigma_pressure_coordinate"),
        HybridHeight("atmosphere_hybrid_height_coordinate"),
        LnPressure("atmosphere_ln_pressure_coordinate"),
        OceanSigma("ocean_sigma_coordinate"),
        OceanS("ocean_s_coordinate"),
        Sleve("atmosphere_sleve_coordinate"),
        Sigma("atmosphere_sigma_coordinate"),
        OceanSG1("ocean_s_g1"),
        OceanSG2("ocean_s_g2"),
        Existing3DField("Existing3DField"),
        WRFEta("WRFEta");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public static Type getType(String name) {
            for (Type t : Type.values()) {
                if (!t.name.equalsIgnoreCase(name)) continue;
                return t;
            }
            return null;
        }

        public String toString() {
            return this.name;
        }
    }
}

