/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.util.Iterator;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.CollectionInfo;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;

public abstract class PointIteratorAbstract
implements PointFeatureIterator,
Iterator<PointFeature> {
    protected boolean calcBounds;
    protected CollectionInfo info;
    private LatLonRect.Builder bb;
    private double minTime = Double.MAX_VALUE;
    private double maxTime = -1.7976931348623157E308;
    private int count;

    protected PointIteratorAbstract() {
    }

    public void setCalculateBounds(CollectionInfo info) {
        this.calcBounds = info != null;
        this.info = info;
    }

    protected void calcBounds(PointFeature pf) {
        ++this.count;
        if (!this.calcBounds) {
            return;
        }
        if (pf == null) {
            return;
        }
        if (this.bb == null) {
            this.bb = new LatLonRect.Builder(pf.getLocation().getLatLon(), 0.001, 0.001);
        } else {
            this.bb.extend(pf.getLocation().getLatLon());
        }
        double obsTime = pf.getObservationTime();
        this.minTime = Math.min(this.minTime, obsTime);
        this.maxTime = Math.max(this.maxTime, obsTime);
    }

    protected void finishCalcBounds() {
        if (!this.calcBounds || this.bb == null) {
            return;
        }
        LatLonRect llrect = this.bb.build();
        if (llrect.crossDateline() && llrect.getWidth() > 350.0) {
            double lat_min = llrect.getLowerLeftPoint().getLatitude();
            double deltaLat = llrect.getUpperLeftPoint().getLatitude() - lat_min;
            llrect = new LatLonRect.Builder(LatLonPoint.create(lat_min, -180.0), deltaLat, 360.0).build();
        }
        this.info.bbox = llrect;
        this.info.minTime = this.minTime;
        this.info.maxTime = this.maxTime;
        this.info.nobs = this.count;
        this.info.nfeatures = this.count;
        this.info.setComplete();
    }
}

