/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import ucar.nc2.ft.IOIterator;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.PointIteratorAbstract;
import ucar.nc2.ft.point.PointIteratorFiltered;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.LatLonRect;

public class PointIteratorFlatten
extends PointIteratorAbstract {
    private final IOIterator<PointFeatureCollection> collectionIter;
    private PointFeatureIterator.Filter filter;
    private PointFeatureCollection currCollection;
    private PointFeatureIterator pfiter;
    private PointFeature pointFeature;
    private boolean finished;

    PointIteratorFlatten(IOIterator<PointFeatureCollection> collectionIter, LatLonRect filter_bb, CalendarDateRange filter_date) {
        this.collectionIter = collectionIter;
        if (filter_bb != null || filter_date != null) {
            this.filter = new PointIteratorFiltered.SpaceAndTimeFilter(filter_bb, filter_date);
        }
    }

    @Override
    public void close() {
        if (this.finished) {
            return;
        }
        if (this.pfiter != null) {
            this.pfiter.close();
        }
        this.finishCalcBounds();
        this.finished = true;
    }

    @Override
    public boolean hasNext() {
        try {
            this.pointFeature = this.nextFilteredDataPoint();
            if (this.pointFeature != null) {
                return true;
            }
            PointFeatureCollection feature = this.nextCollection();
            if (feature == null) {
                this.close();
                return false;
            }
            this.currCollection = feature;
            this.pfiter = feature.getPointFeatureIterator();
            return this.hasNext();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public PointFeature next() {
        if (this.pointFeature == null) {
            return null;
        }
        this.calcBounds(this.pointFeature);
        return this.pointFeature;
    }

    private PointFeatureCollection nextCollection() throws IOException {
        if (!this.collectionIter.hasNext()) {
            return null;
        }
        return this.collectionIter.next();
    }

    private PointFeature nextFilteredDataPoint() {
        if (this.pfiter == null) {
            return null;
        }
        if (!this.pfiter.hasNext()) {
            return null;
        }
        PointFeature pdata = this.pfiter.next();
        if (this.filter == null) {
            return pdata;
        }
        while (!this.filter.filter(pdata)) {
            if (!this.pfiter.hasNext()) {
                return null;
            }
            pdata = this.pfiter.next();
        }
        return pdata;
    }
}

