/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.FlattenedDatasetPointCollection;
import ucar.nc2.ft.point.PointIteratorAdapter;
import ucar.nc2.ft.point.StationFeatureCopyFactory;
import ucar.nc2.ft.point.StationPointFeature;
import ucar.nc2.units.DateUnit;

public class SortingStationPointFeatureCache {
    public static final Comparator<StationPointFeature> stationNameComparator = Comparator.comparing(pointFeat -> pointFeat.getAsStationFeature().getStation().getName());
    private final SortedMap<StationPointFeature, List<StationPointFeature>> inMemCache;
    private volatile StationFeatureCopyFactory stationFeatCopyFactory;

    public SortingStationPointFeatureCache() {
        this(stationNameComparator);
    }

    public SortingStationPointFeatureCache(Comparator<StationPointFeature> comp) {
        this.inMemCache = new TreeMap<StationPointFeature, List<StationPointFeature>>((Comparator)Preconditions.checkNotNull(comp, (Object)"comp == null"));
    }

    public SortingStationPointFeatureCache(Comparator<StationPointFeature> comp, StationPointFeature proto, DateUnit dateUnit) throws IOException {
        this.inMemCache = new TreeMap<StationPointFeature, List<StationPointFeature>>((Comparator)Preconditions.checkNotNull(comp, (Object)"comp == null"));
        if (proto != null && dateUnit != null) {
            this.stationFeatCopyFactory = new StationFeatureCopyFactory(proto);
        }
    }

    public void add(StationPointFeature feat) throws IOException {
        Preconditions.checkNotNull((Object)feat, (Object)"feat == null");
        StationPointFeature featCopy = this.getStationFeatureCopyFactory(feat).deepCopy(feat);
        List bucket = this.inMemCache.computeIfAbsent(featCopy, k -> new LinkedList());
        bucket.add(featCopy);
    }

    public void addAll(File datasetFile) throws IOException {
        try (FeatureDatasetPoint fdPoint = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(FeatureType.STATION, datasetFile.getAbsolutePath(), null, new Formatter());){
            this.addAll(fdPoint);
        }
    }

    public void addAll(FeatureDatasetPoint fdPoint) throws IOException {
        try (PointFeatureIterator pointFeatIter = new FlattenedDatasetPointCollection(fdPoint).getPointFeatureIterator();){
            while (pointFeatIter.hasNext()) {
                StationPointFeature pointFeat = (StationPointFeature)pointFeatIter.next();
                this.add(pointFeat);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StationFeatureCopyFactory getStationFeatureCopyFactory(StationPointFeature proto) throws IOException {
        if (this.stationFeatCopyFactory == null) {
            SortingStationPointFeatureCache sortingStationPointFeatureCache = this;
            synchronized (sortingStationPointFeatureCache) {
                if (this.stationFeatCopyFactory == null) {
                    this.stationFeatCopyFactory = this.createStationFeatureCopyFactory(proto);
                }
            }
        }
        assert (this.stationFeatCopyFactory != null) : "We screwed this up.";
        return this.stationFeatCopyFactory;
    }

    private StationFeatureCopyFactory createStationFeatureCopyFactory(StationPointFeature proto) throws IOException {
        return new StationFeatureCopyFactory(proto);
    }

    public PointFeatureIterator getPointFeatureIterator() {
        return new PointIteratorAdapter(new Iter());
    }

    private class Iter
    implements Iterator<StationPointFeature> {
        private final Iterator<List<StationPointFeature>> bucketsIter;
        private Iterator<StationPointFeature> featsIter;

        public Iter() {
            this.bucketsIter = SortingStationPointFeatureCache.this.inMemCache.values().iterator();
        }

        @Override
        public boolean hasNext() {
            while (this.featsIter == null || !this.featsIter.hasNext()) {
                if (!this.bucketsIter.hasNext()) {
                    return false;
                }
                this.featsIter = this.bucketsIter.next().iterator();
            }
            assert (this.featsIter != null && this.featsIter.hasNext());
            return true;
        }

        @Override
        public StationPointFeature next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("There are no more elements.");
            }
            return this.featsIter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation not supported by this iterator.");
        }
    }
}

