/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import ucar.nc2.ft.point.StationFeature;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

public class StationHelper {
    private List<StationFeature> stations = new ArrayList<StationFeature>();
    private Map<String, StationFeature> stationHash = new HashMap<String, StationFeature>();
    private static final boolean debug = false;
    private LatLonRect rect;

    public void addStation(StationFeature s) {
        this.stations.add(s);
        this.stationHash.put(s.getStation().getName(), s);
    }

    public void setStations(List<StationFeature> nstations) {
        this.stations = new ArrayList<StationFeature>();
        this.stationHash = new HashMap<String, StationFeature>();
        for (StationFeature s : nstations) {
            this.addStation(s);
        }
    }

    @Nullable
    public LatLonRect getBoundingBox() {
        if (this.rect == null) {
            if (this.stations.isEmpty()) {
                return null;
            }
            Station s = this.stations.get(0).getStation();
            LatLonRect.Builder builder = new LatLonRect.Builder(s.getLatitude(), s.getLongitude());
            for (int i = 1; i < this.stations.size(); ++i) {
                s = this.stations.get(i).getStation();
                builder.extend(LatLonPoint.create(s.getLatitude(), s.getLongitude()));
            }
            builder = builder.extendToAllLongitudes(350.0).expand(5.0E-4);
            this.rect = builder.build();
        }
        return this.rect;
    }

    public List<Station> getStations(LatLonRect boundingBox) {
        if (boundingBox == null) {
            return this.getStations();
        }
        ArrayList<Station> result = new ArrayList<Station>();
        for (StationFeature sf : this.stations) {
            Station s = sf.getStation();
            LatLonPoint latlonPt = LatLonPoint.create(s.getLatitude(), s.getLongitude());
            if (!boundingBox.contains(latlonPt)) continue;
            result.add(s);
        }
        return result;
    }

    public List<StationFeature> getStationFeatures(LatLonRect boundingBox) {
        if (boundingBox == null) {
            return this.stations;
        }
        ArrayList<StationFeature> result = new ArrayList<StationFeature>();
        for (StationFeature sf : this.stations) {
            Station s = sf.getStation();
            LatLonPoint latlonPt = LatLonPoint.create(s.getLatitude(), s.getLongitude());
            if (!boundingBox.contains(latlonPt)) continue;
            result.add(sf);
        }
        return result;
    }

    public StationFeature getStation(String name) {
        return this.stationHash.get(name);
    }

    public List<StationFeature> getStationFeatures() {
        return this.stations;
    }

    public List<Station> getStations() {
        return this.stations.stream().map(sf -> sf.getStation()).collect(Collectors.toList());
    }

    public List<StationFeature> getStationFeaturesFromNames(List<String> stnNames) {
        ArrayList<StationFeature> result = new ArrayList<StationFeature>(stnNames.size());
        for (String ss : stnNames) {
            StationFeature s = this.stationHash.get(ss);
            if (s == null) continue;
            result.add(s);
        }
        return result;
    }

    public List<StationFeature> getStationFeatures(List<Station> stations) {
        ArrayList<StationFeature> result = new ArrayList<StationFeature>(stations.size());
        for (Station s : stations) {
            StationFeature ss = this.stationHash.get(s.getName());
            if (ss == null) continue;
            result.add(ss);
        }
        return result;
    }

    public StationFeature getStationFeature(Station stn) {
        return this.stationHash.get(stn.getName());
    }

    public List<Station> getStations(List<String> stnNames) {
        ArrayList<Station> result = new ArrayList<Station>(stnNames.size());
        for (String ss : stnNames) {
            StationFeature sf = this.stationHash.get(ss);
            if (sf == null) continue;
            result.add(sf.getStation());
        }
        return result;
    }

    public StationHelper subset(LatLonRect bb) {
        StationHelper result = new StationHelper();
        result.setStations(this.getStationFeatures(bb));
        return result;
    }

    public StationHelper subset(List<StationFeature> stns) {
        StationHelper result = new StationHelper();
        result.setStations(stns);
        return result;
    }
}

