/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import ucar.ma2.StructureData;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.IOIterator;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.StationProfileFeature;
import ucar.nc2.ft.point.PointCollectionIteratorFiltered;
import ucar.nc2.ft.point.PointFeatureCCImpl;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDateUnit;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

public abstract class StationProfileFeatureImpl
extends PointFeatureCCImpl
implements StationProfileFeature {
    protected int timeSeriesNpts;
    protected StationFeature stationFeature;
    protected PointFeatureCollectionIterator localIterator;

    public StationProfileFeatureImpl(StationFeature s, CalendarDateUnit timeUnit, String altUnits, int npts) {
        super(s.getStation().getName(), timeUnit, altUnits, FeatureType.STATION_PROFILE);
        this.stationFeature = s;
        this.timeSeriesNpts = npts;
    }

    @Override
    public int getNobs() {
        return this.timeSeriesNpts;
    }

    @Override
    public Station getStation() {
        return this.stationFeature.getStation();
    }

    @Override
    public int size() {
        return this.timeSeriesNpts;
    }

    public StationProfileFeature subset(LatLonRect boundingBox) {
        return this;
    }

    @Override
    public StationProfileFeature subset(CalendarDateRange dateRange) {
        return new StationProfileFeatureSubset(this, dateRange);
    }

    @Override
    public Iterator<ProfileFeature> iterator() {
        return new ProfileFeatureIterator();
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.localIterator == null) {
            this.resetIteration();
        }
        return this.localIterator.hasNext();
    }

    @Override
    public ProfileFeature next() throws IOException {
        return (ProfileFeature)this.localIterator.next();
    }

    @Override
    public void resetIteration() throws IOException {
        this.localIterator = this.getPointFeatureCollectionIterator();
    }

    private class ProfileFeatureIterator
    implements Iterator<ProfileFeature> {
        PointFeatureCollectionIterator pfIterator;

        public ProfileFeatureIterator() {
            try {
                this.pfIterator = StationProfileFeatureImpl.this.getPointFeatureCollectionIterator();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            try {
                return this.pfIterator.hasNext();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public ProfileFeature next() {
            try {
                return (ProfileFeature)this.pfIterator.next();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class StationProfileFeatureSubset
    extends StationProfileFeatureImpl {
        private final StationProfileFeature from;
        private final CalendarDateRange dateRange;

        public StationProfileFeatureSubset(StationProfileFeatureImpl from, CalendarDateRange filter_date) {
            super(from.stationFeature, from.getTimeUnit(), from.getAltUnits(), -1);
            this.from = from;
            this.dateRange = filter_date;
        }

        @Override
        @Nonnull
        public StructureData getFeatureData() throws IOException {
            return this.from.getFeatureData();
        }

        @Override
        public List<CalendarDate> getTimes() {
            ArrayList<CalendarDate> result = new ArrayList<CalendarDate>();
            for (ProfileFeature pf : this) {
                if (!this.dateRange.includes(pf.getTime())) continue;
                result.add(pf.getTime());
            }
            return result;
        }

        @Override
        public ProfileFeature getProfileByDate(CalendarDate date) throws IOException {
            return this.from.getProfileByDate(date);
        }

        @Override
        public IOIterator<PointFeatureCollection> getCollectionIterator() throws IOException {
            return new PointCollectionIteratorFiltered(this.from.getPointFeatureCollectionIterator(), new DateFilter());
        }

        @Override
        public PointFeatureCollectionIterator getPointFeatureCollectionIterator() throws IOException {
            return new PointCollectionIteratorFiltered(this.from.getPointFeatureCollectionIterator(), new DateFilter());
        }

        private class DateFilter
        implements PointFeatureCollectionIterator.Filter {
            private DateFilter() {
            }

            @Override
            public boolean filter(PointFeatureCollection pointFeatureCollection) {
                ProfileFeature profileFeature = (ProfileFeature)pointFeatureCollection;
                return StationProfileFeatureSubset.this.dateRange.includes(profileFeature.getTime());
            }
        }
    }
}

