/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard.plug;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Formatter;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.point.standard.PointConfigXML;
import ucar.nc2.ft.point.standard.TableConfig;
import ucar.nc2.ft.point.standard.TableConfigurerImpl;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.units.SimpleUnit;

public class SimpleTrajectory
extends TableConfigurerImpl {
    private static final String timeDimName = "time";
    private static final String timeVarName = "time";
    private static final String latVarName = "latitude";
    private static final String lonVarName = "longitude";
    private static final String elevVarName = "altitude";

    @Override
    public boolean isMine(FeatureType wantFeatureType, NetcdfDataset ds) {
        ImmutableList<Dimension> list = ds.getRootGroup().getDimensions();
        if (list.size() != 1) {
            return false;
        }
        Dimension d = (Dimension)list.get(0);
        if (!d.getShortName().equals("time")) {
            return false;
        }
        Variable timeVar = ds.getRootGroup().findVariableLocal("time");
        if (timeVar == null) {
            return false;
        }
        list = timeVar.getDimensions();
        if (list.size() != 1) {
            return false;
        }
        d = (Dimension)list.get(0);
        if (!d.getShortName().equals("time")) {
            return false;
        }
        String units = timeVar.findAttributeString("units", "");
        try {
            CalendarDateUnit.withCalendar(null, units);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        Variable latVar = ds.getRootGroup().findVariableLocal(latVarName);
        if (latVar == null) {
            return false;
        }
        list = latVar.getDimensions();
        if (list.size() != 1) {
            return false;
        }
        d = (Dimension)list.get(0);
        if (!d.getShortName().equals("time")) {
            return false;
        }
        units = latVar.findAttribute("units").getStringValue();
        if (!SimpleUnit.isCompatible(units, "degrees_north")) {
            return false;
        }
        Variable lonVar = ds.getRootGroup().findVariableLocal(lonVarName);
        if (lonVar == null) {
            return false;
        }
        list = lonVar.getDimensions();
        if (list.size() != 1) {
            return false;
        }
        d = (Dimension)list.get(0);
        if (!d.getShortName().equals("time")) {
            return false;
        }
        units = lonVar.findAttribute("units").getStringValue();
        if (!SimpleUnit.isCompatible(units, "degrees_east")) {
            return false;
        }
        Variable elevVar = ds.getRootGroup().findVariableLocal(elevVarName);
        if (elevVar == null) {
            return false;
        }
        list = elevVar.getDimensions();
        if (list.size() != 1) {
            return false;
        }
        d = (Dimension)list.get(0);
        if (!d.getShortName().equals("time")) {
            return false;
        }
        units = elevVar.findAttribute("units").getStringValue();
        return SimpleUnit.isCompatible(units, "meters");
    }

    @Override
    public TableConfig getConfig(FeatureType wantFeatureType, NetcdfDataset ds, Formatter errlog) throws IOException {
        PointConfigXML reader = new PointConfigXML();
        return reader.readConfigXMLfromResource("resources/nj22/pointConfig/SimpleTrajectory.xml", wantFeatureType, ds, errlog);
    }
}

