/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Formatter;
import javax.annotation.Nonnull;
import ucar.array.ArrayType;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.IsMissingEvaluator;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.AttributeContainerMutable;
import ucar.nc2.Dimension;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordSys;
import ucar.nc2.ft2.coverage.CoverageReader;
import ucar.nc2.ft2.coverage.GeoReferencedArray;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.util.Indent;
import ucar.unidata.geoloc.ProjectionRect;

public class Coverage
implements VariableSimpleIF,
IsMissingEvaluator {
    private final String name;
    private final DataType dataType;
    private final AttributeContainerMutable atts;
    private final String units;
    private final String description;
    private final String coordSysName;
    protected final CoverageReader reader;
    protected final Object user;
    private CoverageCoordSys coordSys;

    public Coverage(String name, DataType dataType, Iterable<Attribute> atts, String coordSysName, String units, String description, CoverageReader reader, Object user) {
        this.name = name;
        this.dataType = dataType;
        this.atts = new AttributeContainerMutable(name, atts);
        this.coordSysName = coordSysName;
        this.units = units;
        this.description = description;
        this.reader = reader;
        this.user = user;
    }

    public Coverage(Coverage from, CoverageCoordSys coordSysSubset) {
        this.name = from.getName();
        this.dataType = from.getDataType();
        this.atts = from.atts;
        this.units = from.getUnitsString();
        this.description = from.getDescription();
        this.coordSysName = coordSysSubset != null ? coordSysSubset.getName() : from.coordSysName;
        this.reader = from.reader;
        this.user = from.user;
    }

    void setCoordSys(CoverageCoordSys coordSys) {
        if (this.coordSys != null) {
            throw new RuntimeException("Cant change coordSys once set");
        }
        this.coordSys = coordSys;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public ArrayType getArrayType() {
        return this.dataType.getArrayType();
    }

    @Override
    public AttributeContainer attributes() {
        return this.atts;
    }

    @Override
    public String getUnitsString() {
        return this.units;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getCoordSysName() {
        return this.coordSysName;
    }

    public Object getUserObject() {
        return this.user;
    }

    public String toString() {
        Formatter f = new Formatter();
        Indent indent = new Indent(2);
        this.toString(f, indent);
        return f.toString();
    }

    public void toString(Formatter f, Indent indent) {
        indent.incr();
        f.format("%n%s  %s %s(%s) desc='%s' units='%s'%n", new Object[]{indent, this.dataType, this.name, this.coordSysName, this.description, this.units});
        f.format("%s    attributes:%n", indent);
        for (Attribute att : this.atts) {
            f.format("%s     %s%n", indent, att);
        }
        indent.decr();
    }

    @Nonnull
    public CoverageCoordSys getCoordSys() {
        return this.coordSys;
    }

    public ProjectionRect getBoundingBox() {
        return this.getCoordSys().getHorizCoordSys().calcProjectionBoundingBox();
    }

    public long getSizeInBytes() {
        Section section = new Section(this.coordSys.getShape());
        return section.computeSize() * (long)this.getDataType().getSize();
    }

    public String getIndependentAxisNamesOrdered() {
        StringBuilder sb = new StringBuilder();
        for (CoverageCoordAxis axis : this.coordSys.getAxes()) {
            if (axis.getDependenceType() != CoverageCoordAxis.DependenceType.independent) continue;
            sb.append(axis.getName());
            sb.append(" ");
        }
        return sb.toString();
    }

    @Override
    public boolean hasMissing() {
        return true;
    }

    @Override
    public boolean isMissing(double val) {
        return Double.isNaN(val);
    }

    public GeoReferencedArray readData(SubsetParams subset) throws IOException, InvalidRangeException {
        return this.reader.readData(this, subset, false);
    }

    @Override
    public String getFullName() {
        return this.getName();
    }

    @Override
    public String getShortName() {
        return this.getName();
    }

    @Override
    public int getRank() {
        return this.getShape().length;
    }

    @Override
    public int[] getShape() {
        return this.coordSys.getShape();
    }

    @Override
    public ImmutableList<Dimension> getDimensions() {
        return null;
    }

    @Override
    public int compareTo(@Nonnull VariableSimpleIF o) {
        return this.getFullName().compareTo(o.getFullName());
    }
}

