/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.remote.CdmrFeatureDataset;
import ucar.nc2.ft2.coverage.FeatureDatasetCoverage;
import ucar.nc2.ft2.coverage.adapter.DtCoverageAdapter;
import ucar.nc2.ft2.coverage.adapter.DtCoverageDataset;

public class CoverageDatasetFactory {
    public static Optional<FeatureDatasetCoverage> openCoverageDataset(String endpoint, Formatter errLog) throws IOException {
        DtCoverageDataset gds;
        if (endpoint.startsWith("cdmrFeature:")) {
            Optional<FeatureDataset> opt = CdmrFeatureDataset.factory(FeatureType.COVERAGE, endpoint, errLog);
            return opt.map(featureDataset -> (FeatureDatasetCoverage)featureDataset);
        }
        DatasetUrl durl = DatasetUrl.findDatasetUrl(endpoint);
        if (durl.getServiceType() == null) {
            GribCoverageOpenAttempt gribCoverage = CoverageDatasetFactory.openGrib(endpoint, errLog);
            if (gribCoverage.isGrib) {
                if (gribCoverage.coverage != null) {
                    return Optional.of(gribCoverage.coverage);
                }
                return Optional.empty();
            }
        }
        if (!(gds = DtCoverageDataset.open(durl)).getGrids().isEmpty()) {
            Formatter errlog = new Formatter();
            FeatureDatasetCoverage result = DtCoverageAdapter.factory(gds, errlog);
            return Optional.of(result);
        }
        errLog.format("Could not open as Coverage: %s", endpoint);
        return Optional.empty();
    }

    @Nullable
    public static FeatureDatasetCoverage open(String endpoint) throws IOException {
        Optional<FeatureDatasetCoverage> opt = CoverageDatasetFactory.openCoverageDataset(endpoint, new Formatter());
        return opt.orElse(null);
    }

    public static GribCoverageOpenAttempt openGrib(String endpoint, Formatter errLog) {
        List<Object> notGribThrowables = Arrays.asList(IllegalAccessException.class, IllegalArgumentException.class, ClassNotFoundException.class, NoSuchMethodException.class, NoSuchMethodError.class);
        try {
            Class<?> c = CoverageDatasetFactory.class.getClassLoader().loadClass("ucar.nc2.grib.coverage.GribCoverageDataset");
            Method method = c.getMethod("open", String.class, Formatter.class);
            Formatter gribErrlog = new Formatter();
            Optional result = (Optional)method.invoke(null, endpoint, gribErrlog);
            if (result.isPresent()) {
                return new GribCoverageOpenAttempt((FeatureDatasetCoverage)result.get(), true);
            }
            if (!gribErrlog.toString().isEmpty()) {
                errLog.format("%s", gribErrlog);
                return new GribCoverageOpenAttempt(null, true);
            }
            return new GribCoverageOpenAttempt(null, false);
        }
        catch (Exception e) {
            for (Object noGrib : notGribThrowables) {
                boolean notGribBuried;
                boolean notGribTopLevel = e.getClass().equals(noGrib);
                boolean bl = notGribBuried = e.getClass().equals(InvocationTargetException.class) && e.getCause() != null && e.getCause().getClass().equals(noGrib);
                if (!notGribTopLevel && !notGribBuried) continue;
                return new GribCoverageOpenAttempt(null, false);
            }
            if (e.getCause() != null) {
                errLog.format("%s", e.getCause().getMessage());
            }
            return new GribCoverageOpenAttempt(null, true);
        }
    }

    public static Optional<FeatureDatasetCoverage> openNcmlString(String ncml) throws IOException {
        NetcdfDataset ncd = NetcdfDatasets.openNcmlDataset(new StringReader(ncml), null, null);
        DtCoverageDataset gds = new DtCoverageDataset(ncd);
        if (!gds.getGrids().isEmpty()) {
            Formatter errlog = new Formatter();
            FeatureDatasetCoverage cc = DtCoverageAdapter.factory(gds, errlog);
            return Optional.of(cc);
        }
        return Optional.empty();
    }

    public static class GribCoverageOpenAttempt {
        public FeatureDatasetCoverage coverage;
        public boolean isGrib;

        GribCoverageOpenAttempt(FeatureDatasetCoverage coverage, boolean isGrib) {
            this.coverage = coverage;
            this.isGrib = isGrib;
        }
    }
}

