/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage;

import java.util.Formatter;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.internal.dataset.CoordTransformFactory;
import ucar.nc2.internal.dataset.transform.horiz.HorizTransformBuilderIF;
import ucar.nc2.util.Indent;
import ucar.unidata.geoloc.Projection;

@Immutable
public class CoverageTransform {
    private static final Logger log = LoggerFactory.getLogger(CoverageTransform.class);
    private final String name;
    private final AttributeContainer attributes;
    private final boolean isHoriz;
    private Projection projection;

    public CoverageTransform(String name, AttributeContainer attributes, boolean isHoriz) {
        this.name = name;
        this.attributes = attributes;
        this.isHoriz = isHoriz;
    }

    public boolean isHoriz() {
        return this.isHoriz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Projection getProjection() {
        CoverageTransform coverageTransform = this;
        synchronized (coverageTransform) {
            if (this.projection == null && this.isHoriz) {
                this.projection = CoverageTransform.makeProjection(this, new Formatter());
            }
            return this.projection;
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        Formatter f = new Formatter();
        Indent indent = new Indent(2);
        this.toString(f, indent);
        return f.toString();
    }

    public void toString(Formatter f, Indent indent) {
        indent.incr();
        f.format("%s CoordTransform '%s'", indent, this.name);
        f.format(" isHoriz: %s%n", this.isHoriz());
        if (this.projection != null) {
            f.format(" projection: %s%n", this.projection);
        }
        for (Attribute att : this.attributes) {
            f.format("%s     %s%n", indent, att);
        }
        f.format("%n", new Object[0]);
        indent.decr();
    }

    public AttributeContainer attributes() {
        return this.attributes;
    }

    @Nullable
    public static Projection makeProjection(CoverageTransform gct, Formatter errInfo) {
        HorizTransformBuilderIF builder;
        String transformName = gct.attributes().findAttributeString("grid_mapping_name", null);
        if (null == transformName) {
            errInfo.format("**Failed to find Coordinate Transform name from GridCoordTransform= %s%n", gct);
            return null;
        }
        Class<?> builderClass = CoordTransformFactory.getBuilderClassFor(transformName = transformName.trim());
        if (null == builderClass) {
            errInfo.format("**Failed to find CoordTransBuilder name= %s from GridCoordTransform= %s%n", transformName, gct);
            return null;
        }
        try {
            builder = (HorizTransformBuilderIF)builderClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("Cant create new instance " + builderClass.getName(), (Throwable)e);
            return null;
        }
        String units = gct.attributes().findAttributeString("units", null);
        builder.setErrorBuffer(errInfo);
        ProjectionCT.Builder<?> ct = builder.makeCoordinateTransform(gct.attributes(), units);
        if (ct == null) {
            return null;
        }
        return ct.build().getProjection();
    }
}

