/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage;

import java.util.Formatter;
import java.util.List;
import java.util.stream.Collectors;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IsMissingEvaluator;
import ucar.ma2.Section;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft2.coverage.CoordSysContainer;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordSys;
import ucar.nc2.ft2.coverage.CoverageTransform;

public class GeoReferencedArray
implements IsMissingEvaluator,
CoordSysContainer {
    private final String coverageName;
    private final DataType dataType;
    private Array data;
    private final CoverageCoordSys csSubset;
    private final List<CoverageCoordAxis> axes;
    private final List<CoverageTransform> transforms;

    public GeoReferencedArray(String coverageName, DataType dataType, Array data, List<CoverageCoordAxis> axes, List<CoverageTransform> transforms, FeatureType type) {
        this.coverageName = coverageName;
        this.dataType = dataType;
        this.data = data;
        this.axes = axes;
        this.transforms = transforms;
        List<String> names = axes.stream().map(CoverageCoordAxis::getName).collect(Collectors.toList());
        this.csSubset = new CoverageCoordSys(null, names, null, type);
        this.csSubset.setDataset(this);
        this.csSubset.setHorizCoordSys(this.csSubset.makeHorizCoordSys());
        Section cs = new Section(this.csSubset.getShape());
        Section sdata = new Section(data.getShape());
        assert (cs.conformal(sdata));
        if (!cs.equalShape(sdata)) {
            this.data = data.reshape(this.csSubset.getShape());
        }
    }

    public GeoReferencedArray(String coverageName, DataType dataType, Array data, CoverageCoordSys csSubset) {
        this.coverageName = coverageName;
        this.dataType = dataType;
        this.data = data;
        this.csSubset = csSubset;
        this.axes = csSubset.getAxes();
        this.transforms = csSubset.getTransforms();
    }

    public String getCoverageName() {
        return this.coverageName;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Array getData() {
        return this.data;
    }

    public CoverageCoordSys getCoordSysForData() {
        return this.csSubset;
    }

    @Override
    public boolean hasMissing() {
        return true;
    }

    @Override
    public boolean isMissing(double val) {
        return Double.isNaN(val);
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("GeoReferencedArray {%n", new Object[0]);
        f.format(" coverageName='%s'%n", this.coverageName);
        f.format(" dataType=%s%n", new Object[]{this.dataType});
        f.format(" csSubset=%s%n", this.csSubset);
        for (CoverageCoordAxis axis : this.axes) {
            f.format("%n%s", axis);
        }
        f.format("}", new Object[0]);
        return f.toString();
    }

    @Override
    public CoverageTransform findCoordTransform(String want) {
        for (CoverageTransform t : this.transforms) {
            if (!t.getName().equals(want)) continue;
            return t;
        }
        return null;
    }

    @Override
    public CoverageCoordAxis findCoordAxis(String want) {
        for (CoverageCoordAxis axis : this.axes) {
            if (!axis.getName().equals(want)) continue;
            return axis;
        }
        return null;
    }
}

