/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.ArrayDouble;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.ma2.RangeIterator;
import ucar.nc2.ft2.coverage.CoordAxisHelper;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.ft2.coverage.CoverageCoordAxisBuilder;
import ucar.nc2.ft2.coverage.CoverageTransform;
import ucar.nc2.ft2.coverage.HorizCoordSys2D;
import ucar.nc2.ft2.coverage.LatLonAxis2D;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPoints;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionRect;

@Immutable
public class HorizCoordSys {
    private static final Logger logger = LoggerFactory.getLogger(HorizCoordSys.class);
    private final CoverageCoordAxis1D xAxis;
    private final CoverageCoordAxis1D yAxis;
    private final CoverageCoordAxis1D latAxis;
    private final CoverageCoordAxis1D lonAxis;
    protected final LatLonAxis2D latAxis2D;
    protected final LatLonAxis2D lonAxis2D;
    private final CoverageTransform transform;
    private final boolean isProjection;
    private final boolean isLatLon1D;
    private boolean isLatLon2D;

    public static HorizCoordSys factory(CoverageCoordAxis1D xAxis, CoverageCoordAxis1D yAxis, CoverageCoordAxis latAxis, CoverageCoordAxis lonAxis, CoverageTransform transform) {
        boolean has2DlatLon;
        boolean isProjection = xAxis != null && yAxis != null && transform != null;
        boolean hasLatLon = latAxis != null && lonAxis != null;
        boolean bl = has2DlatLon = latAxis instanceof LatLonAxis2D && lonAxis instanceof LatLonAxis2D;
        if (!isProjection && !hasLatLon) {
            throw new IllegalArgumentException("must have horiz coordinates (x,y,projection or lat,lon)");
        }
        if (!isProjection && has2DlatLon) {
            return new HorizCoordSys2D((LatLonAxis2D)latAxis, (LatLonAxis2D)lonAxis);
        }
        return new HorizCoordSys(xAxis, yAxis, latAxis, lonAxis, transform);
    }

    protected HorizCoordSys(CoverageCoordAxis1D xAxis, CoverageCoordAxis1D yAxis, CoverageCoordAxis latAxis, CoverageCoordAxis lonAxis, CoverageTransform transform) {
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.transform = transform;
        this.isProjection = xAxis != null && yAxis != null && transform != null;
        this.isLatLon1D = latAxis instanceof CoverageCoordAxis1D && lonAxis instanceof CoverageCoordAxis1D;
        boolean bl = this.isLatLon2D = latAxis instanceof LatLonAxis2D && lonAxis instanceof LatLonAxis2D;
        assert (this.isProjection || this.isLatLon1D || this.isLatLon2D) : "missing horiz coordinates (x,y,projection or lat,lon)";
        if (this.isProjection && this.isLatLon2D) {
            String dependsOn;
            boolean ok = true;
            if (!latAxis.getDependsOn().equalsIgnoreCase(lonAxis.getDependsOn())) {
                ok = false;
            }
            if (latAxis.getDependenceType() != CoverageCoordAxis.DependenceType.twoD) {
                ok = false;
            }
            if (lonAxis.getDependenceType() != CoverageCoordAxis.DependenceType.twoD) {
                ok = false;
            }
            if (!(dependsOn = latAxis.getDependsOn()).contains(xAxis.getName())) {
                ok = false;
            }
            if (!dependsOn.contains(yAxis.getName())) {
                ok = false;
            }
            if (!ok) {
                this.isLatLon2D = false;
            }
        }
        if (!this.isProjection && this.isLatLon2D && !(this instanceof HorizCoordSys2D)) {
            logger.warn("Should be HorizCoordSys2D");
        }
        if (this.isLatLon1D) {
            this.latAxis = (CoverageCoordAxis1D)latAxis;
            this.lonAxis = (CoverageCoordAxis1D)lonAxis;
        } else {
            this.latAxis = null;
            this.lonAxis = null;
        }
        if (this.isLatLon2D) {
            this.latAxis2D = (LatLonAxis2D)latAxis;
            this.lonAxis2D = (LatLonAxis2D)lonAxis;
        } else {
            this.latAxis2D = null;
            this.lonAxis2D = null;
        }
    }

    public String getName() {
        if (this.isProjection) {
            return this.xAxis.getName() + " " + this.yAxis.getName() + " " + this.transform.getName();
        }
        return this.latAxis.getName() + " " + this.lonAxis.getName();
    }

    public boolean isProjection() {
        return this.isProjection;
    }

    public boolean isLatLon2D() {
        return false;
    }

    public List<CoverageCoordAxis> getCoordAxes() {
        ArrayList<CoverageCoordAxis> result = new ArrayList<CoverageCoordAxis>();
        if (this.xAxis != null) {
            result.add(this.xAxis);
        }
        if (this.yAxis != null) {
            result.add(this.yAxis);
        }
        if (this.latAxis != null) {
            result.add(this.latAxis);
        }
        if (this.lonAxis != null) {
            result.add(this.lonAxis);
        }
        return result;
    }

    public CoverageTransform getTransform() {
        return this.transform;
    }

    public Optional<HorizCoordSys> subset(SubsetParams params, Formatter errMessages) {
        LatLonRect llbb = (LatLonRect)params.get("latlonBB");
        ProjectionRect projbb = (ProjectionRect)params.get("projBB");
        LatLonPoint latlon = (LatLonPoint)params.get("latlonPoint");
        Integer horizStride = (Integer)params.get("horizStride");
        if (horizStride == null || horizStride < 1) {
            horizStride = 1;
        }
        CoverageCoordAxis1D xaxisSubset = null;
        CoverageCoordAxis1D yaxisSubset = null;
        CoverageCoordAxis lataxisSubset = null;
        CoverageCoordAxis lonaxisSubset = null;
        try {
            if (latlon != null) {
                CoordAxisHelper xhelper;
                if (this.isProjection) {
                    xhelper = new CoordAxisHelper(this.xAxis);
                    CoordAxisHelper yhelper = new CoordAxisHelper(this.yAxis);
                    Projection proj = this.transform.getProjection();
                    ProjectionPoint pp = proj.latLonToProj(latlon);
                    Optional<CoverageCoordAxisBuilder> optb = xhelper.subsetContaining(pp.getX(), errMessages);
                    if (optb.isPresent()) {
                        xaxisSubset = new CoverageCoordAxis1D(optb.get());
                    }
                    if ((optb = yhelper.subsetContaining(pp.getY(), errMessages)).isPresent()) {
                        yaxisSubset = new CoverageCoordAxis1D(optb.get());
                    }
                } else {
                    xhelper = new CoordAxisHelper(this.lonAxis);
                    CoordAxisHelper yhelper = new CoordAxisHelper(this.latAxis);
                    double lonNormal = LatLonPoints.lonNormalFrom(latlon.getLongitude(), this.lonAxis.getStartValue());
                    Optional<CoverageCoordAxisBuilder> optb = xhelper.subsetContaining(lonNormal, errMessages);
                    if (optb.isPresent()) {
                        lonaxisSubset = new CoverageCoordAxis1D(optb.get());
                    }
                    if ((optb = yhelper.subsetContaining(latlon.getLatitude(), errMessages)).isPresent()) {
                        lataxisSubset = new CoverageCoordAxis1D(optb.get());
                    }
                }
            } else if (projbb != null) {
                if (this.isProjection) {
                    Optional<CoverageCoordAxis> opt = this.xAxis.subset(projbb.getMinX(), projbb.getMaxX(), horizStride, errMessages);
                    if (opt.isPresent()) {
                        xaxisSubset = (CoverageCoordAxis1D)opt.get();
                    }
                    if ((opt = this.yAxis.subset(projbb.getMinY(), projbb.getMaxY(), horizStride, errMessages)).isPresent()) {
                        yaxisSubset = (CoverageCoordAxis1D)opt.get();
                    }
                }
            } else if (llbb != null) {
                LatLonRect full = this.calcLatLonBoundingBox();
                assert (full != null);
                if (!full.containedIn(llbb)) {
                    if (this.isProjection) {
                        Projection proj = this.transform.getProjection();
                        ProjectionRect prect = proj.latLonToProjBB(llbb);
                        Optional<CoverageCoordAxis> opt = this.xAxis.subset(prect.getMinX(), prect.getMaxX(), horizStride, errMessages);
                        if (opt.isPresent()) {
                            xaxisSubset = (CoverageCoordAxis1D)opt.get();
                        }
                        if ((opt = this.yAxis.subset(prect.getMinY(), prect.getMaxY(), horizStride, errMessages)).isPresent()) {
                            yaxisSubset = (CoverageCoordAxis1D)opt.get();
                        }
                    } else {
                        Optional<CoverageCoordAxis> opt = this.subsetLon(llbb, horizStride, errMessages);
                        if (opt.isPresent()) {
                            lonaxisSubset = opt.get();
                        }
                        if ((opt = this.latAxis.subset(llbb.getLatMin(), llbb.getLatMax(), horizStride, errMessages)).isPresent()) {
                            lataxisSubset = opt.get();
                        }
                    }
                }
            } else if (horizStride > 1) {
                if (this.isProjection) {
                    Optional<CoverageCoordAxis> opt = this.xAxis.subsetByIndex(this.xAxis.getRange().copyWithStride(horizStride), errMessages);
                    if (opt.isPresent()) {
                        xaxisSubset = (CoverageCoordAxis1D)opt.get();
                    }
                    if ((opt = this.yAxis.subsetByIndex(this.yAxis.getRange().copyWithStride(horizStride), errMessages)).isPresent()) {
                        yaxisSubset = (CoverageCoordAxis1D)opt.get();
                    }
                } else {
                    Optional<CoverageCoordAxis> opt = this.lonAxis.subsetByIndex(this.lonAxis.getRange().copyWithStride(horizStride), errMessages);
                    if (opt.isPresent()) {
                        lonaxisSubset = opt.get();
                    }
                    if ((opt = this.latAxis.subsetByIndex(this.latAxis.getRange().copyWithStride(horizStride), errMessages)).isPresent()) {
                        lataxisSubset = opt.get();
                    }
                }
            }
        }
        catch (InvalidRangeException e) {
            errMessages.format("%s;%n", e.getMessage());
        }
        String errs = errMessages.toString();
        if (!errs.isEmpty()) {
            return Optional.empty();
        }
        if (xaxisSubset == null && this.xAxis != null) {
            xaxisSubset = (CoverageCoordAxis1D)this.xAxis.copy();
        }
        if (yaxisSubset == null && this.yAxis != null) {
            yaxisSubset = (CoverageCoordAxis1D)this.yAxis.copy();
        }
        if (lataxisSubset == null && this.latAxis != null) {
            lataxisSubset = this.latAxis.copy();
        }
        if (lonaxisSubset == null && this.lonAxis != null) {
            lonaxisSubset = this.lonAxis.copy();
        }
        return Optional.of(new HorizCoordSys(xaxisSubset, yaxisSubset, lataxisSubset, lonaxisSubset, this.transform));
    }

    public LatLonPoint getLatLon(int yindex, int xindex) {
        if (this.isProjection) {
            double x = this.xAxis.getCoordMidpoint(xindex);
            double y = this.yAxis.getCoordMidpoint(xindex);
            Projection proj = this.transform.getProjection();
            return proj.projToLatLon(x, y);
        }
        double lat = this.latAxis.getCoordMidpoint(yindex);
        double lon = this.lonAxis.getCoordMidpoint(xindex);
        return LatLonPoint.create(lat, lon);
    }

    private Optional<CoverageCoordAxis> subsetLon(LatLonRect llbb, int stride, Formatter errLog) {
        double end;
        double start;
        double wantMax;
        double wantMin = LatLonPoints.lonNormalFrom(llbb.getLonMin(), this.lonAxis.getStartValue());
        List<MAMath.MinMax> lonIntvs = this.subsetLonIntervals(wantMin, wantMax = LatLonPoints.lonNormalFrom(llbb.getLonMax(), this.lonAxis.getStartValue()), start = this.lonAxis.getStartValue(), end = this.lonAxis.getEndValue());
        if (lonIntvs.isEmpty()) {
            errLog.format("longitude want [%f,%f] does not intersect lon axis [%f,%f]", wantMin, wantMax, start, end);
            return Optional.empty();
        }
        if (lonIntvs.size() == 1) {
            MAMath.MinMax lonIntv = lonIntvs.get(0);
            return this.lonAxis.subset(lonIntv.min, lonIntv.max, stride, errLog);
        }
        return this.lonAxis.subsetByIntervals(lonIntvs, stride, errLog);
    }

    private List<MAMath.MinMax> subsetLonIntervals(double wantMin, double wantMax, double start, double end) {
        if (wantMin <= wantMax) {
            if (wantMin > end && wantMax > end) {
                return ImmutableList.of();
            }
            if (wantMin < end && wantMax < end) {
                return Lists.newArrayList((Object[])new MAMath.MinMax[]{new MAMath.MinMax(wantMin, wantMax)});
            }
            if (wantMin < end && wantMax > end) {
                return Lists.newArrayList((Object[])new MAMath.MinMax[]{new MAMath.MinMax(wantMin, end)});
            }
        } else {
            if (wantMin > end && wantMax > end) {
                return Lists.newArrayList((Object[])new MAMath.MinMax[]{new MAMath.MinMax(start, end)});
            }
            if (wantMin < end && wantMax < end) {
                return Lists.newArrayList((Object[])new MAMath.MinMax[]{new MAMath.MinMax(wantMin, end), new MAMath.MinMax(start, wantMax)});
            }
            if (wantMin < end && wantMax > end) {
                return Lists.newArrayList((Object[])new MAMath.MinMax[]{new MAMath.MinMax(wantMin, end)});
            }
        }
        logger.error("longitude want [{},{}] does not intersect axis [{},{}]", new Object[]{wantMin, wantMax, start, end});
        return ImmutableList.of();
    }

    public List<RangeIterator> getRanges() {
        ArrayList<RangeIterator> result = new ArrayList<RangeIterator>();
        result.add(this.getYAxis().getRange());
        RangeIterator lonRange = this.getXAxis().getRangeIterator();
        if (lonRange == null) {
            lonRange = this.getXAxis().getRange();
        }
        result.add(lonRange);
        return result;
    }

    public CoverageCoordAxis1D getXAxis() {
        return this.xAxis != null ? this.xAxis : this.lonAxis;
    }

    public CoverageCoordAxis1D getYAxis() {
        return this.yAxis != null ? this.yAxis : this.latAxis;
    }

    public LatLonAxis2D getLonAxis2D() {
        return this.lonAxis2D;
    }

    public LatLonAxis2D getLatAxis2D() {
        return this.latAxis2D;
    }

    public Optional<CoordReturn> findXYindexFromCoord(double x, double y) {
        CoordReturn result = new CoordReturn();
        if (this.isProjection) {
            CoordAxisHelper xhelper = new CoordAxisHelper(this.xAxis);
            CoordAxisHelper yhelper = new CoordAxisHelper(this.yAxis);
            result.x = xhelper.findCoordElement(x, false);
            result.y = yhelper.findCoordElement(y, false);
            if (result.x >= 0 && result.x < this.xAxis.getNcoords() && result.y >= 0 && result.y < this.yAxis.getNcoords()) {
                result.xcoord = this.xAxis.getCoordMidpoint(result.x);
                result.ycoord = this.yAxis.getCoordMidpoint(result.y);
                return Optional.of(result);
            }
            return Optional.empty();
        }
        CoordAxisHelper xhelper = new CoordAxisHelper(this.lonAxis);
        CoordAxisHelper yhelper = new CoordAxisHelper(this.latAxis);
        double lon = LatLonPoints.lonNormalFrom(x, this.lonAxis.getStartValue());
        result.x = xhelper.findCoordElement(lon, false);
        result.y = yhelper.findCoordElement(y, false);
        if (result.x >= 0 && result.x < this.lonAxis.getNcoords() && result.y >= 0 && result.y < this.latAxis.getNcoords()) {
            result.xcoord = this.lonAxis.getCoordMidpoint(result.x);
            result.ycoord = this.latAxis.getCoordMidpoint(result.y);
            return Optional.of(result);
        }
        return Optional.empty();
    }

    public ProjectionRect calcProjectionBoundingBox() {
        if (!this.isProjection) {
            return null;
        }
        double minX = Math.min(this.xAxis.getCoordEdgeFirst(), this.xAxis.getCoordEdgeLast());
        double minY = Math.min(this.yAxis.getCoordEdgeFirst(), this.yAxis.getCoordEdgeLast());
        double width = Math.abs(this.xAxis.getCoordEdgeLast() - this.xAxis.getCoordEdgeFirst());
        double height = Math.abs(this.yAxis.getCoordEdgeLast() - this.yAxis.getCoordEdgeFirst());
        return new ProjectionRect(ProjectionPoint.create(minX, minY), width, height);
    }

    public LatLonRect calcLatLonBoundingBox() {
        double minLat = Double.MAX_VALUE;
        double minLon = Double.MAX_VALUE;
        double maxLat = -1.7976931348623157E308;
        double maxLon = -1.7976931348623157E308;
        for (ProjectionPoint boundaryPoint : this.calcConnectedLatLonBoundaryPoints()) {
            minLat = Math.min(minLat, boundaryPoint.getY());
            minLon = Math.min(minLon, boundaryPoint.getX());
            maxLat = Math.max(maxLat, boundaryPoint.getY());
            maxLon = Math.max(maxLon, boundaryPoint.getX());
        }
        return new LatLonRect(minLat, minLon, maxLat, maxLon);
    }

    public List<ProjectionPoint> calcConnectedLatLonBoundaryPoints() {
        return this.calcConnectedLatLonBoundaryPoints(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public List<ProjectionPoint> calcConnectedLatLonBoundaryPoints(int maxPointsInYEdge, int maxPointsInXEdge) {
        List<LatLonPoint> points;
        if (this.isProjection) {
            points = this.calcLatLonBoundaryPointsFromProjection(maxPointsInYEdge, maxPointsInXEdge);
        } else if (this.isLatLon1D) {
            points = this.calcLatLon1DBoundaryPoints(maxPointsInYEdge, maxPointsInXEdge);
        } else if (this.isLatLon2D) {
            points = this.calcLatLon2DBoundaryPoints(maxPointsInYEdge, maxPointsInXEdge);
        } else {
            throw new AssertionError((Object)"HorizCoordSys was not a projection, latLon1D, or latLon2D.");
        }
        return HorizCoordSys.connectLatLonPoints(points);
    }

    public List<ProjectionPoint> calcProjectionBoundaryPoints() {
        return this.calcProjectionBoundaryPoints(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public List<ProjectionPoint> calcProjectionBoundaryPoints(int maxPointsInYEdge, int maxPointsInXEdge) {
        int j;
        int i;
        if (!this.isProjection) {
            throw new UnsupportedOperationException("Coordinate system is not a projection.");
        }
        HorizCoordSys.checkMaxPointsInEdges(maxPointsInYEdge, maxPointsInXEdge);
        int numYtotal = this.yAxis.getNcoords();
        int numXtotal = this.xAxis.getNcoords();
        int strideY = HorizCoordSys.calcStride(numYtotal, maxPointsInYEdge);
        int strideX = HorizCoordSys.calcStride(numXtotal, maxPointsInXEdge);
        LinkedList<ProjectionPoint> points = new LinkedList<ProjectionPoint>();
        for (i = 0; i < numXtotal; i += strideX) {
            points.add(ProjectionPoint.create(this.xAxis.getCoordEdge1(i), this.yAxis.getCoordEdgeFirst()));
        }
        for (j = 0; j < numYtotal; j += strideY) {
            points.add(ProjectionPoint.create(this.xAxis.getCoordEdgeLast(), this.yAxis.getCoordEdge1(j)));
        }
        for (i = numXtotal - 1; i >= 0; i -= strideX) {
            points.add(ProjectionPoint.create(this.xAxis.getCoordEdge2(i), this.yAxis.getCoordEdgeLast()));
        }
        for (j = numYtotal - 1; j >= 0; j -= strideY) {
            points.add(ProjectionPoint.create(this.xAxis.getCoordEdgeFirst(), this.yAxis.getCoordEdge2(j)));
        }
        HorizCoordSys.assertNotExceedingMaxBoundaryPoints(points.size(), maxPointsInYEdge, maxPointsInXEdge);
        return points;
    }

    private List<LatLonPoint> calcLatLon1DBoundaryPoints(int maxPointsInYEdge, int maxPointsInXEdge) {
        int j;
        int i;
        if (!this.isLatLon1D) {
            throw new UnsupportedOperationException("Coordinate system is not 1D latitude/longitude.");
        }
        HorizCoordSys.checkMaxPointsInEdges(maxPointsInYEdge, maxPointsInXEdge);
        int numYtotal = this.latAxis.getNcoords();
        int numXtotal = this.lonAxis.getNcoords();
        int strideY = HorizCoordSys.calcStride(numYtotal, maxPointsInYEdge);
        int strideX = HorizCoordSys.calcStride(numXtotal, maxPointsInXEdge);
        LinkedList<LatLonPoint> points = new LinkedList<LatLonPoint>();
        for (i = 0; i < numXtotal; i += strideX) {
            points.add(LatLonPoint.create(this.latAxis.getCoordEdgeFirst(), this.lonAxis.getCoordEdge1(i)));
        }
        for (j = 0; j < numYtotal; j += strideY) {
            points.add(LatLonPoint.create(this.latAxis.getCoordEdge1(j), this.lonAxis.getCoordEdgeLast()));
        }
        for (i = numXtotal - 1; i >= 0; i -= strideX) {
            points.add(LatLonPoint.create(this.latAxis.getCoordEdgeLast(), this.lonAxis.getCoordEdge2(i)));
        }
        for (j = numYtotal - 1; j >= 0; j -= strideY) {
            points.add(LatLonPoint.create(this.latAxis.getCoordEdge2(j), this.lonAxis.getCoordEdgeFirst()));
        }
        HorizCoordSys.assertNotExceedingMaxBoundaryPoints(points.size(), maxPointsInYEdge, maxPointsInXEdge);
        return points;
    }

    private List<LatLonPoint> calcLatLonBoundaryPointsFromProjection(int maxPointsInYEdge, int maxPointsInXEdge) {
        List<ProjectionPoint> projPoints = this.calcProjectionBoundaryPoints(maxPointsInYEdge, maxPointsInXEdge);
        LinkedList<LatLonPoint> latLonPoints = new LinkedList<LatLonPoint>();
        for (ProjectionPoint projPoint : projPoints) {
            latLonPoints.add(this.transform.getProjection().projToLatLon(projPoint));
        }
        return latLonPoints;
    }

    private List<LatLonPoint> calcLatLon2DBoundaryPoints(int maxPointsInYEdge, int maxPointsInXEdge) {
        int j;
        int i;
        if (!this.isLatLon2D) {
            throw new UnsupportedOperationException("Coordinate system is not 2D latitude/longitude.");
        }
        HorizCoordSys.checkMaxPointsInEdges(maxPointsInYEdge, maxPointsInXEdge);
        assert (Arrays.equals(this.latAxis2D.getShape(), this.lonAxis2D.getShape())) : "2D lat/lon axes ought to have the same shape";
        int[] midpointsShape = (int[])this.latAxis2D.getShape().clone();
        int numYtotal = midpointsShape[0];
        int numXtotal = midpointsShape[1];
        int strideY = HorizCoordSys.calcStride(numYtotal, maxPointsInYEdge);
        int strideX = HorizCoordSys.calcStride(numXtotal, maxPointsInXEdge);
        ArrayDouble.D2 latEdges = (ArrayDouble.D2)this.latAxis2D.getCoordBoundsAsArray();
        ArrayDouble.D2 lonEdges = (ArrayDouble.D2)this.lonAxis2D.getCoordBoundsAsArray();
        assert (Arrays.equals(latEdges.getShape(), lonEdges.getShape())) : "2D lat/lon edges ought to have the same shape";
        int[] edgesShape = latEdges.getShape();
        midpointsShape[0] = midpointsShape[0] + 1;
        midpointsShape[1] = midpointsShape[1] + 1;
        assert (Arrays.equals(midpointsShape, edgesShape)) : "edgesShape should be 1 greater than midpointsShape in each dim";
        LinkedList<LatLonPoint> points = new LinkedList<LatLonPoint>();
        for (i = 0; i < numXtotal; i += strideX) {
            points.add(LatLonPoint.create(latEdges.get(0, i), lonEdges.get(0, i)));
        }
        for (j = 0; j < numYtotal; j += strideY) {
            points.add(LatLonPoint.create(latEdges.get(j, numXtotal), lonEdges.get(j, numXtotal)));
        }
        for (i = numXtotal; i > 0; i -= strideX) {
            points.add(LatLonPoint.create(latEdges.get(numYtotal, i), lonEdges.get(numYtotal, i)));
        }
        for (j = numYtotal; j > 0; j -= strideY) {
            points.add(LatLonPoint.create(latEdges.get(j, 0), lonEdges.get(j, 0)));
        }
        HorizCoordSys.assertNotExceedingMaxBoundaryPoints(points.size(), maxPointsInYEdge, maxPointsInXEdge);
        return points;
    }

    private static void checkMaxPointsInEdges(int maxPointsInYEdge, int maxPointsInXEdge) throws IllegalArgumentException {
        if (maxPointsInYEdge < 1) {
            throw new IllegalArgumentException(String.format("maxPointsInYEdge (%d) must be > 0", maxPointsInYEdge));
        }
        if (maxPointsInXEdge < 1) {
            throw new IllegalArgumentException(String.format("maxPointsInXEdge (%d) must be > 0", maxPointsInXEdge));
        }
    }

    private static int calcStride(int numTotal, int maxToInclude) {
        int stride = Math.max(1, (int)Math.ceil((double)numTotal / (double)maxToInclude));
        int numIncluded = (int)Math.ceil((double)numTotal / (double)stride);
        assert (numIncluded <= maxToInclude) : String.format("We're set to include %d points, but we wanted a max of %d.", numIncluded, maxToInclude);
        return stride;
    }

    private static void assertNotExceedingMaxBoundaryPoints(int numBoundaryPoints, int maxPointsInYEdge, int maxPointsInXEdge) {
        long maxBoundaryPoints = 2L * (long)maxPointsInYEdge + 2L * (long)maxPointsInXEdge;
        assert ((long)numBoundaryPoints <= maxBoundaryPoints) : String.format("We should be returning a maximum of %d boundary points, but we're returning %d instead.", maxBoundaryPoints, numBoundaryPoints);
    }

    public static List<ProjectionPoint> connectLatLonPoints(List<LatLonPoint> points) {
        LinkedList<ProjectionPoint> connectedPoints = new LinkedList<ProjectionPoint>();
        for (LatLonPoint point : points) {
            double curLat = point.getLatitude();
            double curLon = point.getLongitude();
            if (!connectedPoints.isEmpty()) {
                double prevLon = connectedPoints.getLast().getX();
                curLon = LatLonPoints.lonNormal(curLon, prevLon);
            }
            connectedPoints.add(ProjectionPoint.create(curLon, curLat));
        }
        return connectedPoints;
    }

    public String getLatLonBoundaryAsWKT() {
        return this.getLatLonBoundaryAsWKT(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public String getLatLonBoundaryAsWKT(int maxPointsInYEdge, int maxPointsInXEdge) {
        List<ProjectionPoint> points = this.calcConnectedLatLonBoundaryPoints(maxPointsInYEdge, maxPointsInXEdge);
        StringBuilder sb = new StringBuilder("POLYGON((");
        for (ProjectionPoint point : points) {
            sb.append(String.format("%.3f %.3f, ", point.getX(), point.getY()));
        }
        sb.delete(sb.length() - 2, sb.length());
        sb.append("))");
        return sb.toString();
    }

    public String getLatLonBoundaryAsGeoJSON() {
        return this.getLatLonBoundaryAsGeoJSON(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public String getLatLonBoundaryAsGeoJSON(int maxPointsInYEdge, int maxPointsInXEdge) {
        List<ProjectionPoint> points = this.calcConnectedLatLonBoundaryPoints(maxPointsInYEdge, maxPointsInXEdge);
        StringBuilder sb = new StringBuilder("{ 'type': 'Polygon', 'coordinates': [ [ ");
        for (ProjectionPoint point : points) {
            sb.append(String.format("[%.3f, %.3f], ", point.getX(), point.getY()));
        }
        sb.delete(sb.length() - 2, sb.length());
        sb.append(" ] ] }");
        return sb.toString();
    }

    public static class CoordReturn {
        public int x;
        public int y;
        public double xcoord;
        public double ycoord;
    }
}

