/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage;

import javax.annotation.concurrent.Immutable;
import ucar.nc2.AttributeContainer;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.time.CalendarPeriod;

@Immutable
public class TimeHelper {
    final CalendarDateUnit dateUnit;

    public static TimeHelper factory(String units, AttributeContainer atts) {
        if (units == null) {
            units = atts.findAttributeString("udunits", null);
        }
        if (units == null) {
            units = atts.findAttributeString("units", null);
        }
        if (units == null) {
            throw new IllegalStateException("No units");
        }
        Calendar cal = TimeHelper.getCalendarFromAttribute(atts);
        try {
            CalendarDateUnit dateUnit = CalendarDateUnit.withCalendar(cal, units);
            return new TimeHelper(dateUnit);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private TimeHelper(CalendarDateUnit dateUnit) {
        this.dateUnit = dateUnit;
    }

    public TimeHelper setReferenceDate(CalendarDate refDate) {
        CalendarDateUnit cdUnit = CalendarDateUnit.of(this.dateUnit.getCalendar(), this.dateUnit.getCalendarField(), refDate);
        return new TimeHelper(cdUnit);
    }

    public String getUdUnit() {
        return this.dateUnit.getUdUnit();
    }

    public double offsetFromRefDate(CalendarDate date) {
        return this.dateUnit.makeOffsetFromRefDate(date);
    }

    public CalendarDate getRefDate() {
        return this.dateUnit.getBaseCalendarDate();
    }

    public CalendarDate makeDate(double value) {
        return this.dateUnit.makeCalendarDate(value);
    }

    public CalendarDateRange getDateRange(double startValue, double endValue) {
        CalendarDate start = this.makeDate(startValue);
        CalendarDate end = this.makeDate(endValue);
        return CalendarDateRange.of(start, end);
    }

    public double getOffsetInTimeUnits(CalendarDate start, CalendarDate end) {
        return this.dateUnit.getCalendarPeriod().getOffset(start, end);
    }

    public CalendarDate makeDateInTimeUnits(CalendarDate start, double addTo) {
        return start.add(CalendarPeriod.of((int)addTo, this.dateUnit.getCalendarField()));
    }

    public static Calendar getCalendarFromAttribute(AttributeContainer atts) {
        String cal = atts.findAttributeString("calendar", null);
        if (cal == null) {
            return null;
        }
        return Calendar.get(cal);
    }

    public Calendar getCalendar() {
        return this.dateUnit.getCalendar();
    }

    public CalendarDateUnit getCalendarDateUnit() {
        return this.dateUnit;
    }
}

