/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage.adapter;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.ft2.coverage.adapter.DtCoverage;
import ucar.nc2.ft2.coverage.adapter.DtCoverageCS;
import ucar.nc2.ft2.coverage.adapter.DtCoverageCSBuilder;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionRect;

public class DtCoverageDataset
implements Closeable {
    private NetcdfDataset ncd;
    private FeatureType coverageType;
    private final ArrayList<DtCoverage> grids = new ArrayList();
    private final Map<String, Gridset> gridsetHash = new HashMap<String, Gridset>();
    private final List<Gridset> gridSets = new ArrayList<Gridset>();
    private LatLonRect llbbMax;
    private CalendarDateRange dateRangeMax;
    private ProjectionRect projBB;

    public static DtCoverageDataset open(String location) throws IOException {
        DatasetUrl durl = DatasetUrl.findDatasetUrl(location);
        return DtCoverageDataset.open(durl, NetcdfDataset.getDefaultEnhanceMode());
    }

    public static DtCoverageDataset open(DatasetUrl durl) throws IOException {
        return DtCoverageDataset.open(durl, NetcdfDataset.getDefaultEnhanceMode());
    }

    public static DtCoverageDataset open(DatasetUrl durl, Set<NetcdfDataset.Enhance> enhanceMode) throws IOException {
        NetcdfDataset ds = NetcdfDatasets.acquireDataset(null, durl, enhanceMode, -1, null, null);
        return new DtCoverageDataset(ds, null);
    }

    public static DtCoverageDataset open(NetcdfDataset ds) throws IOException {
        return new DtCoverageDataset(ds, null);
    }

    public DtCoverageDataset(NetcdfDataset ncd) throws IOException {
        this(ncd, null);
    }

    public DtCoverageDataset(NetcdfDataset ncd, Formatter parseInfo) throws IOException {
        this.ncd = ncd;
        Set<NetcdfDataset.Enhance> enhance = ncd.getEnhanceMode();
        if (enhance == null || enhance.isEmpty()) {
            enhance = NetcdfDataset.getDefaultEnhanceMode();
        }
        NetcdfDatasets.enhance(ncd, enhance, null);
        DtCoverageCSBuilder facc = DtCoverageCSBuilder.classify(ncd, parseInfo);
        if (facc != null) {
            this.coverageType = facc.type;
        }
        HashMap<String, Gridset> csHash = new HashMap<String, Gridset>();
        for (CoordinateSystem cs : ncd.getCoordinateSystems()) {
            DtCoverageCS ccs;
            DtCoverageCSBuilder fac = new DtCoverageCSBuilder(ncd, cs, parseInfo);
            if (fac.type == null || (ccs = fac.makeCoordSys()) == null) continue;
            Gridset cset = new Gridset(ccs);
            this.gridSets.add(cset);
            this.gridsetHash.put(ccs.getName(), cset);
            csHash.put(cs.getName(), cset);
        }
        for (Variable v : ncd.getVariables()) {
            VariableEnhanced ve = (VariableEnhanced)((Object)v);
            ArrayList<CoordinateSystem> css = new ArrayList<CoordinateSystem>((Collection<CoordinateSystem>)ve.getCoordinateSystems());
            if (css.isEmpty()) continue;
            css.sort((o1, o2) -> o2.getCoordinateAxes().size() - o1.getCoordinateAxes().size());
            CoordinateSystem cs = (CoordinateSystem)css.get(0);
            Gridset cset = (Gridset)csHash.get(cs.getName());
            if (cset == null) continue;
            DtCoverage ci = new DtCoverage(this, cset.gcc, (VariableDS)ve);
            cset.grids.add(ci);
            this.grids.add(ci);
        }
    }

    private void makeHorizRanges() {
        LatLonRect.Builder llbbBuilder = null;
        ProjectionRect.Builder projBBbuilder = null;
        for (Gridset gset : this.getGridsets()) {
            DtCoverageCS gcs = gset.getGeoCoordSystem();
            ProjectionRect bb = gcs.getBoundingBox();
            if (projBBbuilder == null) {
                projBBbuilder = bb.toBuilder();
            } else if (bb != null) {
                projBBbuilder.add(bb);
            }
            LatLonRect llbb = gcs.getLatLonBoundingBox();
            if (llbbBuilder == null) {
                llbbBuilder = llbb.toBuilder();
                continue;
            }
            if (llbb == null) continue;
            llbbBuilder.extend(llbb);
        }
        if (llbbBuilder != null) {
            this.llbbMax = llbbBuilder.build();
        }
    }

    private void makeTimeRanges() {
        for (Gridset gset : this.getGridsets()) {
            DtCoverageCS gcs = gset.getGeoCoordSystem();
            CalendarDateRange dateRange = gcs.getCalendarDateRange();
            if (dateRange == null) continue;
            if (this.dateRangeMax == null) {
                this.dateRangeMax = dateRange;
                continue;
            }
            this.dateRangeMax = this.dateRangeMax.extend(dateRange);
        }
    }

    public FeatureType getCoverageType() {
        return this.coverageType;
    }

    public String getTitle() {
        String title = this.ncd.getTitle();
        if (title == null) {
            title = this.ncd.getRootGroup().findAttributeString("title", null);
        }
        if (title == null) {
            title = this.getName();
        }
        return title;
    }

    public String getDescription() {
        String desc = this.ncd.getRootGroup().findAttributeString("description", null);
        if (desc == null) {
            desc = this.ncd.getRootGroup().findAttributeString("history", null);
        }
        return desc == null ? this.getName() : desc;
    }

    public String getLocation() {
        return this.ncd.getLocation();
    }

    public CalendarDateRange getCalendarDateRange() {
        if (this.dateRangeMax == null) {
            this.makeTimeRanges();
        }
        return this.dateRangeMax;
    }

    public CalendarDate getCalendarDateStart() {
        if (this.dateRangeMax == null) {
            this.makeTimeRanges();
        }
        return this.dateRangeMax == null ? null : this.dateRangeMax.getStart();
    }

    public CalendarDate getCalendarDateEnd() {
        if (this.dateRangeMax == null) {
            this.makeTimeRanges();
        }
        return this.dateRangeMax == null ? null : this.dateRangeMax.getEnd();
    }

    public LatLonRect getBoundingBox() {
        if (this.llbbMax == null) {
            this.makeHorizRanges();
        }
        return this.llbbMax;
    }

    public ProjectionRect getProjBoundingBox() {
        if (this.llbbMax == null) {
            this.makeHorizRanges();
        }
        return this.projBB;
    }

    public void calcBounds() {
    }

    public List<Attribute> getGlobalAttributes() {
        return this.ncd.getGlobalAttributes();
    }

    public Dimension findDimension(String name) {
        return this.ncd.findDimension(name);
    }

    public Attribute findGlobalAttributeIgnoreCase(String name) {
        return this.ncd.findGlobalAttributeIgnoreCase(name);
    }

    public List<VariableSimpleIF> getDataVariables() {
        ArrayList<VariableSimpleIF> result = new ArrayList<VariableSimpleIF>(this.grids.size());
        for (DtCoverage grid : this.getGrids()) {
            if (grid.getVariable() == null) continue;
            result.add(grid.getVariable());
        }
        return result;
    }

    public VariableSimpleIF getDataVariable(String shortName) {
        return this.ncd.getRootGroup().findVariableLocal(shortName);
    }

    public NetcdfFile getNetcdfFile() {
        return this.ncd;
    }

    public String getName() {
        String name = this.ncd.getLocation();
        if (name != null) {
            int pos = name.lastIndexOf(47);
            if (pos < 0) {
                pos = name.lastIndexOf(92);
            }
            name = pos < 0 ? name : name.substring(pos + 1);
        } else {
            name = this.ncd.getId();
        }
        return name;
    }

    public NetcdfDataset getNetcdfDataset() {
        return this.ncd;
    }

    public List<DtCoverage> getGrids() {
        return new ArrayList<DtCoverage>(this.grids);
    }

    public DtCoverage findGridDatatype(String name) {
        return this.findGridByName(name);
    }

    public List<Gridset> getGridsets() {
        return new ArrayList<Gridset>(this.gridsetHash.values());
    }

    public DtCoverage findGridByName(String fullName) {
        for (DtCoverage ggi : this.grids) {
            if (!fullName.equals(ggi.getFullName())) continue;
            return ggi;
        }
        return null;
    }

    public DtCoverage findGridByShortName(String shortName) {
        for (DtCoverage ggi : this.grids) {
            if (!shortName.equals(ggi.getShortName())) continue;
            return ggi;
        }
        return null;
    }

    public DtCoverage findGridByFullName(String fullName) {
        for (DtCoverage ggi : this.grids) {
            if (!fullName.equals(ggi.getFullName())) continue;
            return ggi;
        }
        return null;
    }

    public DtCoverage findGridDatatypeByAttribute(String attName, String attValue) {
        for (DtCoverage ggi : this.grids) {
            for (Attribute att : ggi.attributes()) {
                if (!attName.equals(att.getShortName()) || !attValue.equals(att.getStringValue())) continue;
                return ggi;
            }
        }
        return null;
    }

    public String getDetailInfo() {
        Formatter buff = new Formatter();
        this.getDetailInfo(buff);
        return buff.toString();
    }

    public void getDetailInfo(Formatter buff) {
        this.getInfo(buff);
        buff.format("%n%n----------------------------------------------------%n", new Object[0]);
        buff.format("%s", this.ncd.toString());
        buff.format("%n%n----------------------------------------------------%n", new Object[0]);
    }

    private void getInfo(Formatter buf) {
        int countGridset = 0;
        for (Gridset gs : this.gridsetHash.values()) {
            DtCoverageCS gcs = gs.getGeoCoordSystem();
            buf.format("%nGridset %d  coordSys=%s", countGridset, gcs);
            buf.format(" LLbb=%s ", gcs.getLatLonBoundingBox());
            if (gcs.getProjection() != null && !gcs.getProjection().isLatLon()) {
                buf.format(" bb= %s", gcs.getBoundingBox());
            }
            buf.format("%n", new Object[0]);
            buf.format("Name__________________________Unit__________________________hasMissing_Description%n", new Object[0]);
            for (DtCoverage grid : gs.getGrids()) {
                buf.format("%s%n", grid.getInfo());
            }
            ++countGridset;
            buf.format("%n", new Object[0]);
        }
        buf.format("%nGeoReferencing Coordinate Axes%n", new Object[0]);
        buf.format("Name__________________________Units_______________Type______Description%n", new Object[0]);
        for (CoordinateAxis axis : this.ncd.getCoordinateAxes()) {
            if (axis.getAxisType() == null) continue;
            axis.getInfo(buf);
            buf.format("%n", new Object[0]);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            if (this.ncd != null) {
                this.ncd.close();
            }
        }
        finally {
            this.ncd = null;
        }
    }

    public static class Gridset {
        private final DtCoverageCS gcc;
        private final List<DtCoverage> grids = new ArrayList<DtCoverage>();

        private Gridset(DtCoverageCS gcc) {
            this.gcc = gcc;
        }

        private void add(DtCoverage grid) {
            this.grids.add(grid);
        }

        public List<DtCoverage> getGrids() {
            return this.grids;
        }

        public DtCoverageCS getGeoCoordSystem() {
            return this.gcc;
        }

        public DtCoverageCS getGeoCoordSys() {
            return this.gcc;
        }
    }
}

