/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.constants.AxisType;
import ucar.nc2.ft2.coverage.CoordSysSet;
import ucar.nc2.ft2.coverage.Coverage;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordSys;
import ucar.nc2.ft2.coverage.CoverageTransform;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.write.NcmlWriter;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionRect;

public class CoverageDatasetCapabilities {
    private final CoverageCollection gcd;
    private final String path;
    private final NcmlWriter ncmlWriter = new NcmlWriter();

    public CoverageDatasetCapabilities(CoverageCollection gds, String path) {
        this.gcd = gds;
        this.path = path;
    }

    public String writeXML(Document doc) {
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        return fmt.outputString(doc);
    }

    public void writeXML(Document doc, OutputStream os) throws IOException {
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        fmt.output(doc, os);
    }

    public Document makeDatasetDescription() {
        CalendarDateRange calDateRange;
        Element rootElem = new Element("gridDataset");
        Document doc = new Document(rootElem);
        rootElem.setAttribute("location", this.gcd.getName());
        if (null != this.path) {
            rootElem.setAttribute("path", this.path);
        }
        for (CoverageCoordAxis axis : this.gcd.getCoordAxes()) {
            rootElem.addContent((Content)this.writeAxis(axis));
        }
        for (CoordSysSet gridset : this.gcd.getCoverageSets()) {
            rootElem.addContent((Content)this.writeCoverageSet(gridset.getCoordSys(), gridset.getCoverages(), this.gcd.getProjBoundingBox()));
        }
        for (CoverageTransform ct : this.gcd.getCoordTransforms()) {
            rootElem.addContent((Content)this.writeCoordTransform(ct));
        }
        LatLonRect bb = this.gcd.getLatlonBoundingBox();
        if (bb != null) {
            rootElem.addContent((Content)this.writeBoundingBox(bb));
        }
        if ((calDateRange = this.gcd.getCalendarDateRange()) != null) {
            Element dateRange = new Element("TimeSpan");
            dateRange.addContent((Content)new Element("begin").addContent(calDateRange.getStart().toString()));
            dateRange.addContent((Content)new Element("end").addContent(calDateRange.getEnd().toString()));
            rootElem.addContent((Content)dateRange);
        }
        return doc;
    }

    private Element writeAxis(CoverageCoordAxis axis) {
        Element varElem = new Element("axis");
        varElem.setAttribute("name", axis.getName());
        varElem.setAttribute("shape", Arrays.toString(axis.getShape()));
        DataType dt = axis.getDataType();
        varElem.setAttribute("type", dt.toString());
        AxisType axisType = axis.getAxisType();
        if (null != axisType) {
            varElem.setAttribute("axisType", axisType.toString());
        }
        if (axis.getDependsOn() != null && !axis.getDependsOn().trim().isEmpty()) {
            varElem.setAttribute("dependsOn", axis.getDependsOn().trim());
        }
        for (Attribute att : axis.attributes()) {
            varElem.addContent((Content)this.ncmlWriter.makeAttributeElement(att));
        }
        Element values = new Element("values");
        if (!axis.isRegular()) {
            Array array = axis.getCoordsAsArray();
            boolean isRealType = array.getDataType() == DataType.DOUBLE || array.getDataType() == DataType.FLOAT;
            IndexIterator iter = array.getIndexIterator();
            StringBuilder buff = new StringBuilder();
            buff.append(isRealType ? iter.getDoubleNext() : (double)iter.getIntNext());
            while (iter.hasNext()) {
                buff.append(" ");
                buff.append(isRealType ? iter.getDoubleNext() : (double)iter.getIntNext());
            }
            values.setText(buff.toString());
        }
        values.setAttribute("spacing", axis.getSpacing().toString());
        values.setAttribute("npts", Long.toString(axis.getNcoords()));
        values.setAttribute("start", Double.toString(axis.getStartValue()));
        values.setAttribute("end", Double.toString(axis.getEndValue()));
        if (axis.getResolution() != 0.0) {
            values.setAttribute("resolution", Double.toString(axis.getResolution()));
        }
        varElem.addContent((Content)values);
        return varElem;
    }

    private String getShapeString(int[] shape) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < shape.length; ++i) {
            if (i != 0) {
                buf.append(" ");
            }
            buf.append(shape[i]);
        }
        return buf.toString();
    }

    private Element writeBoundingBox(LatLonRect bb) {
        Element bbElem = new Element("LatLonBox");
        bbElem.addContent((Content)new Element("west").addContent(ucar.unidata.util.Format.dfrac(bb.getLonMin(), 4)));
        bbElem.addContent((Content)new Element("east").addContent(ucar.unidata.util.Format.dfrac(bb.getLonMax(), 4)));
        bbElem.addContent((Content)new Element("south").addContent(ucar.unidata.util.Format.dfrac(bb.getLatMin(), 4)));
        bbElem.addContent((Content)new Element("north").addContent(ucar.unidata.util.Format.dfrac(bb.getLatMax(), 4)));
        return bbElem;
    }

    private Element writeCoverageSet(CoverageCoordSys cs, List<Coverage> grids, ProjectionRect rect) {
        Element csElem = new Element("gridSet");
        csElem.setAttribute("name", cs.getName());
        if (rect != null) {
            Element projBBOX = new Element("projectionBox");
            Element minx = new Element("minx");
            minx.addContent(Double.valueOf(rect.getMinX()).toString());
            projBBOX.addContent((Content)minx);
            Element maxx = new Element("maxx");
            maxx.addContent(Double.valueOf(rect.getMaxX()).toString());
            projBBOX.addContent((Content)maxx);
            Element miny = new Element("miny");
            miny.addContent(Double.valueOf(rect.getMinY()).toString());
            projBBOX.addContent((Content)miny);
            Element maxy = new Element("maxy");
            maxy.addContent(Double.valueOf(rect.getMaxY()).toString());
            projBBOX.addContent((Content)maxy);
            csElem.addContent((Content)projBBOX);
        }
        for (String axisName : cs.getAxisNames()) {
            Element axisElem = new Element("axisRef");
            axisElem.setAttribute("name", axisName);
            csElem.addContent((Content)axisElem);
        }
        for (String ctName : cs.getTransformNames()) {
            Element elem = new Element("coordTransRef");
            elem.setAttribute("name", ctName);
            csElem.addContent((Content)elem);
        }
        grids.sort(new GridCoverageComparator());
        for (Coverage grid : grids) {
            csElem.addContent((Content)this.writeGrid(grid));
        }
        return csElem;
    }

    private Element writeCoordTransform(CoverageTransform ct) {
        Element ctElem = new Element("coordTransform");
        ctElem.setAttribute("name", ct.getName());
        ctElem.setAttribute("transformType", ct.isHoriz() ? "Projection" : "Vertical");
        for (Attribute param : ct.attributes()) {
            Element pElem = this.ncmlWriter.makeAttributeElement(param);
            pElem.setName("parameter");
            ctElem.addContent((Content)pElem);
        }
        return ctElem;
    }

    private Element writeGrid(Coverage grid) {
        Element varElem = new Element("grid");
        varElem.setAttribute("name", grid.getName());
        String desc = grid.getDescription() != null ? grid.getDescription() : "No description";
        varElem.setAttribute("desc", desc);
        DataType dt = grid.getDataType();
        if (dt != null) {
            varElem.setAttribute("type", dt.toString());
        }
        for (Attribute att : grid.attributes()) {
            varElem.addContent((Content)this.ncmlWriter.makeAttributeElement(att));
        }
        return varElem;
    }

    private static class GridCoverageComparator
    implements Comparator<Coverage> {
        private GridCoverageComparator() {
        }

        @Override
        public int compare(Coverage grid1, Coverage grid2) {
            return grid1.getName().compareTo(grid2.getName());
        }
    }
}

