/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.simpgeometry.adapter;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.ft2.simpgeometry.GeometryType;
import ucar.nc2.ft2.simpgeometry.Line;
import ucar.nc2.ft2.simpgeometry.Point;
import ucar.nc2.ft2.simpgeometry.Polygon;
import ucar.nc2.ft2.simpgeometry.adapter.SimpleGeometryCSBuilder;

public class SimpleGeometryCS {
    private final List<CoordinateAxis> simpleGeometryX;
    private final List<CoordinateAxis> simpleGeometryY;
    private final List<CoordinateAxis> simpleGeometryZ;
    private final List<CoordinateAxis> simpleGeometryID;
    SimpleGeometryCSBuilder builder;

    public SimpleGeometryCS(SimpleGeometryCSBuilder builder) {
        this.builder = builder;
        this.simpleGeometryX = new ArrayList<CoordinateAxis>();
        this.simpleGeometryY = new ArrayList<CoordinateAxis>();
        this.simpleGeometryZ = new ArrayList<CoordinateAxis>();
        this.simpleGeometryID = new ArrayList<CoordinateAxis>();
        for (CoordinateAxis axis : builder.getSgAxes()) {
            if (axis.getAxisType() == AxisType.SimpleGeometryX) {
                this.simpleGeometryX.add(axis);
                continue;
            }
            if (axis.getAxisType() == AxisType.SimpleGeometryY) {
                this.simpleGeometryY.add(axis);
                continue;
            }
            if (axis.getAxisType() == AxisType.SimpleGeometryZ) {
                this.simpleGeometryZ.add(axis);
                continue;
            }
            if (axis.getAxisType() != AxisType.SimpleGeometryID) continue;
            this.simpleGeometryID.add(axis);
        }
    }

    public GeometryType getGeometryType(String name) {
        return this.builder.getGeometryType(name);
    }

    public List<CoordinateAxis> getSimpleGeometryX() {
        return this.simpleGeometryX;
    }

    public List<CoordinateAxis> getSimpleGeometryY() {
        return this.simpleGeometryY;
    }

    public List<CoordinateAxis> getSimpleGeometryZ() {
        return this.simpleGeometryZ;
    }

    public List<CoordinateAxis> getSimpleGeometryID() {
        return this.simpleGeometryID;
    }

    public ImmutableList<Dimension> getDimensions() {
        return ImmutableList.copyOf(this.builder.getDimensions());
    }

    public Polygon getPolygon(String name, int index) {
        return this.builder.getPolygon(name, index);
    }

    public List<Polygon> getPolygons(String name, int indexBegin, int indexEnd) {
        return this.builder.getPolygons(name, indexBegin, indexEnd);
    }

    public Line getLine(String name, int index) {
        return this.builder.getLine(name, index);
    }

    public List<Line> getLines(String name, int indexBegin, int indexEnd) {
        return this.builder.getLines(name, indexBegin, indexEnd);
    }

    public Point getPoint(String name, int index) {
        return this.builder.getPoint(name, index);
    }

    public List<Point> getPoints(String name, int indexBegin, int indexEnd) {
        return this.builder.getPoints(name, indexBegin, indexEnd);
    }

    public static SimpleGeometryCS makeSGCoordSys(Formatter sbuff, CoordinateSystem cs, Variable v) {
        if (sbuff != null) {
            sbuff.format(" ", new Object[0]);
            v.getNameAndDimensions(sbuff, false, true);
            sbuff.format(" check CS %s: ", cs.getName());
        }
        SimpleGeometryCS gcs = new SimpleGeometryCS(new SimpleGeometryCSBuilder(null, cs, null));
        return gcs;
    }
}

