/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grid;

import com.google.auto.value.AutoValue;
import com.google.common.base.Splitter;
import com.google.common.math.DoubleMath;
import java.util.List;
import javax.annotation.Nullable;
import ucar.nc2.grid.AutoValue_CoordInterval;
import ucar.unidata.util.Format;

@AutoValue
public abstract class CoordInterval {
    public abstract double start();

    public abstract double end();

    public static CoordInterval create(double start, double end) {
        return new AutoValue_CoordInterval(start, end);
    }

    public double midpoint() {
        return (this.start() + this.end()) / 2.0;
    }

    public boolean fuzzyEquals(CoordInterval other, double tol) {
        return DoubleMath.fuzzyEquals((double)this.start(), (double)other.start(), (double)tol) && DoubleMath.fuzzyEquals((double)this.end(), (double)other.end(), (double)tol);
    }

    public String toString() {
        return this.toString(3);
    }

    public String toString(int ndecimals) {
        return Format.d(this.start(), ndecimals) + "-" + Format.d(this.end(), ndecimals);
    }

    @Nullable
    public static CoordInterval parse(String source) {
        List ss = Splitter.on((char)'-').omitEmptyStrings().trimResults().splitToList((CharSequence)source);
        if (ss.size() != 2) {
            return null;
        }
        try {
            double start = Double.parseDouble((String)ss.get(0));
            double end = Double.parseDouble((String)ss.get(1));
            return CoordInterval.create(start, end);
        }
        catch (Exception e) {
            return null;
        }
    }
}

