/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grid;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.array.Array;
import ucar.array.RangeIterator;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.AttributeContainerMutable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.grid.GridAxis1D;
import ucar.nc2.grid.GridSubset;
import ucar.nc2.util.Indent;
import ucar.unidata.util.StringUtil2;

@Immutable
public abstract class GridAxis
implements Iterable<Object> {
    private static final Logger logger = LoggerFactory.getLogger(GridAxis.class);
    protected final String name;
    protected final String units;
    protected final String description;
    protected final AxisType axisType;
    protected final AttributeContainer attributes;
    protected final DependenceType dependenceType;
    protected final ImmutableList<String> dependsOn;
    protected final Spacing spacing;
    protected final double resolution;
    protected final boolean isSubset;

    public abstract Array<Double> getCoordsAsArray();

    public abstract Array<Double> getCoordBoundsAsArray();

    @Nullable
    public abstract GridAxis subset(GridSubset var1, Formatter var2);

    public abstract Optional<GridAxis> subsetDependent(GridAxis1D var1, Formatter var2);

    public abstract RangeIterator getRangeIterator();

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUnits() {
        return this.units;
    }

    public AxisType getAxisType() {
        return this.axisType;
    }

    public AttributeContainer attributes() {
        return this.attributes;
    }

    public Spacing getSpacing() {
        return this.spacing;
    }

    public boolean isRegular() {
        return this.spacing.isRegular();
    }

    public boolean isInterval() {
        return this.spacing.isInterval();
    }

    public double getResolution() {
        return this.resolution;
    }

    public DependenceType getDependenceType() {
        return this.dependenceType;
    }

    public ImmutableList<String> getDependsOn() {
        return this.dependsOn;
    }

    public boolean isSubset() {
        return this.isSubset;
    }

    public int compareTo(GridAxis o) {
        return this.axisType.axisOrder() - o.axisType.axisOrder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridAxis objects = (GridAxis)o;
        return Double.compare(objects.resolution, this.resolution) == 0 && this.name.equals(objects.name) && Objects.equals(this.description, objects.description) && Objects.equals(this.units, objects.units) && this.axisType == objects.axisType && this.attributes.equals(objects.attributes) && this.dependenceType == objects.dependenceType && this.dependsOn.equals(objects.dependsOn) && this.spacing == objects.spacing;
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.name, this.description, this.units, this.axisType, this.attributes, this.dependenceType, this.dependsOn, this.spacing, this.resolution});
        return result;
    }

    public String toString() {
        Formatter f = new Formatter();
        Indent indent = new Indent(2);
        this.toString(f, indent);
        return f.toString();
    }

    public void toString(Formatter f, Indent indent) {
        f.format("%sGridAxis '%s' (%s) ", indent, this.name, this.getClass().getName());
        indent.incr();
        f.format("%s", new Object[]{this.getDependenceType()});
        if (!this.dependsOn.isEmpty()) {
            f.format(" :", new Object[0]);
            for (String s : this.dependsOn) {
                f.format(" %s", s);
            }
        }
        f.format("%n", new Object[0]);
        f.format("%saxisType=%s units='%s' desc='%s'%n", new Object[]{indent, this.axisType, this.units, this.description});
        indent.incr();
        for (Attribute att : this.attributes) {
            f.format("%s%s%n", indent, att);
        }
        f.format("%n", new Object[0]);
        indent.decr();
        indent.decr();
    }

    protected GridAxis(Builder<?> builder) {
        Preconditions.checkNotNull((Object)((Builder)builder).name);
        Preconditions.checkNotNull((Object)((Object)builder.axisType));
        Preconditions.checkNotNull((Object)((Object)builder.spacing));
        this.units = ((Builder)builder).units == null ? ((Builder)builder).attributes.findAttributeString("units", "") : ((Builder)builder).units;
        this.description = ((Builder)builder).description == null ? ((Builder)builder).attributes.findAttributeString("long_name", "") : ((Builder)builder).description;
        this.name = ((Builder)builder).name;
        this.axisType = builder.axisType;
        this.attributes = ((Builder)builder).attributes.toImmutable();
        this.dependenceType = builder.dependenceType;
        this.dependsOn = ((Builder)builder).dependsOn == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)((Builder)builder).dependsOn);
        this.spacing = builder.spacing;
        this.resolution = builder.resolution;
        this.isSubset = builder.isSubset;
    }

    protected Builder<?> addLocalFieldsToBuilder(Builder<? extends Builder<?>> builder) {
        ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)builder.setName(this.name).setUnits(this.units)).setDescription(this.getDescription())).setAxisType(this.axisType)).setAttributes(this.attributes)).setDependenceType(this.dependenceType)).setDependsOn((List<String>)this.dependsOn)).setSpacing(this.spacing)).setIsSubset(this.isSubset);
        return builder;
    }

    public static abstract class Builder<T extends Builder<T>> {
        private String name;
        private String description;
        private String units;
        public AxisType axisType;
        private AttributeContainerMutable attributes = new AttributeContainerMutable(null);
        DependenceType dependenceType = DependenceType.independent;
        private ArrayList<String> dependsOn;
        Spacing spacing;
        double resolution;
        boolean isSubset;

        protected abstract T self();

        public T setName(String name) {
            this.name = name;
            return this.self();
        }

        public T setDescription(String description) {
            this.description = description;
            return this.self();
        }

        public T setAxisType(AxisType axisType) {
            this.axisType = axisType;
            return this.self();
        }

        public T addAttribute(Attribute att) {
            this.attributes.addAttribute(att);
            return this.self();
        }

        public T setAttributes(AttributeContainer attributes) {
            this.attributes = new AttributeContainerMutable(null, attributes);
            return this.self();
        }

        public T setDependenceType(DependenceType dependenceType) {
            this.dependenceType = dependenceType;
            return this.self();
        }

        public T setDependsOn(List<String> dependsOn) {
            this.dependsOn = new ArrayList<String>(dependsOn);
            return this.self();
        }

        public T setDependsOn(String dependsOn) {
            this.setDependsOn((List<String>)StringUtil2.splitList(dependsOn));
            return this.self();
        }

        public T setSpacing(Spacing spacing) {
            this.spacing = spacing;
            return this.self();
        }

        public T setResolution(double resolution) {
            this.resolution = resolution;
            return this.self();
        }

        public T setIsSubset(boolean subset) {
            this.isSubset = subset;
            return this.self();
        }

        public T setUnits(String units) {
            this.units = units;
            return this.self();
        }

        public String toString() {
            return this.name;
        }

        T initFromVariableDS(VariableDS vds) {
            return ((Builder)((Builder)((Builder)this.setName(vds.getShortName())).setUnits(vds.getUnitsString())).setDescription(vds.getDescription())).setAttributes(vds.attributes());
        }

        public abstract GridAxis build();
    }

    public static enum DependenceType {
        independent,
        dependent,
        scalar,
        twoD,
        fmrcReg,
        dimension;

    }

    public static enum Spacing {
        regularPoint,
        irregularPoint,
        regularInterval,
        contiguousInterval,
        discontiguousInterval;


        public boolean isRegular() {
            return this == regularPoint || this == regularInterval;
        }

        public boolean isInterval() {
            return this == regularInterval || this == contiguousInterval || this == discontiguousInterval;
        }
    }
}

