/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grid;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import ucar.array.Array;
import ucar.array.ArrayType;
import ucar.array.Arrays;
import ucar.array.InvalidRangeException;
import ucar.array.MinMax;
import ucar.array.Range;
import ucar.array.RangeIterator;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.grid.CoordInterval;
import ucar.nc2.grid.GridAxis;
import ucar.nc2.grid.GridSubset;
import ucar.nc2.internal.grid.GridAxis1DHelper;
import ucar.nc2.util.Indent;

@Immutable
public class GridAxis1D
extends GridAxis {
    final int ncoords;
    final double startValue;
    final double endValue;
    final Range range;
    final double[] values;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GridAxis1D objects = (GridAxis1D)o;
        return this.ncoords == objects.ncoords && Double.compare(objects.startValue, this.startValue) == 0 && Double.compare(objects.endValue, this.endValue) == 0 && Objects.equals(this.range, objects.range) && java.util.Arrays.equals(this.values, objects.values);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.ncoords, this.startValue, this.endValue, this.range);
        result = 31 * result + java.util.Arrays.hashCode(this.values);
        return result;
    }

    @Override
    public void toString(Formatter f, Indent indent) {
        super.toString(f, indent);
        f.format("%snpts: %d [%f,%f] resolution=%f spacing=%s", new Object[]{indent, this.ncoords, this.startValue, this.endValue, this.resolution, this.spacing});
        f.format("%s range=%s isSubset=%s", indent, this.range, this.isSubset());
        f.format("%n", new Object[0]);
        if (this.values != null) {
            int n = this.values.length;
            switch (this.spacing) {
                case irregularPoint: 
                case contiguousInterval: {
                    f.format("%scontiguous values (%d)=", indent, n);
                    for (double v : this.values) {
                        f.format("%f,", v);
                    }
                    f.format("%n", new Object[0]);
                    break;
                }
                case discontiguousInterval: {
                    f.format("%sdiscontiguous values (%d)=", indent, n);
                    for (int i = 0; i < n; i += 2) {
                        f.format("(%f,%f) ", this.values[i], this.values[i + 1]);
                    }
                    f.format("%n", new Object[0]);
                }
            }
        }
    }

    public String getSummary() {
        Formatter f = new Formatter();
        f.format("start=%f end=%f %s %s resolution=%f", new Object[]{this.startValue, this.endValue, this.units, this.spacing, this.resolution});
        f.format(" (npts=%d)", this.ncoords);
        return f.toString();
    }

    public boolean isAscending() {
        switch (this.spacing) {
            case regularInterval: 
            case regularPoint: {
                return this.getResolution() > 0.0;
            }
            case irregularPoint: {
                return this.values[0] <= this.values[this.ncoords - 1];
            }
            case contiguousInterval: {
                return this.values[0] <= this.values[this.ncoords];
            }
            case discontiguousInterval: {
                return this.values[0] <= this.values[2 * this.ncoords - 1];
            }
        }
        throw new IllegalStateException("unknown spacing" + (Object)((Object)this.spacing));
    }

    public MinMax getCoordEdgeMinMax() {
        if (this.spacing != GridAxis.Spacing.discontiguousInterval) {
            double min = Math.min(this.getCoordEdge1(0), this.getCoordEdge2(this.ncoords - 1));
            double max = Math.max(this.getCoordEdge1(0), this.getCoordEdge2(this.ncoords - 1));
            return MinMax.create(min, max);
        }
        double max = -1.7976931348623157E308;
        double min = Double.MAX_VALUE;
        for (int i = 0; i < this.ncoords; ++i) {
            min = Math.min(min, this.getCoordEdge1(i));
            min = Math.min(min, this.getCoordEdge2(i));
            max = Math.max(max, this.getCoordEdge1(i));
            max = Math.max(max, this.getCoordEdge2(i));
        }
        return MinMax.create(min, max);
    }

    public double getCoordMidpoint(int index) {
        if (index < 0 || index >= this.getNcoords()) {
            throw new IllegalArgumentException("Index out of range=" + index);
        }
        switch (this.spacing) {
            case regularPoint: {
                return this.startValue + (double)index * this.getResolution();
            }
            case irregularPoint: {
                return this.values[index];
            }
            case regularInterval: {
                return this.startValue + ((double)index + 0.5) * this.getResolution();
            }
            case contiguousInterval: 
            case discontiguousInterval: {
                return (this.getCoordEdge1(index) + this.getCoordEdge2(index)) / 2.0;
            }
        }
        throw new IllegalStateException("Unknown spacing=" + (Object)((Object)this.spacing));
    }

    public double getCoordEdge1(int index) {
        if (index < 0 || index >= this.getNcoords()) {
            throw new IllegalArgumentException("Index out of range=" + index);
        }
        switch (this.spacing) {
            case regularPoint: {
                return this.startValue + ((double)index - 0.5) * this.getResolution();
            }
            case regularInterval: {
                return this.startValue + (double)index * this.getResolution();
            }
            case irregularPoint: {
                if (index > 0) {
                    return (this.values[index - 1] + this.values[index]) / 2.0;
                }
                return this.values[0] - (this.values[1] - this.values[0]) / 2.0;
            }
            case contiguousInterval: {
                return this.values[index];
            }
            case discontiguousInterval: {
                return this.values[2 * index];
            }
        }
        throw new IllegalStateException("Unknown spacing=" + (Object)((Object)this.spacing));
    }

    public double getCoordEdge2(int index) {
        if (index < 0 || index >= this.getNcoords()) {
            throw new IllegalArgumentException("Index out of range=" + index);
        }
        switch (this.spacing) {
            case regularPoint: {
                return this.startValue + ((double)index + 0.5) * this.getResolution();
            }
            case regularInterval: {
                return this.startValue + (double)(index + 1) * this.getResolution();
            }
            case irregularPoint: {
                if (index < this.ncoords - 1) {
                    return (this.values[index] + this.values[index + 1]) / 2.0;
                }
                return this.values[index] + (this.values[index] - this.values[index - 1]) / 2.0;
            }
            case contiguousInterval: {
                return this.values[index + 1];
            }
            case discontiguousInterval: {
                return this.values[2 * index + 1];
            }
        }
        throw new IllegalStateException("Unknown spacing=" + (Object)((Object)this.spacing));
    }

    public CoordInterval getCoordInterval(int index) {
        return CoordInterval.create(this.getCoordEdge1(index), this.getCoordEdge2(index));
    }

    @Override
    public Array<Double> getCoordsAsArray() {
        double[] vals = new double[this.ncoords];
        for (int i = 0; i < this.ncoords; ++i) {
            vals[i] = this.getCoordMidpoint(i);
        }
        Array<Double> result = this.dependenceType == GridAxis.DependenceType.scalar ? Arrays.factory(ArrayType.DOUBLE, new int[0], vals) : Arrays.factory(ArrayType.DOUBLE, new int[]{this.ncoords}, vals);
        return result;
    }

    @Override
    public Array<Double> getCoordBoundsAsArray() {
        double[] vals = new double[2 * this.ncoords];
        int count = 0;
        for (int i = 0; i < this.ncoords; ++i) {
            vals[count++] = this.getCoordEdge1(i);
            vals[count++] = this.getCoordEdge2(i);
        }
        return Arrays.factory(ArrayType.DOUBLE, new int[]{this.ncoords, 2}, vals);
    }

    public int getNcoords() {
        return this.ncoords;
    }

    public double getStartValue() {
        return this.startValue;
    }

    public double getEndValue() {
        return this.endValue;
    }

    public double[] getValues() {
        return this.values == null ? null : java.util.Arrays.copyOf(this.values, this.values.length);
    }

    @Override
    public Iterator<Object> iterator() {
        return new CoordIterator();
    }

    @Override
    public RangeIterator getRangeIterator() {
        if (this.range != null) {
            return this.range;
        }
        try {
            return new Range(this.axisType.toString(), 0, this.ncoords - 1);
        }
        catch (InvalidRangeException e) {
            throw new RuntimeException(e);
        }
    }

    public Range getRange() {
        if (this.getDependenceType() == GridAxis.DependenceType.scalar) {
            return Range.EMPTY;
        }
        try {
            return new Range(this.axisType.toString(), 0, this.ncoords - 1);
        }
        catch (InvalidRangeException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public GridAxis subset(GridSubset params, Formatter errLog) {
        if (params == null) {
            return this;
        }
        Builder<?> builder = this.subsetBuilder(params, errLog);
        return builder == null ? null : builder.build();
    }

    @Nullable
    private Builder<?> subsetBuilder(GridSubset params, Formatter errLog) {
        GridAxis1DHelper helper = new GridAxis1DHelper(this);
        switch (this.getAxisType()) {
            case GeoZ: 
            case Pressure: 
            case Height: {
                Double dval = params.getVertPoint();
                if (dval != null) {
                    return helper.subsetClosest(dval);
                }
                CoordInterval intv = params.getVertIntv();
                if (intv == null) break;
                return helper.subsetClosest(intv);
            }
            case Ensemble: {
                Double eval = params.getEnsCoord();
                if (eval == null) break;
                return helper.subsetClosest(eval);
            }
            case TimeOffset: {
                Double dval = params.getTimeOffset();
                if (dval != null) {
                    return helper.subsetClosest(dval);
                }
                CoordInterval intv = params.getTimeOffsetIntv();
                if (intv instanceof CoordInterval) {
                    return helper.subsetClosest(intv);
                }
                if (!params.getTimeOffsetFirst()) break;
                return helper.makeSubsetByIndex(new Range(1));
            }
            case GeoX: 
            case GeoY: 
            case Lat: 
            case Lon: {
                return null;
            }
        }
        return this.toBuilder();
    }

    @Override
    public Optional<GridAxis> subsetDependent(GridAxis1D subsetIndAxis, Formatter errLog) {
        Builder<?> builder = new GridAxis1DHelper(this).makeSubsetByIndex(subsetIndAxis.getRange());
        return Optional.of(builder.build());
    }

    GridAxis1D(Builder<?> builder) {
        super(builder);
        String rangeName;
        Preconditions.checkArgument((builder.ncoords > 0 ? 1 : 0) != 0);
        this.ncoords = builder.ncoords;
        this.startValue = builder.startValue;
        this.endValue = builder.endValue;
        this.values = builder.values;
        if (this.axisType == null && builder.dependenceType == GridAxis.DependenceType.independent) {
            throw new IllegalArgumentException("independent axis must have type");
        }
        String string = rangeName = this.axisType != null ? this.axisType.toString() : null;
        this.range = ((Builder)builder).range != null ? (rangeName != null ? ((Builder)builder).range.copyWithName(rangeName) : ((Builder)builder).range) : Range.make(rangeName, this.getNcoords());
    }

    public Builder<?> toBuilder() {
        return this.addLocalFieldsToBuilder(GridAxis1D.builder());
    }

    protected Builder<?> addLocalFieldsToBuilder(Builder<? extends GridAxis.Builder<?>> builder) {
        ((Builder)((Builder)builder.setRegular(this.ncoords, this.startValue, this.endValue, this.resolution)).setValues(this.values)).setRange(this.range);
        return (Builder)super.addLocalFieldsToBuilder(builder);
    }

    public static Builder<?> builder(VariableDS vds) {
        return (Builder)GridAxis1D.builder().initFromVariableDS(vds);
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public static abstract class Builder<T extends Builder<T>>
    extends GridAxis.Builder<T> {
        int ncoords;
        double startValue;
        double endValue;
        protected double[] values;
        private Range range;
        private boolean built = false;

        public T setNcoords(int ncoords) {
            this.ncoords = ncoords;
            return (T)((Builder)this.self());
        }

        public T setValues(double[] values) {
            this.values = values;
            return (T)((Builder)this.self());
        }

        public T setValues(List<Double> values) {
            this.values = new double[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                this.values[i] = values.get(i);
            }
            return (T)((Builder)this.self());
        }

        public T setRegular(int ncoords, double startValue, double endValue, double increment) {
            this.ncoords = ncoords;
            this.startValue = startValue;
            this.endValue = endValue;
            this.resolution = increment;
            return (T)((Builder)this.self());
        }

        public T setRange(Range range) {
            this.range = range;
            return (T)((Builder)this.self());
        }

        public T subset(int ncoords, double startValue, double endValue, double resolution, Range range) {
            this.ncoords = ncoords;
            this.startValue = startValue;
            this.endValue = endValue;
            this.resolution = resolution;
            this.range = range;
            this.isSubset = true;
            this.values = this.makeValues(range);
            return (T)((Builder)this.self());
        }

        private double[] makeValues(Range range) {
            if (this.spacing.isRegular()) {
                return null;
            }
            double[] subsetValues = null;
            int count = 0;
            switch (this.spacing) {
                case irregularPoint: {
                    subsetValues = new double[this.ncoords];
                    for (int i : range) {
                        subsetValues[count++] = this.values[i];
                    }
                    break;
                }
                case contiguousInterval: {
                    subsetValues = new double[this.ncoords + 1];
                    for (int i : range) {
                        subsetValues[count++] = this.values[i];
                    }
                    subsetValues[count] = this.values[range.last() + 1];
                    break;
                }
                case discontiguousInterval: {
                    subsetValues = new double[2 * this.ncoords];
                    for (int i : range) {
                        subsetValues[count++] = this.values[2 * i];
                        subsetValues[count++] = this.values[2 * i + 1];
                    }
                    break;
                }
            }
            return subsetValues;
        }

        @Override
        public GridAxis1D build() {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            return new GridAxis1D(this);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    private class CoordIterator
    extends AbstractIterator<Object> {
        private int current = 0;

        private CoordIterator() {
        }

        protected Object computeNext() {
            if (this.current >= GridAxis1D.this.getNcoords()) {
                return this.endOfData();
            }
            Double result = GridAxis1D.this.spacing.isInterval() ? CoordInterval.create(GridAxis1D.this.getCoordEdge1(this.current), GridAxis1D.this.getCoordEdge2(this.current)) : Double.valueOf(GridAxis1D.this.getCoordMidpoint(this.current));
            ++this.current;
            return result;
        }
    }
}

