/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grid;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.array.InvalidRangeException;
import ucar.array.Range;
import ucar.array.RangeIterator;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.grid.CoordInterval;
import ucar.nc2.grid.GridAxis;
import ucar.nc2.grid.GridAxis1D;
import ucar.nc2.grid.GridSubset;
import ucar.nc2.internal.grid.GridAxis1DHelper;
import ucar.nc2.internal.grid.TimeHelper;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.util.Indent;

@Immutable
public class GridAxis1DTime
extends GridAxis1D {
    private static final Logger logger = LoggerFactory.getLogger(GridAxis1DTime.class);
    private final TimeHelper timeHelper;
    private final ImmutableList<CalendarDate> cdates;

    public ImmutableList<CalendarDate> getCalendarDates() {
        return this.cdates;
    }

    public CalendarDate getCalendarDate(int idx) {
        return (CalendarDate)this.cdates.get(idx);
    }

    public CalendarDateRange getCalendarDateRange() {
        int last = this.cdates.size();
        return last > 0 ? CalendarDateRange.of((CalendarDate)this.cdates.get(0), (CalendarDate)this.cdates.get(last - 1)) : null;
    }

    public double makeValue(CalendarDate date) {
        return this.timeHelper.offsetFromRefDate(date);
    }

    public TimeHelper getTimeHelper() {
        return this.timeHelper;
    }

    public int findTimeIndexFromCalendarDate(CalendarDate d) {
        int index;
        ImmutableList<CalendarDate> cdates = this.getCalendarDates();
        for (index = 0; index < cdates.size() && d.compareTo((CalendarDate)cdates.get(index)) >= 0; ++index) {
        }
        return Math.max(0, index - 1);
    }

    public boolean hasCalendarDate(CalendarDate date) {
        ImmutableList<CalendarDate> cdates = this.getCalendarDates();
        for (CalendarDate cd : cdates) {
            if (!date.equals(cd)) continue;
            return true;
        }
        return false;
    }

    public CalendarDate[] getCoordBoundsDate(int i) {
        CalendarDate[] e = new CalendarDate[]{this.timeHelper.makeCalendarDateFromOffset(this.getCoordEdge1(i)), this.timeHelper.makeCalendarDateFromOffset(this.getCoordEdge2(i))};
        return e;
    }

    public CalendarDate getCoordBoundsMidpointDate(int i) {
        return this.timeHelper.makeCalendarDateFromOffset(this.getCoordMidpoint(i));
    }

    public static CalendarDate addOffset(CalendarDate runDate, double offset, String offsetUnits) {
        CalendarPeriod.Field field = CalendarPeriod.fromUnitString(offsetUnits);
        int offseti = (int)offset;
        if ((double)offseti != offset) {
            throw new RuntimeException(String.format("Not integral offset = %f", offset));
        }
        return runDate.add(CalendarPeriod.of(offseti, field));
    }

    public CalendarDateUnit getCalendarDateUnit() {
        return this.timeHelper.getCalendarDateUnit();
    }

    public CalendarDate getRefDate() {
        return this.timeHelper.getRefDate();
    }

    public double getOffsetInTimeUnits(CalendarDate start, CalendarDate end) {
        return this.timeHelper.getOffsetInTimeUnits(start, end);
    }

    public CalendarDate makeDateInTimeUnits(CalendarDate start, double addTo) {
        return this.timeHelper.makeDateInTimeUnits(start, addTo);
    }

    public Calendar getCalendar() {
        return this.timeHelper.getCalendar();
    }

    public CalendarDate makeDate(double value) {
        return this.timeHelper.makeDate(value);
    }

    @Override
    @Nullable
    public GridAxis subset(GridSubset params, Formatter errLog) {
        if (params == null) {
            return this;
        }
        GridAxis1D.Builder<?> builder = this.subsetBuilder(params, errLog);
        return builder == null ? null : builder.build();
    }

    @Nullable
    private GridAxis1D.Builder<?> subsetBuilder(GridSubset params, Formatter errLog) {
        GridAxis1DHelper helper = new GridAxis1DHelper(this);
        switch (this.getAxisType()) {
            case Time: {
                CalendarDateRange dateRange;
                if (params.getTimePresent()) {
                    return helper.subsetLatest();
                }
                CalendarDate date = params.getTime();
                if (date != null) {
                    return helper.subsetClosest(date);
                }
                Double dval = params.getTimePoint();
                if (dval != null) {
                    return helper.subsetClosest(dval);
                }
                CoordInterval intv = params.getTimeIntv();
                if (intv != null) {
                    return helper.subsetClosest(intv);
                }
                Integer stride = params.getTimeStride();
                if (stride == null || stride < 0) {
                    stride = 1;
                }
                if ((dateRange = params.getTimeRange()) != null) {
                    return helper.subset(dateRange, stride, errLog).orElse(null);
                }
                Double timeOffset = params.getTimeOffset();
                CalendarDate runtime = params.getRunTime();
                if (timeOffset != null) {
                    if (runtime != null) {
                        date = this.makeDateInTimeUnits(runtime, timeOffset);
                        return helper.subsetClosest(date);
                    }
                    return helper.subsetClosest(timeOffset);
                }
                CoordInterval timeOffsetIntv = params.getTimeOffsetIntv();
                if (timeOffsetIntv != null && runtime != null) {
                    CalendarDate[] dateIntv = new CalendarDate[]{this.makeDateInTimeUnits(runtime, timeOffsetIntv.start()), this.makeDateInTimeUnits(runtime, timeOffsetIntv.end())};
                    return helper.subsetClosest(dateIntv);
                }
                if (stride == 1) break;
                try {
                    return helper.makeSubsetByIndex(this.getRange().copyWithStride(stride));
                }
                catch (InvalidRangeException e) {
                    errLog.format(e.getMessage(), new Object[0]);
                    return null;
                }
            }
            case RunTime: {
                CalendarDate rundate = params.getRunTime();
                if (rundate != null) {
                    return helper.subsetClosest(rundate);
                }
                if (params.getRunTimeAll()) break;
                return helper.subsetLatest();
            }
        }
        return this.toBuilder();
    }

    @Override
    public String getSummary() {
        if (this.axisType != AxisType.RunTime) {
            return super.getSummary();
        }
        if (this.ncoords < 7) {
            Formatter f = new Formatter();
            for (int i = 0; i < this.ncoords; ++i) {
                CalendarDate cd = this.timeHelper.makeDate(this.getCoordMidpoint(i));
                if (i > 0) {
                    f.format(", ", new Object[0]);
                }
                f.format("%s", cd);
            }
            return f.toString();
        }
        Formatter f = new Formatter();
        CalendarDate start = this.timeHelper.makeDate(this.getStartValue());
        f.format("start=%s", start);
        CalendarDate end = this.timeHelper.makeDate(this.getEndValue());
        f.format(", end=%s", end);
        f.format(" (npts=%d spacing=%s)", new Object[]{this.getNcoords(), this.getSpacing()});
        return f.toString();
    }

    @Override
    public void toString(Formatter f, Indent indent) {
        super.toString(f, indent);
        f.format("%s dateUnit '%s' dates =%s%n", indent, this.timeHelper.getUdUnit(), this.cdates);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GridAxis1DTime that = (GridAxis1DTime)o;
        return Objects.equals(this.timeHelper.getUdUnit(), that.timeHelper.getUdUnit());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.timeHelper, this.cdates);
    }

    protected GridAxis1DTime(Builder<?> builder) {
        super((GridAxis1D.Builder<?>)builder);
        this.timeHelper = ((Builder)builder).timeHelper != null ? ((Builder)builder).timeHelper : TimeHelper.factory(this.units, this.attributes);
        if (this.range != null && ((Builder)builder).cdates != null) {
            this.cdates = this.subsetDatesByRange(((Builder)builder).cdates, this.range);
            Preconditions.checkArgument((this.cdates.size() == this.getNcoords() ? 1 : 0) != 0);
        } else if (((Builder)builder).cdates != null) {
            this.cdates = ImmutableList.copyOf((Collection)((Builder)builder).cdates);
            Preconditions.checkArgument((this.cdates.size() == this.getNcoords() ? 1 : 0) != 0);
        } else {
            this.cdates = this.makeCalendarDateFromValues();
        }
    }

    private ImmutableList<CalendarDate> makeCalendarDateFromValues() {
        ArrayList<CalendarDate> result = new ArrayList<CalendarDate>(this.getNcoords());
        for (double val : this.getCoordsAsArray()) {
            result.add(this.timeHelper.makeCalendarDateFromOffset(val));
        }
        return ImmutableList.copyOf(result);
    }

    private ImmutableList<CalendarDate> subsetDatesByRange(List<CalendarDate> dates, RangeIterator range) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int index : range) {
            builder.add((Object)dates.get(index));
        }
        return builder.build();
    }

    public Builder<?> toBuilder() {
        return this.addLocalFieldsToBuilder(GridAxis1DTime.builder());
    }

    protected Builder<?> addLocalFieldsToBuilder(Builder<? extends Builder<?>> b) {
        b.setTimeHelper(this.timeHelper);
        return (Builder)super.addLocalFieldsToBuilder((GridAxis1D.Builder<? extends GridAxis.Builder<?>>)b);
    }

    public static Builder<?> builder(VariableDS vds) {
        return (Builder)GridAxis1DTime.builder().initFromVariableDS(vds);
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public static abstract class Builder<T extends Builder<T>>
    extends GridAxis1D.Builder<T> {
        private boolean built;
        private TimeHelper timeHelper;
        private List<CalendarDate> cdates;

        @Override
        protected abstract T self();

        public T setDateUnits(String dateUnits) {
            this.timeHelper = TimeHelper.factory(dateUnits, null);
            return (T)this.self();
        }

        public T setTimeHelper(TimeHelper timeHelper) {
            this.timeHelper = timeHelper;
            return (T)this.self();
        }

        public T setCalendarDates(List<CalendarDate> cdates) {
            this.cdates = cdates;
            return (T)this.self();
        }

        @Override
        public T subset(int ncoords, double startValue, double endValue, double resolution, Range range) {
            super.subset(ncoords, startValue, endValue, resolution, range);
            return (T)this.self();
        }

        @Override
        public GridAxis1DTime build() {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            if (this.axisType == null) {
                this.axisType = AxisType.Time;
            }
            if (this.cdates != null && this.timeHelper != null) {
                this.setValues(this.makeValuesFromCalendarDate());
            }
            return new GridAxis1DTime(this);
        }

        private double[] makeValuesFromCalendarDate() {
            double[] values = new double[this.cdates.size()];
            int count = 0;
            for (CalendarDate cd : this.cdates) {
                values[count++] = this.timeHelper.offsetFromRefDate(cd);
            }
            return values;
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }
}

