/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grid;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import ucar.array.Array;
import ucar.array.ArrayType;
import ucar.array.Arrays;
import ucar.array.InvalidRangeException;
import ucar.array.Range;
import ucar.array.RangeIterator;
import ucar.nc2.AttributeContainer;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.grid.GridAxis;
import ucar.nc2.grid.GridAxis1D;
import ucar.nc2.grid.GridAxis1DTime;
import ucar.nc2.grid.GridSubset;
import ucar.nc2.internal.grid.GridAxis1DHelper;
import ucar.nc2.internal.grid.TimeHelper;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.Indent;
import ucar.nc2.write.NcdumpArray;

@Immutable
public class GridAxisOffsetTimeRegular
extends GridAxis {
    private final TimeHelper timeHelper;
    private final GridAxis1DTime runtimeAxis;
    private final Array<Double> midpoints;
    private final Array<Double> bounds;
    private final ImmutableList<Integer> hourOffsets;

    @Override
    public Array<Double> getCoordsAsArray() {
        return this.midpoints;
    }

    @Override
    public Array<Double> getCoordBoundsAsArray() {
        return this.bounds;
    }

    public ImmutableList<Integer> getHourOffsets() {
        return this.hourOffsets;
    }

    public int getNOffsetPerRun() {
        return this.midpoints.getShape()[1];
    }

    public GridAxis1DTime getRunTimeAxis() {
        return this.runtimeAxis;
    }

    @Nullable
    public GridAxis1D getTimeOffsetAxisForRun(CalendarDate rundate) {
        double rundateTarget = this.runtimeAxis.makeValue(rundate);
        int run_index = new GridAxis1DHelper(this.runtimeAxis).findCoordElement(rundateTarget, false);
        try {
            return run_index < 0 || run_index >= this.runtimeAxis.getNcoords() ? null : this.getTimeOffsetAxisForRun(run_index);
        }
        catch (InvalidRangeException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public GridAxis1D getTimeOffsetAxisForRun(int run_index) throws InvalidRangeException {
        Array<Double> data;
        GridAxis1D.Builder builder = (GridAxis1D.Builder)((GridAxis1D.Builder)((GridAxis1D.Builder)((GridAxis1D.Builder)((GridAxis1D.Builder)((GridAxis1D.Builder)((GridAxis1D.Builder)((GridAxis1D.Builder)GridAxis1D.builder().setName(this.name)).setUnits(this.units)).setDescription(this.description)).setAxisType(this.axisType)).setAttributes(AttributeContainer.filter(this.attributes, "_Coordinate"))).setDependenceType(GridAxis.DependenceType.independent)).setDependsOn((List<String>)this.dependsOn)).setSpacing(this.spacing);
        if (this.spacing == GridAxis.Spacing.irregularPoint) {
            data = this.getCoordsAsArray();
        } else if (this.spacing == GridAxis.Spacing.discontiguousInterval) {
            data = this.getCoordBoundsAsArray();
        } else {
            throw new RuntimeException("getTimeAxisForRun spacing=" + (Object)((Object)this.spacing));
        }
        CalendarDate runtime = this.runtimeAxis.getCalendarDate(run_index);
        int hourOffset = runtime.getHourOfDay();
        int hourOffsetIdx = this.hourOffsets.indexOf((Object)hourOffset);
        if (hourOffsetIdx < 0) {
            throw new IllegalStateException(String.format("Cant find runtime %s hour offset %d in %s hours %s", runtime, hourOffset, this.getName(), this.hourOffsets));
        }
        Array<Double> subset = Arrays.slice(data, 0, hourOffsetIdx);
        int countNonNaN = 0;
        boolean hasNaN = false;
        for (double dval : subset) {
            if (Double.isNaN(dval)) {
                hasNaN = true;
                continue;
            }
            if (hasNaN) {
                throw new IllegalStateException("Coordinate NaNs must be at the end for " + this.getName());
            }
            ++countNonNaN;
        }
        int count = 0;
        double[] values = new double[countNonNaN];
        for (double dval : subset) {
            values[count++] = dval;
            if (count != countNonNaN) continue;
            break;
        }
        int ncoords = this.spacing == GridAxis.Spacing.irregularPoint ? values.length : values.length / 2;
        builder.setValues(values);
        builder.setNcoords(ncoords);
        builder.setIsSubset(true);
        return builder.build();
    }

    @Override
    @Nullable
    public GridAxis subset(GridSubset params, Formatter errlog) {
        if (params == null) {
            return this;
        }
        CalendarDate rundate = params.getRunTime();
        boolean runtimeAll = params.getRunTimeAll();
        boolean latest = rundate == null && !runtimeAll;
        int run_index = -1;
        if (latest) {
            run_index = this.runtimeAxis.getNcoords() - 1;
        } else if (rundate != null) {
            GridAxis1D time1D = this.getTimeOffsetAxisForRun(rundate);
            return time1D.subset(params, errlog);
        }
        if (run_index >= 0) {
            try {
                GridAxis1D time1D = this.getTimeOffsetAxisForRun(run_index);
                return time1D.subset(params, errlog);
            }
            catch (InvalidRangeException e) {
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    @Override
    public Optional<GridAxis> subsetDependent(GridAxis1D subsetIndAxis, Formatter errlog) {
        return Optional.empty();
    }

    @Override
    public RangeIterator getRangeIterator() {
        return null;
    }

    @Override
    public Iterator<Object> iterator() {
        return null;
    }

    @Override
    public void toString(Formatter f, Indent indent) {
        super.toString(f, indent);
        f.format("%s  %s%n", indent, java.util.Arrays.toString(this.getCoordsAsArray().getShape()));
        f.format("%s%n", NcdumpArray.printArray(this.getCoordsAsArray(), this.getName() + " values", null));
        if (this.getCoordBoundsAsArray() != null) {
            f.format("%n%s%n", NcdumpArray.printArray(this.getCoordBoundsAsArray(), this.getName() + " bounds", null));
        }
    }

    protected GridAxisOffsetTimeRegular(Builder<?> builder) {
        super(builder);
        Preconditions.checkNotNull((Object)((Builder)builder).runtimeAxis);
        Preconditions.checkNotNull((Object)((Builder)builder).midpoints);
        Preconditions.checkNotNull((Object)((Builder)builder).bounds);
        Preconditions.checkNotNull((Object)((Builder)builder).hourOffsets);
        Preconditions.checkArgument((((Builder)builder).midpoints.getRank() == 2 ? 1 : 0) != 0);
        Preconditions.checkArgument((((Builder)builder).bounds.getRank() == 3 ? 1 : 0) != 0);
        int nhours = ((Builder)builder).hourOffsets.size();
        int noffsets = ((Builder)builder).midpoints.getShape()[1];
        Preconditions.checkArgument((boolean)java.util.Arrays.equals(((Builder)builder).midpoints.getShape(), new int[]{nhours, noffsets}));
        Preconditions.checkArgument((boolean)java.util.Arrays.equals(((Builder)builder).bounds.getShape(), new int[]{nhours, noffsets, 2}));
        this.runtimeAxis = ((Builder)builder).runtimeAxis;
        this.midpoints = ((Builder)builder).midpoints;
        this.bounds = ((Builder)builder).bounds;
        this.timeHelper = ((Builder)builder).timeHelper != null ? ((Builder)builder).timeHelper : ((Builder)builder).runtimeAxis.getTimeHelper();
        this.hourOffsets = ImmutableList.copyOf((Collection)((Builder)builder).hourOffsets);
    }

    private ImmutableList<CalendarDate> subsetDatesByRange(List<CalendarDate> dates, Range range) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int index : range) {
            builder.add((Object)dates.get(index));
        }
        return builder.build();
    }

    public Builder<?> toBuilder() {
        return this.addLocalFieldsToBuilder(GridAxisOffsetTimeRegular.builder());
    }

    protected Builder<?> addLocalFieldsToBuilder(Builder<? extends GridAxis.Builder<?>> builder) {
        builder.setTimeHelper(this.timeHelper);
        return (Builder)super.addLocalFieldsToBuilder(builder);
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public static Builder<?> builder(VariableDS vds) {
        return (Builder)GridAxisOffsetTimeRegular.builder().initFromVariableDS(vds);
    }

    public static abstract class Builder<T extends Builder<T>>
    extends GridAxis.Builder<T> {
        private boolean built;
        private TimeHelper timeHelper;
        private GridAxis1DTime runtimeAxis;
        private String runtimeAxisName;
        private Array<Double> midpoints;
        private Array<Double> bounds;
        private List<Integer> hourOffsets;

        @Override
        protected abstract T self();

        public T setTimeHelper(TimeHelper timeHelper) {
            this.timeHelper = timeHelper;
            return (T)this.self();
        }

        public T setRuntimeAxis(GridAxis1DTime runtimeAxis) {
            this.runtimeAxis = runtimeAxis;
            return (T)this.self();
        }

        public T setRuntimeAxis(List<GridAxis1DTime> runtimeAxes) {
            if (this.runtimeAxisName == null) {
                throw new IllegalStateException("Runtime axis name not set");
            }
            runtimeAxes.stream().filter(a -> a.getName().equals(this.runtimeAxisName)).findFirst().ifPresent(a -> {
                this.runtimeAxis = a;
            });
            if (this.runtimeAxis == null) {
                throw new IllegalStateException("Cant find runtime axis " + this.runtimeAxisName);
            }
            return (T)this.self();
        }

        public T setRuntimeAxisName(String runtimeAxisName) {
            this.runtimeAxisName = runtimeAxisName;
            return (T)this.self();
        }

        public T setMidpoints(Array<Double> midpoints) {
            this.midpoints = midpoints;
            return (T)this.self();
        }

        public T setBounds(Array<Double> bounds) {
            this.bounds = bounds;
            return (T)this.self();
        }

        public T setMidpointsBounds(List<Integer> shape, List<Double> midpoints, List<Double> bounds) {
            int i;
            Preconditions.checkArgument((shape.size() == 2 ? 1 : 0) != 0);
            int ntimes = shape.get(0);
            int nhours = shape.get(1);
            double[] mids = new double[ntimes * nhours];
            double[] bnds = new double[ntimes * nhours * 2];
            Preconditions.checkArgument((midpoints.size() == mids.length ? 1 : 0) != 0);
            Preconditions.checkArgument((bounds.size() == bnds.length ? 1 : 0) != 0);
            for (i = 0; i < midpoints.size(); ++i) {
                mids[i] = midpoints.get(i);
            }
            for (i = 0; i < bounds.size(); ++i) {
                bnds[i] = bounds.get(i);
            }
            this.midpoints = Arrays.factory(ArrayType.DOUBLE, new int[]{ntimes, nhours}, mids);
            this.bounds = Arrays.factory(ArrayType.DOUBLE, new int[]{ntimes, nhours, 2}, bnds);
            return (T)this.self();
        }

        public T setHourOffsets(List<Integer> hourOffsets) {
            this.hourOffsets = hourOffsets;
            return (T)this.self();
        }

        public T setHourOffsets(Array<Integer> hourOffsets) {
            this.hourOffsets = new ArrayList<Integer>();
            for (int hour : hourOffsets) {
                this.hourOffsets.add(hour);
            }
            return (T)this.self();
        }

        @Override
        public GridAxisOffsetTimeRegular build() {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            this.dependenceType = GridAxis.DependenceType.fmrcReg;
            this.setDependsOn(this.runtimeAxis.getName());
            this.axisType = AxisType.TimeOffset;
            return new GridAxisOffsetTimeRegular(this);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }
}

