/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grid;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.Formatter;
import java.util.Optional;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.grid.Grid;
import ucar.nc2.grid.GridAxis;
import ucar.nc2.grid.GridCoordinateSystem;

public interface GridDataset
extends Closeable {
    public String getName();

    public String getLocation();

    public AttributeContainer attributes();

    public FeatureType getFeatureType();

    public ImmutableList<GridCoordinateSystem> getGridCoordinateSystems();

    public ImmutableList<GridAxis> getGridAxes();

    public ImmutableList<Grid> getGrids();

    public Optional<Grid> findGrid(String var1);

    default public void toString(Formatter buf) {
        buf.format("name = %s%n", this.getName());
        buf.format("location = %s%n", this.getLocation());
        buf.format("featureType = %s%n", new Object[]{this.getFeatureType()});
        for (Attribute att : this.attributes()) {
            buf.format("  %s%n", att);
        }
        buf.format("%nGridCoordinateSystem%n", new Object[0]);
        for (GridCoordinateSystem gcs : this.getGridCoordinateSystems()) {
            buf.format("%s%n", gcs);
        }
        buf.format("%nGridAxes%n", new Object[0]);
        for (GridAxis axis : this.getGridAxes()) {
            buf.format("%s%n", axis);
        }
        buf.format("%nGrids%n", new Object[0]);
        for (Grid grid : this.getGrids()) {
            buf.format("%s%n", grid);
        }
    }
}

