/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grid;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Formatter;
import java.util.Optional;
import javax.annotation.Nullable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.grid.GridDataset;
import ucar.nc2.internal.grid.GridNetcdfDataset;

public class GridDatasetFactory {
    @Nullable
    public static GridDataset openGridDataset(String endpoint, Formatter errLog) throws IOException {
        NetcdfDataset ds = NetcdfDatasets.openDataset(endpoint);
        Optional<GridNetcdfDataset> result = GridNetcdfDataset.create(ds, errLog).filter(gds -> !Iterables.isEmpty(gds.getGrids()));
        if (!result.isPresent()) {
            errLog.format("Could not open as GridDataset: %s", endpoint);
            ds.close();
            return null;
        }
        return result.get();
    }
}

