/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grid;

import com.google.common.base.Preconditions;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import ucar.nc2.grid.CoordInterval;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPoints;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionRect;

public class GridSubset {
    public static final String gridName = "gridName";
    public static final String latlonBB = "latlonBB";
    public static final String projBB = "projBB";
    public static final String horizStride = "horizStride";
    public static final String latlonPoint = "latlonPoint";
    public static final String runtime = "runtime";
    public static final String runtimeLatest = "runtimeLatest";
    public static final String runtimeAll = "runtimeAll";
    public static final String timeOffset = "timeOffset";
    public static final String timeOffsetIntv = "timeOffsetIntv";
    public static final String timeOffsetFirst = "timeOffsetFirst";
    public static final String timeOffsetAll = "timeOffsetAll";
    public static final String time = "time";
    public static final String timePoint = "timePoint";
    public static final String timeIntv = "timeIntv";
    public static final String timeRange = "timeRange";
    public static final String timeStride = "timeStride";
    public static final String timePresent = "timePresent";
    public static final String timeAll = "timeAll";
    public static final String vertPoint = "vertPoint";
    public static final String vertIntv = "vertIntv";
    public static final String ensCoord = "ensCoord";
    public static final String timeOffsetDate = "timeOffsetDate";
    public static final String timeOffsetUnit = "timeOffsetUnit";
    private final Map<String, Object> req = new HashMap<String, Object>();

    @Nullable
    private Object get(String key) {
        return this.req.get(key);
    }

    @Nullable
    private Double getDouble(String key) {
        Object val = this.req.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        if (val instanceof String) {
            try {
                return Double.parseDouble((String)val);
            }
            catch (Exception e) {
                throw new RuntimeException(key + " cant parse as Double " + val);
            }
        }
        throw new RuntimeException(key + " not a Double " + val);
    }

    @Nullable
    private CalendarDate getCalendarDate(String key) {
        Object val = this.req.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof CalendarDate) {
            return (CalendarDate)val;
        }
        if (val instanceof String) {
            try {
                return CalendarDate.parseISOformat(null, (String)val);
            }
            catch (Exception e) {
                throw new RuntimeException(key + " cant parse as Iso CalendarDate " + val);
            }
        }
        throw new RuntimeException(key + " not a CalendarDate " + val);
    }

    @Nullable
    private CalendarDateRange getCalendarDateRange(String key) {
        Object val = this.req.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof CalendarDateRange) {
            return (CalendarDateRange)val;
        }
        if (val instanceof String) {
            try {
                return CalendarDateRange.parse((String)val);
            }
            catch (Exception e) {
                throw new RuntimeException(key + " cant parse as CalendarDateRange " + val);
            }
        }
        throw new RuntimeException(key + " not a CalendarDateRange " + val);
    }

    private CoordInterval getCoordInterval(String key) {
        Object val = this.req.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof CoordInterval) {
            return (CoordInterval)val;
        }
        if (val instanceof String) {
            try {
                return CoordInterval.parse((String)val);
            }
            catch (Exception e) {
                throw new RuntimeException(key + " cant parse as CoordInterval " + val);
            }
        }
        throw new RuntimeException(key + " not a CoordInterval " + val);
    }

    @Nullable
    private Integer getInteger(String key) {
        Object val = this.req.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        if (val instanceof String) {
            try {
                return Integer.parseInt((String)val);
            }
            catch (Exception e) {
                throw new RuntimeException(key + " cant parse as Integer " + val);
            }
        }
        throw new RuntimeException(key + " not a Integer " + val);
    }

    private boolean isTrue(String key) {
        Object val = this.req.get(key);
        if (val instanceof String) {
            return ((String)val).equalsIgnoreCase("true");
        }
        return val instanceof Boolean && (Boolean)val != false;
    }

    public GridSubset setHorizStride(int stride) {
        this.req.put(horizStride, stride);
        return this;
    }

    public Set<Map.Entry<String, Object>> getEntries() {
        return this.req.entrySet();
    }

    @Nullable
    public Integer getHorizStride() {
        return this.getInteger(horizStride);
    }

    @Nullable
    public Double getEnsCoord() {
        return this.getDouble(ensCoord);
    }

    public GridSubset setEnsCoord(Object coord) {
        Preconditions.checkArgument((boolean)(coord instanceof Double));
        this.req.put(ensCoord, coord);
        return this;
    }

    @Nullable
    public LatLonRect getLatLonBoundingBox() {
        Object val = this.req.get(latlonBB);
        if (val == null) {
            return null;
        }
        if (val instanceof LatLonRect) {
            return (LatLonRect)val;
        }
        if (val instanceof String) {
            try {
                return LatLonRect.fromSpec((String)val);
            }
            catch (Exception e) {
                throw new RuntimeException(" cant parse as LatLonRect " + val);
            }
        }
        throw new RuntimeException(" not a LatLonRect " + val);
    }

    public GridSubset setLatLonBoundingBox(LatLonRect llbb) {
        this.req.put(latlonBB, llbb);
        return this;
    }

    @Nullable
    public LatLonPoint getLatLonPoint() {
        Object val = this.req.get(latlonPoint);
        if (val == null) {
            return null;
        }
        if (val instanceof LatLonPoint) {
            return (LatLonPoint)val;
        }
        if (val instanceof String) {
            try {
                return LatLonPoints.parseLatLonPoint((String)val);
            }
            catch (Exception e) {
                throw new RuntimeException(" cant parse as LatLonPoint " + val);
            }
        }
        throw new RuntimeException(" not a LatLonPoint " + val);
    }

    public GridSubset setLatLonPoint(LatLonPoint pt) {
        this.req.put(latlonPoint, pt);
        return this;
    }

    @Nullable
    public ProjectionRect getProjectionBoundingBox() {
        Object val = this.req.get(projBB);
        if (val == null) {
            return null;
        }
        if (val instanceof ProjectionRect) {
            return (ProjectionRect)val;
        }
        if (val instanceof String) {
            try {
                return ProjectionRect.fromSpec((String)val);
            }
            catch (Exception e) {
                throw new RuntimeException(" cant parse as ProjectionRect " + val);
            }
        }
        throw new RuntimeException(" not a ProjectionRect " + val);
    }

    public GridSubset setProjectionBoundingBox(ProjectionRect projRect) {
        this.req.put(projBB, projRect);
        return this;
    }

    @Nullable
    public CalendarDate getRunTime() {
        return this.getCalendarDate(runtime);
    }

    public GridSubset setRunTime(CalendarDate date) {
        this.req.put(runtime, date);
        return this;
    }

    public GridSubset setRunTimeCoord(Object coord) {
        Preconditions.checkArgument((boolean)(coord instanceof CalendarDate));
        this.req.put(runtime, coord);
        return this;
    }

    public boolean getRunTimeAll() {
        return this.isTrue(runtimeAll);
    }

    public GridSubset setRunTimeAll() {
        this.req.put(runtimeAll, true);
        return this;
    }

    public boolean getRunTimeLatest() {
        return this.isTrue(runtimeLatest);
    }

    public GridSubset setRunTimeLatest() {
        this.req.put(runtimeLatest, true);
        return this;
    }

    @Nullable
    public CalendarDate getTime() {
        return this.getCalendarDate(time);
    }

    public GridSubset setTime(CalendarDate date) {
        this.req.put(time, date);
        return this;
    }

    @Nullable
    public Double getTimePoint() {
        return this.getDouble(timePoint);
    }

    @Nullable
    public CoordInterval getTimeIntv() {
        return this.getCoordInterval(timeIntv);
    }

    public GridSubset setTimeCoord(Object coord) {
        if (coord instanceof Number) {
            this.req.put(timePoint, coord);
        } else if (coord instanceof CoordInterval) {
            this.req.put(timeIntv, coord);
        } else {
            throw new RuntimeException("setTimeCoord must be Number or CoordInterval " + coord);
        }
        return this;
    }

    public boolean getTimePresent() {
        return this.isTrue(timePresent);
    }

    public GridSubset setTimePresent() {
        this.req.put(timePresent, true);
        return this;
    }

    @Nullable
    public CalendarDateRange getTimeRange() {
        return this.getCalendarDateRange(timeRange);
    }

    public GridSubset setTimeRange(CalendarDateRange dateRange) {
        this.req.put(timeRange, dateRange);
        return this;
    }

    @Nullable
    public Integer getTimeStride() {
        return this.getInteger(timeStride);
    }

    public GridSubset setTimeStride(int stride) {
        this.req.put(timeStride, stride);
        return this;
    }

    @Nullable
    public Double getTimeOffset() {
        return this.getDouble(timeOffset);
    }

    public GridSubset setTimeOffsetCoord(Object coord) {
        if (coord instanceof Number) {
            this.req.put(timeOffset, coord);
        } else if (coord instanceof CoordInterval) {
            this.req.put(timeOffsetIntv, coord);
        } else {
            throw new RuntimeException("setTimeOffsetCoord must be Number or CoordInterval " + coord);
        }
        return this;
    }

    @Nullable
    public CoordInterval getTimeOffsetIntv() {
        return this.getCoordInterval(timeOffsetIntv);
    }

    public boolean getTimeOffsetFirst() {
        return this.isTrue(timeOffsetFirst);
    }

    public GridSubset setTimeOffsetFirst() {
        this.req.put(timeOffsetFirst, true);
        return this;
    }

    @Nullable
    public Double getVertPoint() {
        return this.getDouble(vertPoint);
    }

    @Nullable
    public CoordInterval getVertIntv() {
        return this.getCoordInterval(vertIntv);
    }

    public GridSubset setVertCoord(Object coord) {
        if (coord instanceof Number) {
            this.req.put(vertPoint, coord);
        } else if (coord instanceof CoordInterval) {
            this.req.put(vertIntv, coord);
        } else {
            throw new RuntimeException("setVertCoord must be Number or CoordInterval " + coord);
        }
        return this;
    }

    public String toString() {
        Formatter f = new Formatter();
        for (Map.Entry<String, Object> entry : this.req.entrySet()) {
            f.format("%s == %s%n", entry.getKey(), entry.getValue());
        }
        return f.toString();
    }

    public String getGridName() {
        return (String)this.get(gridName);
    }

    public GridSubset setGridName(String name) {
        this.req.put(gridName, name);
        return this;
    }

    public GridSubset() {
    }

    public GridSubset(Map<String, String> stringMap) {
        for (Map.Entry<String, String> entry : stringMap.entrySet()) {
            this.req.put(entry.getKey(), entry.getValue());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridSubset that = (GridSubset)o;
        return this.req.equals(that.req);
    }

    public int hashCode() {
        return Objects.hash(this.req);
    }
}

