/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.array.ArrayType;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.ft2.coverage.CoverageTransform;
import ucar.nc2.internal.dataset.transform.horiz.AlbersEqualArea;
import ucar.nc2.internal.dataset.transform.horiz.AzimuthalEquidistant;
import ucar.nc2.internal.dataset.transform.horiz.FlatEarth;
import ucar.nc2.internal.dataset.transform.horiz.Geostationary;
import ucar.nc2.internal.dataset.transform.horiz.HorizTransformBuilderIF;
import ucar.nc2.internal.dataset.transform.horiz.LambertAzimuthal;
import ucar.nc2.internal.dataset.transform.horiz.LambertConformalConic;
import ucar.nc2.internal.dataset.transform.horiz.LambertCylindricalEqualArea;
import ucar.nc2.internal.dataset.transform.horiz.LatLon;
import ucar.nc2.internal.dataset.transform.horiz.MSGnavigation;
import ucar.nc2.internal.dataset.transform.horiz.Mercator;
import ucar.nc2.internal.dataset.transform.horiz.Orthographic;
import ucar.nc2.internal.dataset.transform.horiz.PolarStereographic;
import ucar.nc2.internal.dataset.transform.horiz.PolyconicProjection;
import ucar.nc2.internal.dataset.transform.horiz.RotatedLatLon;
import ucar.nc2.internal.dataset.transform.horiz.RotatedPole;
import ucar.nc2.internal.dataset.transform.horiz.Sinusoidal;
import ucar.nc2.internal.dataset.transform.horiz.Stereographic;
import ucar.nc2.internal.dataset.transform.horiz.TransformBuilders;
import ucar.nc2.internal.dataset.transform.horiz.TransverseMercator;
import ucar.nc2.internal.dataset.transform.horiz.UTM;
import ucar.nc2.internal.dataset.transform.horiz.VerticalPerspective;
import ucar.nc2.internal.dataset.transform.vertical.CFHybridHeight;
import ucar.nc2.internal.dataset.transform.vertical.CFHybridSigmaPressure;
import ucar.nc2.internal.dataset.transform.vertical.CFOceanS;
import ucar.nc2.internal.dataset.transform.vertical.CFOceanSigma;
import ucar.nc2.internal.dataset.transform.vertical.CFSigma;
import ucar.nc2.internal.dataset.transform.vertical.CsmSigma;
import ucar.nc2.internal.dataset.transform.vertical.VExplicitField;
import ucar.nc2.internal.dataset.transform.vertical.VOceanSG1;
import ucar.nc2.internal.dataset.transform.vertical.VOceanSG2;
import ucar.nc2.internal.dataset.transform.vertical.VerticalCTBuilder;
import ucar.unidata.geoloc.Projection;

public class CoordTransformFactory {
    private static final Logger log = LoggerFactory.getLogger(CoordTransformFactory.class);
    private static final List<Transform> transformList = new ArrayList<Transform>();
    private static boolean userMode = false;
    private static final boolean loadWarnings = false;

    public static void registerTransform(String transformName, Class<?> c) {
        if (!VerticalCTBuilder.class.isAssignableFrom(c) && !HorizTransformBuilderIF.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("Class " + c.getName() + " must implement VertTransformBuilderIF or HorizTransformBuilderIF");
        }
        try {
            c.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("CoordTransBuilderIF Class " + c.getName() + " cannot instantiate, probably need default Constructor");
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("CoordTransBuilderIF Class " + c.getName() + " is not accessible");
        }
        if (userMode) {
            transformList.add(0, new Transform(transformName, c));
        } else {
            transformList.add(new Transform(transformName, c));
        }
    }

    public static void registerTransform(String transformName, String className) throws ClassNotFoundException {
        Class<?> c = Class.forName(className);
        CoordTransformFactory.registerTransform(transformName, c);
    }

    public static void registerTransformMaybe(String transformName, String className) {
        Class<?> c;
        try {
            c = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return;
        }
        CoordTransformFactory.registerTransform(transformName, c);
    }

    @Nullable
    public static CoordinateTransform.Builder<?> makeCoordinateTransform(NetcdfDataset ds, AttributeContainer ctv, Formatter parseInfo, Formatter errInfo) {
        CoordinateTransform.Builder ct;
        Object builderObject;
        String transform_name = ctv.findAttributeString("transform_name", null);
        if (null == transform_name) {
            transform_name = ctv.findAttributeString("Projection_Name", null);
        }
        if (null == transform_name) {
            transform_name = ctv.findAttributeString("grid_mapping_name", null);
        }
        if (null == transform_name) {
            transform_name = ctv.findAttributeString("standard_name", null);
        }
        if (null == transform_name) {
            transform_name = ctv.findAttributeString("units", null);
        }
        if (null == transform_name) {
            parseInfo.format("**Failed to find Coordinate Transform name from Variable= %s%n", ctv);
            return null;
        }
        transform_name = transform_name.trim();
        Class<?> builderClass = null;
        for (Transform transform : transformList) {
            if (!transform.transName.equals(transform_name)) continue;
            builderClass = transform.transClass;
            break;
        }
        if (null == builderClass) {
            parseInfo.format("**Failed to find CoordTransBuilder name= %s from Variable= %s%n", transform_name, ctv);
            return null;
        }
        try {
            builderObject = builderClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("Cant create new instance " + builderClass.getName(), (Throwable)e);
            return null;
        }
        if (builderObject instanceof VerticalCTBuilder) {
            VerticalCTBuilder vertBuilder = (VerticalCTBuilder)builderObject;
            vertBuilder.setErrorBuffer(errInfo);
            ct = vertBuilder.makeVerticalCT(ds, ctv);
            if (ct != null) {
                ct.setTransformType(TransformType.Vertical);
            }
        } else if (builderObject instanceof HorizTransformBuilderIF) {
            HorizTransformBuilderIF horizBuilder = (HorizTransformBuilderIF)builderObject;
            horizBuilder.setErrorBuffer(errInfo);
            String units = TransformBuilders.getGeoCoordinateUnits(ds, ctv);
            ct = horizBuilder.makeCoordinateTransform(ctv, units);
            if (ct != null) {
                ct.setTransformType(TransformType.Projection);
            }
        } else {
            log.error("Illegal class " + builderClass.getName());
            return null;
        }
        if (ct != null) {
            parseInfo.format(" Made Coordinate transform %s from variable %s: %s%n", transform_name, ctv.getName(), builderObject.getClass().getName());
        } else {
            parseInfo.format(" Failed to make Coordinate transform %s from variable %s: %s%n", transform_name, ctv.getName(), builderObject.getClass().getName());
        }
        return ct;
    }

    public static VariableDS makeDummyTransformVariable(NetcdfDataset ds, CoordinateTransform ct) {
        VariableDS.Builder vb = (VariableDS.Builder)((VariableDS.Builder)VariableDS.builder().setName(ct.getName())).setArrayType(ArrayType.CHAR);
        vb.addAttributes(ct.getCtvAttributes());
        vb.addAttribute(new Attribute("_CoordinateTransformType", ct.getTransformType().toString()));
        Array data = Array.factory(DataType.CHAR, new int[0], (Object)new char[]{' '});
        vb.setSourceData(data);
        return vb.build(ds.getRootGroup());
    }

    @Nullable
    public static Class<?> getBuilderClassFor(String transformName) {
        for (Transform transform : transformList) {
            if (!transform.transName.equals(transformName)) continue;
            return transform.transClass;
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static Projection makeProjection(CoverageTransform gct, Formatter errInfo) {
        HorizTransformBuilderIF builder;
        String transformName = gct.attributes().findAttributeString("grid_mapping_name", null);
        if (null == transformName) {
            errInfo.format("**Failed to find Coordinate Transform name from GridCoordTransform= %s%n", gct);
            return null;
        }
        Class<?> builderClass = CoordTransformFactory.getBuilderClassFor(transformName = transformName.trim());
        if (null == builderClass) {
            errInfo.format("**Failed to find CoordTransBuilder name= %s from GridCoordTransform= %s%n", transformName, gct);
            return null;
        }
        try {
            builder = (HorizTransformBuilderIF)builderClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("Cant create new instance " + builderClass.getName(), (Throwable)e);
            return null;
        }
        String units = gct.attributes().findAttributeString("units", null);
        builder.setErrorBuffer(errInfo);
        ProjectionCT.Builder<?> ct = builder.makeCoordinateTransform(gct.attributes(), units);
        if (ct == null) {
            return null;
        }
        return ct.build().getProjection();
    }

    static {
        CoordTransformFactory.registerTransform("albers_conical_equal_area", AlbersEqualArea.class);
        CoordTransformFactory.registerTransform("azimuthal_equidistant", AzimuthalEquidistant.class);
        CoordTransformFactory.registerTransform("flat_earth", FlatEarth.class);
        CoordTransformFactory.registerTransform("geostationary", Geostationary.class);
        CoordTransformFactory.registerTransform("lambert_azimuthal_equal_area", LambertAzimuthal.class);
        CoordTransformFactory.registerTransform("lambert_conformal_conic", LambertConformalConic.class);
        CoordTransformFactory.registerTransform("lambert_cylindrical_equal_area", LambertCylindricalEqualArea.class);
        CoordTransformFactory.registerTransform("latitude_longitude", LatLon.class);
        CoordTransformFactory.registerTransformMaybe("mcidas_area", "ucar.nc2.iosp.mcidas.McIDASAreaTransformBuilder");
        CoordTransformFactory.registerTransform("mercator", Mercator.class);
        CoordTransformFactory.registerTransform("MSGnavigation", MSGnavigation.class);
        CoordTransformFactory.registerTransform("orthographic", Orthographic.class);
        CoordTransformFactory.registerTransform("polar_stereographic", PolarStereographic.class);
        CoordTransformFactory.registerTransform("polyconic", PolyconicProjection.class);
        CoordTransformFactory.registerTransform("rotated_latitude_longitude", RotatedPole.class);
        CoordTransformFactory.registerTransform("rotated_latlon_grib", RotatedLatLon.class);
        CoordTransformFactory.registerTransform("sinusoidal", Sinusoidal.class);
        CoordTransformFactory.registerTransform("stereographic", Stereographic.class);
        CoordTransformFactory.registerTransform("transverse_mercator", TransverseMercator.class);
        CoordTransformFactory.registerTransform("UTM", UTM.class);
        CoordTransformFactory.registerTransform("vertical_perspective", VerticalPerspective.class);
        CoordTransformFactory.registerTransform("atmosphere_hybrid_height_coordinate", CFHybridHeight.class);
        CoordTransformFactory.registerTransform("atmosphere_hybrid_sigma_pressure_coordinate", CFHybridSigmaPressure.class);
        CoordTransformFactory.registerTransform("atmosphere_sigma_coordinate", CFSigma.class);
        CoordTransformFactory.registerTransform("ocean_s_coordinate", CFOceanS.class);
        CoordTransformFactory.registerTransform("ocean_sigma_coordinate", CFOceanSigma.class);
        CoordTransformFactory.registerTransform("explicit_field", VExplicitField.class);
        CoordTransformFactory.registerTransform("existing3DField", VExplicitField.class);
        CoordTransformFactory.registerTransform("ocean_s_coordinate_g1", VOceanSG1.class);
        CoordTransformFactory.registerTransform("ocean_s_coordinate_g2", VOceanSG2.class);
        CoordTransformFactory.registerTransform("sigma_level", CsmSigma.class);
        CoordTransformFactory.registerTransform("hybrid_sigma_pressure", CsmSigma.HybridSigmaPressureBuilder.class);
        userMode = true;
    }

    private static class Transform {
        String transName;
        Class<?> transClass;

        Transform(String transName, Class<?> transClass) {
            this.transName = transName;
            this.transClass = transClass;
        }
    }
}

