/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.internal.dataset.TransformBuilder;

@Immutable
public class CoordinatesHelper {
    private static final Logger log = LoggerFactory.getLogger(CoordinatesHelper.class);
    private final ImmutableList<CoordinateAxis> coordAxes;
    private final ImmutableList<CoordinateSystem> coordSystems;
    private final ImmutableList<CoordinateTransform> coordTransforms;

    public ImmutableList<CoordinateAxis> getCoordAxes() {
        return this.coordAxes;
    }

    public ImmutableList<CoordinateSystem> getCoordSystems() {
        return this.coordSystems;
    }

    public Optional<CoordinateSystem> findCoordSystem(String name) {
        return this.coordSystems.stream().filter(cs -> cs.getName().equals(name)).findFirst();
    }

    public ImmutableList<CoordinateTransform> getCoordTransforms() {
        return this.coordTransforms;
    }

    public ImmutableList<CoordinateSystem> makeCoordinateSystemsFor(Variable v) {
        ArrayList<CoordinateSystem> result = new ArrayList<CoordinateSystem>();
        for (CoordinateSystem csys : this.coordSystems) {
            if (!csys.isCoordinateSystemFor(v) || !csys.isComplete(v)) continue;
            result.add(csys);
        }
        result.sort((cs1, cs2) -> cs2.getCoordinateAxes().size() - cs1.getCoordinateAxes().size());
        return ImmutableList.copyOf(result);
    }

    public static ImmutableList<CoordinateAxis> makeAxes(NetcdfDataset ncd) {
        ArrayList<CoordinateAxis> axes = new ArrayList<CoordinateAxis>();
        CoordinatesHelper.addAxes(ncd.getRootGroup(), axes);
        return ImmutableList.copyOf(axes);
    }

    private static void addAxes(Group group, List<CoordinateAxis> axes) {
        for (Variable v : group.getVariables()) {
            if (v instanceof CoordinateAxis) {
                axes.add((CoordinateAxis)v);
            }
            if (!(v instanceof Structure)) continue;
            Structure s = (Structure)v;
            for (Variable nested : s.getVariables()) {
                if (!(nested instanceof CoordinateAxis)) continue;
                axes.add((CoordinateAxis)nested);
            }
        }
        for (Group nestedGroup : group.getGroups()) {
            CoordinatesHelper.addAxes(nestedGroup, axes);
        }
    }

    private CoordinatesHelper(Builder builder, NetcdfDataset ncd, ImmutableList<CoordinateAxis> axes) {
        this.coordAxes = axes;
        ImmutableList.Builder ctBuilders = ImmutableList.builder();
        ctBuilders.addAll((Iterable)builder.coordTransforms.stream().map(ct -> ct.build()).filter(Objects::nonNull).collect(Collectors.toList()));
        ctBuilders.addAll((Iterable)builder.transformBuilders.stream().map(ct -> ct.build(ncd)).filter(Objects::nonNull).collect(Collectors.toList()));
        this.coordTransforms = ctBuilders.build();
        this.coordSystems = (ImmutableList)builder.coordSys.stream().map(s -> s.build(ncd, (List<CoordinateAxis>)this.coordAxes, (List<CoordinateTransform>)this.coordTransforms)).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    }

    public static Builder builder() {
        return new Builder();
    }

    private static class AxisComparator
    implements Comparator<CoordinateAxis.Builder<?>> {
        private AxisComparator() {
        }

        @Override
        public int compare(CoordinateAxis.Builder c1, CoordinateAxis.Builder c2) {
            AxisType t1 = c1.axisType;
            AxisType t2 = c2.axisType;
            if (t1 == null && t2 == null) {
                return c1.getFullName().compareTo(c2.getFullName());
            }
            if (t1 == null) {
                return -1;
            }
            if (t2 == null) {
                return 1;
            }
            return t1.axisOrder() - t2.axisOrder();
        }
    }

    public static class Builder {
        public List<CoordinateAxis.Builder<?>> coordAxes = new ArrayList();
        public List<CoordinateSystem.Builder<?>> coordSys = new ArrayList();
        public List<CoordinateTransform.Builder<?>> coordTransforms = new ArrayList();
        public List<TransformBuilder> transformBuilders = new ArrayList<TransformBuilder>();
        private boolean built;

        public Builder addCoordinateAxis(CoordinateAxis.Builder<?> axis) {
            if (axis == null) {
                return this;
            }
            this.coordAxes.add(axis);
            return this;
        }

        public Builder addCoordinateAxes(Collection<CoordinateAxis.Builder<?>> axes) {
            Preconditions.checkNotNull(axes);
            axes.forEach(this::addCoordinateAxis);
            return this;
        }

        private Optional<CoordinateAxis.Builder<?>> findAxisByVerticalSearch(Variable.Builder<?> vb, String shortName) {
            Optional<Variable.Builder<?>> axis = vb.getParentGroupBuilder().findVariableOrInParent(shortName);
            if (axis.isPresent() && axis.get() instanceof CoordinateAxis.Builder) {
                return Optional.of((CoordinateAxis.Builder)axis.get());
            }
            return Optional.empty();
        }

        private Optional<CoordinateAxis.Builder<?>> findAxisByFullName(String fullName) {
            return this.coordAxes.stream().filter(axis -> axis.getFullName().equals(fullName)).findFirst();
        }

        public Optional<CoordinateAxis.Builder<?>> findAxisByType(CoordinateSystem.Builder<?> csys, AxisType type) {
            for (CoordinateAxis.Builder<?> axis : this.getAxesForSystem(csys)) {
                if (axis.axisType != type) continue;
                return Optional.of(axis);
            }
            return Optional.empty();
        }

        public boolean replaceCoordinateAxis(CoordinateAxis.Builder<?> axis) {
            Optional<CoordinateAxis.Builder<?>> want = this.findAxisByFullName(axis.getFullName());
            want.ifPresent(v -> this.coordAxes.remove(v));
            this.addCoordinateAxis(axis);
            return want.isPresent();
        }

        public Builder addCoordinateSystem(CoordinateSystem.Builder<?> cs) {
            Preconditions.checkNotNull(cs);
            this.coordSys.add(cs);
            return this;
        }

        Optional<CoordinateSystem.Builder<?>> findCoordinateSystem(String coordAxesNames) {
            Preconditions.checkNotNull((Object)coordAxesNames);
            return this.coordSys.stream().filter(cs -> cs.coordAxesNames.equals(coordAxesNames)).findFirst();
        }

        public Builder addCoordinateSystems(Collection<CoordinateSystem.Builder<?>> systems) {
            Preconditions.checkNotNull(systems);
            this.coordSys.addAll(systems);
            return this;
        }

        public Builder addCoordinateTransform(CoordinateTransform.Builder<?> ct) {
            Preconditions.checkNotNull(ct);
            if (this.coordTransforms.stream().noneMatch(old -> old.name.equals(ct.name))) {
                this.coordTransforms.add(ct);
            }
            return this;
        }

        public Builder addTransformBuilder(TransformBuilder ct) {
            Preconditions.checkNotNull((Object)ct);
            if (this.transformBuilders.stream().noneMatch(old -> old.name.equals(ct.name))) {
                this.transformBuilders.add(ct);
            }
            return this;
        }

        public Builder addCoordinateTransforms(Collection<CoordinateTransform.Builder<?>> transforms) {
            Preconditions.checkNotNull(transforms);
            transforms.forEach(this::addCoordinateTransform);
            return this;
        }

        private List<CoordinateAxis.Builder<?>> getAxesForSystem(CoordinateSystem.Builder<?> cs) {
            Preconditions.checkNotNull(cs);
            ArrayList axes = new ArrayList();
            StringTokenizer stoker = new StringTokenizer(cs.coordAxesNames);
            while (stoker.hasMoreTokens()) {
                String vname = stoker.nextToken();
                Optional<CoordinateAxis.Builder<?>> vbOpt = this.findAxisByFullName(vname);
                if (vbOpt.isPresent()) {
                    axes.add(vbOpt.get());
                    continue;
                }
                throw new IllegalArgumentException("Cant find axis " + vname);
            }
            return axes;
        }

        String makeCanonicalName(Variable.Builder<?> vb, String axesNames) {
            Preconditions.checkNotNull((Object)axesNames);
            ArrayList axes = new ArrayList();
            StringTokenizer stoker = new StringTokenizer(axesNames);
            while (stoker.hasMoreTokens()) {
                String vname = stoker.nextToken();
                Optional<CoordinateAxis.Builder<?>> vbOpt = this.findAxisByFullName(vname);
                if (!vbOpt.isPresent()) {
                    vbOpt = this.findAxisByVerticalSearch(vb, vname);
                }
                if (vbOpt.isPresent()) {
                    axes.add(vbOpt.get());
                    continue;
                }
                log.warn("No axis named {}", (Object)vname);
            }
            return this.makeCanonicalName(axes);
        }

        String makeCanonicalName(List<CoordinateAxis.Builder<?>> axes) {
            Preconditions.checkNotNull(axes);
            return axes.stream().sorted(new AxisComparator()).map(a -> a.getFullName()).collect(Collectors.joining(" "));
        }

        public boolean isComplete(CoordinateSystem.Builder<?> cs, Variable.Builder<?> vb) {
            Preconditions.checkNotNull(cs);
            Preconditions.checkNotNull(vb);
            HashSet<Dimension> csDomain = new HashSet<Dimension>();
            this.getAxesForSystem(cs).forEach(axis -> csDomain.addAll((Collection<Dimension>)axis.getDimensions()));
            return CoordinateSystem.isComplete(vb.getDimensions(), csDomain);
        }

        public boolean containsAxes(CoordinateSystem.Builder<?> cs, List<CoordinateAxis.Builder<?>> dataAxes) {
            Preconditions.checkNotNull(cs);
            Preconditions.checkNotNull(dataAxes);
            List<CoordinateAxis.Builder<CoordinateAxis.Builder<?>>> csAxes = this.getAxesForSystem(cs);
            return csAxes.containsAll(dataAxes);
        }

        public boolean containsAxisTypes(CoordinateSystem.Builder<?> cs, List<AxisType> axisTypes) {
            Preconditions.checkNotNull(cs);
            Preconditions.checkNotNull(axisTypes);
            List<CoordinateAxis.Builder<?>> csAxes = this.getAxesForSystem(cs);
            for (AxisType axisType : axisTypes) {
                if (this.containsAxisTypes(csAxes, axisType)) continue;
                return false;
            }
            return true;
        }

        private boolean containsAxisTypes(List<CoordinateAxis.Builder<?>> axes, AxisType want) {
            for (CoordinateAxis.Builder<?> axis : axes) {
                if (axis.axisType != want) continue;
                return true;
            }
            return false;
        }

        public CoordinatesHelper build(NetcdfDataset ncd, ImmutableList<CoordinateAxis> coordAxes) {
            Preconditions.checkNotNull((Object)ncd);
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            return new CoordinatesHelper(this, ncd, coordAxes);
        }
    }
}

