/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset;

import java.util.Set;
import ucar.array.Array;
import ucar.array.ArrayType;
import ucar.array.ArraysConvert;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.dataset.EnhanceScaleMissingUnsignedImpl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;

public class DataEnhancer {
    private final VariableDS variableDS;
    private final ArrayType dataType;
    private final ArrayType orgDataType;
    private final EnhanceScaleMissingUnsignedImpl scaleMissingUnsignedProxy;

    public DataEnhancer(VariableDS variableDS, EnhanceScaleMissingUnsignedImpl scaleMissingUnsignedProxy) {
        this.variableDS = variableDS;
        this.dataType = variableDS.getArrayType();
        this.orgDataType = variableDS.getOriginalArrayType();
        this.scaleMissingUnsignedProxy = scaleMissingUnsignedProxy;
    }

    public ucar.ma2.Array convert(ucar.ma2.Array data, Set<NetcdfDataset.Enhance> enhancements) {
        if (enhancements.contains((Object)NetcdfDataset.Enhance.ConvertEnums) && (this.dataType.isEnum() || this.orgDataType != null && this.orgDataType.isEnum())) {
            return this.convertEnums(data);
        }
        if (this.variableDS.isVariableLength()) {
            return data;
        }
        return this.scaleMissingUnsignedProxy.convert(data, enhancements.contains((Object)NetcdfDataset.Enhance.ConvertUnsigned), enhancements.contains((Object)NetcdfDataset.Enhance.ApplyScaleOffset), enhancements.contains((Object)NetcdfDataset.Enhance.ConvertMissing));
    }

    private ucar.ma2.Array convertEnums(ucar.ma2.Array values) {
        if (!values.getDataType().isIntegral()) {
            return values;
        }
        ucar.ma2.Array result = ucar.ma2.Array.factory(DataType.STRING, values.getShape());
        IndexIterator ii = result.getIndexIterator();
        values.resetLocalIterator();
        while (values.hasNext()) {
            String sval = this.variableDS.lookupEnumString(values.nextInt());
            ii.setObjectNext(sval);
        }
        return result;
    }

    public Array<?> convertArray(Array<?> data, Set<NetcdfDataset.Enhance> enhancements) {
        ucar.ma2.Array ma2 = ArraysConvert.convertFromArray(data);
        return ArraysConvert.convertToArray(this.convert(ma2, enhancements));
    }
}

