/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import ucar.nc2.Dimension;
import ucar.nc2.Dimensions;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.units.SimpleUnit;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.projection.RotatedPole;

public class DatasetClassifier {
    private final Formatter infolog;
    private final ArrayList<CoordSysClassifier> coordSysUsed = new ArrayList();
    private final HashMap<String, CoordinateAxis> indAxes = new HashMap();
    private final HashMap<String, CoordinateAxis> depAxes = new HashMap();
    private FeatureType featureType;

    public DatasetClassifier(NetcdfDataset ds, Formatter infolog) {
        Preconditions.checkNotNull((Object)ds);
        Preconditions.checkNotNull((Object)infolog);
        this.infolog = infolog;
        infolog.format("DatasetClassifier for '%s'%n", ds.getLocation());
        ArrayList<CoordinateSystem> css = new ArrayList<CoordinateSystem>((Collection<CoordinateSystem>)ds.getCoordinateSystems());
        css.sort((o1, o2) -> o2.getCoordinateAxes().size() - o1.getCoordinateAxes().size());
        for (CoordinateSystem cs : css) {
            this.classifyCoordSys(cs);
        }
        infolog.format("Dataset featureType = %s%n", new Object[]{this.featureType});
    }

    public List<CoordinateAxis> getIndependentAxes() {
        ArrayList<CoordinateAxis> other = new ArrayList<CoordinateAxis>(this.indAxes.values());
        other.sort(new CoordinateAxis.AxisComparator());
        return other;
    }

    public List<CoordinateAxis> getDependentAxes() {
        ArrayList<CoordinateAxis> other = new ArrayList<CoordinateAxis>(this.depAxes.values());
        other.sort(new CoordinateAxis.AxisComparator());
        return other;
    }

    public List<CoordSysClassifier> getCoordinateSystemsUsed() {
        return this.coordSysUsed;
    }

    public FeatureType getFeatureType() {
        return this.featureType;
    }

    private CoordSysClassifier classifyCoordSys(CoordinateSystem cs) {
        CoordSysClassifier csc = new CoordSysClassifier(cs);
        if (this.featureType == null) {
            this.featureType = csc.featureType;
        }
        if (this.featureType == csc.featureType) {
            this.coordSysUsed.add(csc);
            csc.indAxes.forEach(a -> this.indAxes.put(a.getFullName(), (CoordinateAxis)a));
            csc.depAxes.forEach(a -> this.depAxes.put(a.getFullName(), (CoordinateAxis)a));
        }
        return csc;
    }

    public class CoordSysClassifier {
        CoordinateSystem cs;
        FeatureType featureType;
        boolean isLatLon;
        CoordinateAxis xaxis;
        CoordinateAxis yaxis;
        CoordinateAxis timeAxis;
        CoordinateAxis timeOffsetAxis;
        CoordinateAxis vertAxis;
        CoordinateAxis ensAxis;
        CoordinateAxis rtAxis;
        List<CoordinateAxis> indAxes = new ArrayList<CoordinateAxis>();
        List<CoordinateAxis> depAxes = new ArrayList<CoordinateAxis>();
        List<CoordinateTransform> coordTransforms;
        Projection orgProj;

        private CoordSysClassifier(CoordinateSystem cs) {
            CoordinateAxis eAxis;
            boolean hasRuntimeAndOffset;
            CoordinateAxis rt;
            CoordinateAxis toAxis;
            this.cs = cs;
            if (cs.getRankDomain() < 2) {
                DatasetClassifier.this.infolog.format(" '%s': domain rank < 2%n", cs.getName());
                return;
            }
            if (!cs.isLatLon()) {
                if (cs.findAxis(AxisType.GeoX) == null || cs.findAxis(AxisType.GeoY) == null) {
                    DatasetClassifier.this.infolog.format(" %s: NO Lat,Lon or X,Y axis%n", cs.getName());
                    return;
                }
                if (null == cs.getProjection()) {
                    DatasetClassifier.this.infolog.format(" %s: NO projection found%n", cs.getName());
                    return;
                }
            }
            if (cs.isGeoXY()) {
                this.xaxis = cs.findAxis(AxisType.GeoX);
                this.indAxes.add(this.xaxis);
                this.yaxis = cs.findAxis(AxisType.GeoY);
                this.indAxes.add(this.yaxis);
                Projection p = cs.getProjection();
                if (!(p instanceof RotatedPole)) {
                    if (!SimpleUnit.kmUnit.isCompatible(this.xaxis.getUnitsString())) {
                        DatasetClassifier.this.infolog.format(" %s: X axis units are not convertible to km%n", cs.getName());
                    }
                    if (!SimpleUnit.kmUnit.isCompatible(this.yaxis.getUnitsString())) {
                        DatasetClassifier.this.infolog.format(" %s: Y axis units are not convertible to km%n", cs.getName());
                    }
                }
            } else {
                this.xaxis = cs.findAxis(AxisType.Lon);
                this.indAxes.add(this.xaxis);
                this.yaxis = cs.findAxis(AxisType.Lat);
                this.indAxes.add(this.yaxis);
                this.isLatLon = true;
            }
            if (this.xaxis.getRank() > 2 || this.yaxis.getRank() > 2) {
                DatasetClassifier.this.infolog.format(" %s: X and Y axis rank must be <= 2%n", cs.getName());
                return;
            }
            if (this.xaxis.getSize() < 2L || this.yaxis.getSize() < 2L) {
                DatasetClassifier.this.infolog.format(" %s: X and Y axis size must be >= 2%n", cs.getName());
                return;
            }
            int xyDomainSize = Dimensions.makeDomain((Iterable<? extends Variable>)ImmutableList.of((Object)this.xaxis, (Object)this.yaxis), true).size();
            if (xyDomainSize < 2) {
                DatasetClassifier.this.infolog.format(" %s: X and Y axis must have 2 or more dimensions%n", cs.getName());
                return;
            }
            CoordinateAxis zAxis = cs.findAxis(AxisType.Height);
            if (zAxis == null || zAxis.getRank() > 1) {
                zAxis = cs.findAxis(AxisType.Pressure);
            }
            if (zAxis == null || zAxis.getRank() > 1) {
                zAxis = cs.findAxis(AxisType.GeoZ);
            }
            if (zAxis != null && zAxis.getRank() < 2) {
                this.vertAxis = zAxis;
                this.indAxes.add(this.vertAxis);
            }
            if ((toAxis = cs.findAxis(AxisType.TimeOffset)) != null) {
                if (toAxis.getRank() < 2) {
                    this.timeOffsetAxis = toAxis;
                    this.indAxes.add(this.timeOffsetAxis);
                } else {
                    this.timeOffsetAxis = toAxis;
                    this.depAxes.add(this.timeOffsetAxis);
                }
            }
            if ((rt = cs.findAxis(AxisType.RunTime)) != null) {
                if (rt.getRank() == 0) {
                    this.rtAxis = rt;
                    this.depAxes.add(this.rtAxis);
                } else if (rt.getRank() == 1) {
                    this.rtAxis = rt;
                    this.indAxes.add(this.rtAxis);
                } else {
                    DatasetClassifier.this.infolog.format(" %s: RunTime axis must be 1D or scalar%n", cs.getName());
                }
            }
            boolean bl = hasRuntimeAndOffset = this.timeOffsetAxis != null && this.rtAxis != null;
            if (!hasRuntimeAndOffset) {
                CoordinateAxis t = cs.findAxis(AxisType.Time);
                if (t != null && t.getRank() > 1 && this.rtAxis != null && this.rtAxis.getRank() == 1 && !this.rtAxis.getDimension(0).equals(t.getDimension(0))) {
                    DatasetClassifier.this.infolog.format(" %s: 2D Time axis first dimension must be runtime%n", cs.getName());
                    return;
                }
                if (t != null) {
                    boolean sharedDimension;
                    boolean bl2 = sharedDimension = rt != null && t.getDimension(0).equals(rt.getDimension(0));
                    if (t.getRank() == 1 && sharedDimension) {
                        this.depAxes.add(t);
                    } else {
                        this.timeAxis = t;
                        this.indAxes.add(this.timeAxis);
                    }
                }
            }
            if ((eAxis = cs.findAxis(AxisType.Ensemble)) != null && eAxis.getRank() == 1) {
                this.ensAxis = eAxis;
                this.indAxes.add(this.ensAxis);
            }
            this.featureType = this.classify();
            this.coordTransforms = new ArrayList<CoordinateTransform>((Collection<CoordinateTransform>)cs.getCoordinateTransforms());
            this.orgProj = cs.getProjection();
            this.indAxes.sort(new CoordinateAxis.AxisComparator());
        }

        @Nullable
        private FeatureType classify() {
            boolean is2Dhoriz;
            FeatureType result = null;
            boolean is2Dtime = this.rtAxis != null && this.timeOffsetAxis == null && this.timeAxis != null && this.timeAxis.getRank() == 2;
            boolean bl = is2Dhoriz = this.isLatLon && this.xaxis.getRank() == 2 && this.yaxis.getRank() == 2;
            if (is2Dtime) {
                result = FeatureType.FMRC;
            } else if (is2Dhoriz) {
                ImmutableSet<Dimension> xyDomain = Dimensions.makeDomain(Lists.newArrayList((Object[])new CoordinateAxis[]{this.xaxis, this.yaxis}), true);
                result = this.timeAxis != null && Dimensions.isSubset(Dimensions.makeDimensionsAll(this.timeAxis), xyDomain) ? FeatureType.SWATH : FeatureType.CURVILINEAR;
            } else {
                List axes = this.indAxes.stream().filter(a -> a.getRank() == 1).collect(Collectors.toList());
                ImmutableSet<Dimension> domain = Dimensions.makeDomain(axes, false);
                if (domain.size() == axes.size()) {
                    result = FeatureType.GRID;
                }
            }
            DatasetClassifier.this.infolog.format(" %s: classified as %s%n", new Object[]{this.cs.getName(), result});
            return result;
        }

        public String getName() {
            return this.cs.getName();
        }

        public FeatureType getFeatureType() {
            return this.featureType;
        }

        public boolean isLatLon() {
            return this.isLatLon;
        }

        public List<CoordinateTransform> getCoordTransforms() {
            return this.coordTransforms;
        }

        public Projection getProjection() {
            return this.orgProj;
        }

        public List<CoordinateAxis> getAxesUsed() {
            ArrayList<CoordinateAxis> result = new ArrayList<CoordinateAxis>(this.indAxes);
            result.addAll(this.depAxes);
            return result;
        }

        public String toString() {
            Formatter f2 = new Formatter();
            f2.format("%s ", this.cs.getName());
            f2.format("%s", this.featureType == null ? "" : this.featureType.toString());
            f2.format("%n xAxis=  %s", this.xaxis == null ? "" : this.xaxis.getNameAndDimensions());
            f2.format("%n yAxis=  %s", this.yaxis == null ? "" : this.yaxis.getNameAndDimensions());
            f2.format("%n zAxis=  %s", this.vertAxis == null ? "" : this.vertAxis.getNameAndDimensions());
            f2.format("%n tAxis=  %s", this.timeAxis == null ? "" : this.timeAxis.getNameAndDimensions());
            f2.format("%n rtAxis= %s", this.rtAxis == null ? "" : this.rtAxis.getNameAndDimensions());
            f2.format("%n toAxis= %s", this.timeOffsetAxis == null ? "" : this.timeOffsetAxis.getNameAndDimensions());
            f2.format("%n ensAxis=%s", this.ensAxis == null ? "" : this.ensAxis.getNameAndDimensions());
            if (this.featureType == null) {
                return f2.toString();
            }
            f2.format("%n%n axes=(", new Object[0]);
            for (CoordinateAxis axis : this.indAxes) {
                f2.format("%s, ", axis.getShortName());
            }
            f2.format(") {", new Object[0]);
            return f2.toString();
        }
    }
}

