/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import ucar.array.ArrayType;
import ucar.nc2.Group;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.SequenceDS;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.internal.dataset.CoordSystemBuilder;
import ucar.nc2.internal.dataset.CoordSystemFactory;
import ucar.nc2.util.CancelTask;

public class DatasetEnhancer {
    private final NetcdfDataset.Builder<?> dsBuilder;
    private final Set<NetcdfDataset.Enhance> wantEnhance;
    private final CancelTask cancelTask;

    public static boolean enhanceNeeded(Set<NetcdfDataset.Enhance> want, Set<NetcdfDataset.Enhance> have) {
        if (want == null) {
            return false;
        }
        if (have == null && !want.isEmpty()) {
            return true;
        }
        for (NetcdfDataset.Enhance mode : want) {
            if (have.contains((Object)mode)) continue;
            return true;
        }
        return false;
    }

    public DatasetEnhancer(NetcdfDataset.Builder<?> ds, Set<NetcdfDataset.Enhance> wantEnhance, CancelTask cancelTask) {
        this.dsBuilder = ds;
        this.wantEnhance = wantEnhance == null ? EnumSet.noneOf(NetcdfDataset.Enhance.class) : wantEnhance;
        this.cancelTask = cancelTask;
    }

    public NetcdfDataset.Builder<?> enhance() throws IOException {
        Optional<CoordSystemBuilder> hasNewBuilder;
        CoordSystemBuilder coordSysBuilder = null;
        if (this.wantEnhance.contains((Object)NetcdfDataset.Enhance.CoordSystems) && !this.dsBuilder.getEnhanceMode().contains((Object)NetcdfDataset.Enhance.CoordSystems) && (hasNewBuilder = CoordSystemFactory.factory(this.dsBuilder, this.cancelTask)).isPresent()) {
            coordSysBuilder = hasNewBuilder.get();
            coordSysBuilder.augmentDataset(this.cancelTask);
            this.dsBuilder.setConventionUsed(coordSysBuilder.getConventionUsed());
        }
        this.enhanceGroup(this.dsBuilder.rootGroup);
        if (coordSysBuilder != null) {
            if (this.wantEnhance.contains((Object)NetcdfDataset.Enhance.IncompleteCoordSystems)) {
                this.dsBuilder.addEnhanceMode(NetcdfDataset.Enhance.IncompleteCoordSystems);
                coordSysBuilder.buildCoordinateSystems();
                this.dsBuilder.removeEnhanceMode(NetcdfDataset.Enhance.IncompleteCoordSystems);
            } else {
                coordSysBuilder.buildCoordinateSystems();
            }
        }
        this.dsBuilder.addEnhanceModes(this.wantEnhance);
        return this.dsBuilder;
    }

    private void enhanceGroup(Group.Builder group) {
        for (Variable.Builder<?> vb : group.vbuilders) {
            if (vb instanceof StructureDS.Builder) {
                this.enhanceStructure((StructureDS.Builder)vb);
                continue;
            }
            if (vb instanceof SequenceDS.Builder) {
                this.enhanceSequence((SequenceDS.Builder)vb);
                continue;
            }
            if (vb instanceof VariableDS.Builder) {
                this.enhanceVariable((VariableDS.Builder)vb);
                continue;
            }
            throw new IllegalStateException("Not a VariableDS " + vb);
        }
        for (Group.Builder gb : group.gbuilders) {
            this.enhanceGroup(gb);
        }
    }

    private void enhanceStructure(StructureDS.Builder<?> sdb) {
        for (Variable.Builder vb : sdb.vbuilders) {
            if (vb instanceof StructureDS.Builder) {
                this.enhanceStructure((StructureDS.Builder)vb);
                continue;
            }
            if (vb instanceof SequenceDS.Builder) {
                this.enhanceSequence((SequenceDS.Builder)vb);
                continue;
            }
            if (vb instanceof VariableDS.Builder) {
                this.enhanceVariable((VariableDS.Builder)vb);
                continue;
            }
            throw new IllegalStateException("Not a VariableDS " + vb.shortName);
        }
    }

    private void enhanceSequence(SequenceDS.Builder<?> sdb) {
        for (Variable.Builder vb : sdb.vbuilders) {
            if (vb instanceof StructureDS.Builder) {
                this.enhanceStructure((StructureDS.Builder)vb);
                continue;
            }
            if (vb instanceof SequenceDS.Builder) {
                this.enhanceSequence((SequenceDS.Builder)vb);
                continue;
            }
            if (vb instanceof VariableDS.Builder) {
                this.enhanceVariable((VariableDS.Builder)vb);
                continue;
            }
            throw new IllegalStateException("Not a VariableDS " + vb.shortName);
        }
    }

    private void enhanceVariable(VariableDS.Builder<?> vb) {
        EnumSet<NetcdfDataset.Enhance> varEnhance = EnumSet.copyOf(this.wantEnhance);
        if (vb.orgVar instanceof VariableDS) {
            for (NetcdfDataset.Enhance orgVarEnhancement : ((VariableDS)vb.orgVar).getEnhanceMode()) {
                varEnhance.remove((Object)orgVarEnhancement);
            }
        }
        if (varEnhance.contains((Object)NetcdfDataset.Enhance.ConvertEnums) && vb.dataType.isEnum()) {
            vb.setArrayType(ArrayType.STRING);
        }
        vb.addEnhanceMode(varEnhance);
    }
}

