/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset;

import java.nio.ByteBuffer;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.array.Array;
import ucar.array.StructureData;
import ucar.array.StructureDataStorageBB;
import ucar.array.StructureMembers;
import ucar.nc2.dataset.SequenceDS;
import ucar.nc2.internal.dataset.StructureDataArrayEnhancer;

public class SequenceArrayEnhancer
implements Iterator<StructureData> {
    private static final Logger logger = LoggerFactory.getLogger(SequenceArrayEnhancer.class);
    private final SequenceDS topStructure;
    private final Iterator<StructureData> orgIterator;
    private final StructureMembers members;

    public SequenceArrayEnhancer(SequenceDS topStructure, Iterator<StructureData> orgIterator) {
        this.topStructure = topStructure;
        this.orgIterator = orgIterator;
        this.members = topStructure.makeStructureMembersBuilder().setStandardOffsets(false).build();
    }

    @Override
    public boolean hasNext() {
        return this.orgIterator.hasNext();
    }

    @Override
    public StructureData next() {
        StructureData sdata = this.orgIterator.next();
        return this.enhance(sdata);
    }

    private StructureData enhance(StructureData orgData) {
        StructureMembers orgMembers = orgData.getStructureMembers();
        ByteBuffer bbuffer = ByteBuffer.allocate(this.members.getStorageSizeBytes());
        StructureDataStorageBB storage = new StructureDataStorageBB(this.members, bbuffer, 1);
        for (StructureMembers.Member member : this.members) {
            StructureMembers.Member orgMember = orgMembers.findMember(member.getName());
            Array<?> data = orgData.getMemberData(orgMember);
            StructureDataArrayEnhancer.convertNestedData(this.topStructure, 0, member, storage, bbuffer, data);
        }
        return storage.get(0L);
    }
}

