/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset;

import com.google.common.base.Preconditions;
import com.google.common.collect.UnmodifiableIterator;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.array.Array;
import ucar.array.ArrayType;
import ucar.array.ArrayVlen;
import ucar.array.Storage;
import ucar.array.StructureData;
import ucar.array.StructureDataArray;
import ucar.array.StructureDataStorageBB;
import ucar.array.StructureMembers;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.StructureEnhanced;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;

public class StructureDataArrayEnhancer {
    private static final Logger logger = LoggerFactory.getLogger(StructureDataArrayEnhancer.class);
    private final StructureEnhanced topStructure;
    private final StructureDataArray org;
    private final StructureMembers members;
    private final ByteBuffer bbuffer;
    private final StructureDataStorageBB storage;

    public StructureDataArrayEnhancer(StructureEnhanced topStructure, StructureDataArray org) {
        this.topStructure = topStructure;
        this.org = org;
        this.members = ((Structure)((Object)topStructure)).makeStructureMembersBuilder().setStandardOffsets(false).build();
        this.bbuffer = ByteBuffer.allocate((int)(org.length() * (long)this.members.getStorageSizeBytes()));
        this.storage = new StructureDataStorageBB(this.members, this.bbuffer, (int)org.length());
    }

    public StructureDataArray enhance() {
        StructureMembers orgMembers = this.org.getStructureMembers();
        int row = 0;
        while ((long)row < this.org.length()) {
            StructureData orgData = this.org.get(row);
            for (StructureMembers.Member member : this.members) {
                StructureMembers.Member orgMember = orgMembers.findMember(member.getName());
                int pos = row * this.members.getStorageSizeBytes();
                Array<?> data = orgData.getMemberData(orgMember);
                StructureDataArrayEnhancer.convertNestedData(this.topStructure, pos, member, this.storage, this.bbuffer, data);
            }
            ++row;
        }
        return new StructureDataArray(this.members, this.org.getShape(), (Storage<StructureData>)this.storage);
    }

    static void convertNestedData(StructureEnhanced structure, int offset, StructureMembers.Member member, StructureDataStorageBB storage, ByteBuffer bbuffer, Array<?> orgMemberData) {
        VariableEnhanced ve = (VariableEnhanced)((Object)structure.findVariable(member.getName()));
        if (ve == null && structure.getOriginalVariable() != null) {
            ve = StructureDataArrayEnhancer.findVariableFromOrgName(structure, member.getName());
        }
        Preconditions.checkNotNull((Object)ve);
        if (member.getArrayType() == ArrayType.OPAQUE) {
            int index = storage.putOnHeap(orgMemberData);
            int pos = offset + member.getOffset();
            bbuffer.position(pos);
            bbuffer.putInt(index);
        } else if (member.getArrayType() == ArrayType.SEQUENCE) {
            Preconditions.checkArgument((boolean)(ve instanceof StructureEnhanced));
            Preconditions.checkArgument((boolean)(orgMemberData instanceof StructureDataArray));
            StructureDataArrayEnhancer nested = new StructureDataArrayEnhancer((StructureEnhanced)ve, (StructureDataArray)orgMemberData);
            StructureDataArray seqData = nested.enhance();
            int index = storage.putOnHeap(seqData);
            int pos = offset + member.getOffset();
            bbuffer.position(pos);
            bbuffer.putInt(index);
        } else if (member.isVlen()) {
            Preconditions.checkArgument((boolean)(orgMemberData instanceof ArrayVlen));
            Preconditions.checkArgument((boolean)(ve instanceof VariableDS));
            ArrayVlen<?> converted = StructureDataArrayEnhancer.convertVlen((VariableDS)ve, (ArrayVlen)orgMemberData);
            int index = storage.putOnHeap(converted);
            int pos = offset + member.getOffset();
            bbuffer.position(pos);
            bbuffer.putInt(index);
        } else if (member.getArrayType() == ArrayType.STRUCTURE) {
            StructureEnhanced nestedStucture = (StructureEnhanced)((Object)structure.findVariable(member.getName()));
            Preconditions.checkNotNull((Object)nestedStucture);
            Preconditions.checkArgument((member.getStructureMembers() != null ? 1 : 0) != 0);
            StructureMembers nestedMembers = member.getStructureMembers();
            StructureDataArray orgArray = (StructureDataArray)orgMemberData;
            StructureMembers orgMembers = orgArray.getStructureMembers();
            int length = (int)orgArray.length();
            for (int nrow = 0; nrow < length; ++nrow) {
                StructureData orgSdata = orgArray.get(nrow);
                for (StructureMembers.Member nmember : nestedMembers) {
                    StructureMembers.Member orgMember = orgMembers.findMember(nmember.getName());
                    Preconditions.checkNotNull((Object)orgMember, (Object)("Cant find " + orgMember.getName()));
                    int nestedPos = offset + nestedMembers.getStorageSizeBytes() * nrow + member.getOffset();
                    StructureDataArrayEnhancer.convertNestedData(nestedStucture, nestedPos, nmember, storage, bbuffer, orgSdata.getMemberData(orgMember));
                }
            }
        } else {
            VariableDS vds = (VariableDS)ve;
            Array<?> converted = vds.convertNeeded() ? vds.convertArray(orgMemberData) : orgMemberData;
            storage.setMemberData(offset, member, converted);
        }
    }

    private static ArrayVlen<?> convertVlen(VariableDS vds, ArrayVlen<?> orgVlenData) {
        if (!vds.convertNeeded()) {
            return orgVlenData;
        }
        ArrayVlen result = ArrayVlen.factory(vds.getArrayType(), orgVlenData.getShape());
        int index = 0;
        for (Array<?> data : orgVlenData) {
            result.set(index++, vds.convertArray(data));
        }
        return result;
    }

    private static VariableEnhanced findVariableFromOrgName(StructureEnhanced structureEn, String orgName) {
        UnmodifiableIterator unmodifiableIterator = structureEn.getVariables().iterator();
        while (unmodifiableIterator.hasNext()) {
            Variable vTop;
            Variable v = vTop = (Variable)unmodifiableIterator.next();
            while (v instanceof VariableEnhanced) {
                VariableEnhanced ve = (VariableEnhanced)((Object)v);
                if (ve.getOriginalName() != null && ve.getOriginalName().equals(orgName)) {
                    return (VariableEnhanced)((Object)vTop);
                }
                v = ve.getOriginalVariable();
            }
        }
        return null;
    }
}

