/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.array.ArrayType;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructureMA;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureMembers;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.internal.dataset.StructurePseudoDS;

@Immutable
public class StructurePseudo2Dim
extends StructurePseudoDS {
    private static final Logger log = LoggerFactory.getLogger(StructurePseudo2Dim.class);
    private static final boolean debugRecord = false;

    public static StructurePseudo2Dim fromVars(Group group, String shortName, List<String> varNames, Dimension outer, Dimension inner) {
        Builder builder = (Builder)((Builder)StructurePseudo2Dim.builder().setName(shortName)).setDimensions((List<Dimension>)ImmutableList.of((Object)outer, (Object)inner));
        if (varNames == null) {
            ImmutableList<Variable> vars = group.getVariables();
            varNames = new ArrayList<String>(vars.size());
            for (Variable orgV : vars) {
                if (orgV.getRank() < 2 || !outer.equals(orgV.getDimension(0)) || !inner.equals(orgV.getDimension(1))) continue;
                varNames.add(orgV.getShortName());
            }
        }
        for (String name : varNames) {
            Variable orgV;
            orgV = group.findVariableLocal(name);
            if (orgV == null) {
                log.warn("StructurePseudo2Dim cannot find variable " + name);
                continue;
            }
            if (orgV instanceof Structure) continue;
            if (!outer.equals(orgV.getDimension(0))) {
                throw new IllegalArgumentException("Variable " + orgV.getNameAndDimensions() + " must have outermost dimension=" + outer);
            }
            if (!inner.equals(orgV.getDimension(1))) {
                throw new IllegalArgumentException("Variable " + orgV.getNameAndDimensions() + " must have 2nd dimension=" + inner);
            }
            Object memberV = ((VariableDS.Builder)((VariableDS.Builder)((VariableDS.Builder)VariableDS.builder().setName(orgV.getShortName())).setDataType(orgV.getDataType())).setUnits(orgV.getUnitsString())).setDesc(orgV.getDescription());
            ((Variable.Builder)memberV).setSPobject(orgV.getSPobject());
            ((Variable.Builder)memberV).addAttributes(orgV.attributes());
            ArrayList<Dimension> dimList = new ArrayList<Dimension>((Collection<Dimension>)orgV.getDimensions());
            ((Variable.Builder)memberV).setDimensions(dimList.subList(2, dimList.size()));
            builder.addMemberVariable((Variable.Builder<?>)memberV);
            builder.addOriginalVariable(orgV);
        }
        return builder.build(group);
    }

    @Override
    protected Array _read(Section section) throws IOException, InvalidRangeException {
        if (null == section) {
            return this._read();
        }
        String err = section.checkInRange(this.getShape());
        if (err != null) {
            throw new InvalidRangeException(err);
        }
        Range outerRange = section.getRange(0);
        Range innerRange = section.getRange(1);
        StructureMembers smembers = this.makeStructureMembers();
        ArrayStructureMA asma = new ArrayStructureMA(smembers, section.getShape());
        for (Variable v : this.orgVariables) {
            ArrayList<Range> vsection = new ArrayList<Range>((Collection<Range>)v.getRanges());
            vsection.set(0, outerRange);
            vsection.set(1, innerRange);
            Array data = v.read(vsection);
            StructureMembers.Member m = smembers.findMember(v.getShortName());
            m.setDataArray(data);
        }
        return asma;
    }

    protected StructurePseudo2Dim(Builder<?> builder, Group parentGroup) {
        super((StructurePseudoDS.Builder<?>)builder, parentGroup);
    }

    @Override
    public Builder<?> toBuilder() {
        return (Builder)super.addLocalFieldsToBuilder((StructurePseudoDS.Builder<? extends StructurePseudoDS.Builder<?>>)StructurePseudo2Dim.builder());
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public static abstract class Builder<T extends Builder<T>>
    extends StructurePseudoDS.Builder<T> {
        private boolean built;

        @Override
        public StructurePseudo2Dim build(Group parentGroup) {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            this.setArrayType(ArrayType.STRUCTURE);
            return new StructurePseudo2Dim(this, parentGroup);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }
}

