/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.array.ArrayType;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructureMA;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureMembers;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.util.CancelTask;

@Immutable
public class StructurePseudoDS
extends StructureDS {
    private static final Logger log = LoggerFactory.getLogger(StructurePseudoDS.class);
    private static final boolean debugRecord = false;
    protected List<Variable> orgVariables;

    public static StructurePseudoDS fromVars(Group group, String shortName, List<String> varNames, Dimension outerDim) {
        Dimension dim0;
        Builder builder = (Builder)((Builder)StructurePseudoDS.builder().setName(shortName)).setDimensions((List<Dimension>)ImmutableList.of((Object)outerDim));
        if (varNames == null) {
            ImmutableList<Variable> vars = group.getVariables();
            varNames = new ArrayList<String>(vars.size());
            for (Variable orgV : vars) {
                if (orgV.getArrayType() == ArrayType.STRUCTURE || !outerDim.equals(dim0 = orgV.getDimension(0))) continue;
                varNames.add(orgV.getShortName());
            }
        }
        for (String name : varNames) {
            Variable orgV;
            orgV = group.findVariableLocal(name);
            if (orgV == null) {
                log.warn("StructurePseudoDS cannot find variable " + name);
                continue;
            }
            if (orgV instanceof Structure) continue;
            dim0 = orgV.getDimension(0);
            if (!outerDim.equals(dim0)) {
                throw new IllegalArgumentException("Variable " + orgV.getNameAndDimensions() + " must have outermost dimension=" + outerDim);
            }
            Object memberV = ((VariableDS.Builder)((VariableDS.Builder)((VariableDS.Builder)VariableDS.builder().setName(orgV.getShortName())).setDataType(orgV.getDataType())).setUnits(orgV.getUnitsString())).setDesc(orgV.getDescription());
            ((Variable.Builder)memberV).setSPobject(orgV.getSPobject());
            ((Variable.Builder)memberV).addAttributes(orgV.attributes());
            ArrayList<Dimension> dims = new ArrayList<Dimension>((Collection<Dimension>)orgV.getDimensions());
            dims.remove(0);
            ((Variable.Builder)memberV).setDimensions(dims);
            builder.addMemberVariable((Variable.Builder<?>)memberV);
            builder.addOriginalVariable(orgV);
        }
        return builder.build(group);
    }

    @Override
    public Array reallyRead(Variable mainv, CancelTask cancelTask) throws IOException {
        StructureMembers smembers = this.makeStructureMembers();
        ArrayStructureMA asma = new ArrayStructureMA(smembers, this.getShape());
        for (Variable v : this.orgVariables) {
            Array data = v.read();
            StructureMembers.Member m = smembers.findMember(v.getShortName());
            m.setDataArray(data);
        }
        return asma;
    }

    @Override
    public Array reallyRead(Variable mainv, Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
        if (null == section) {
            return this._read();
        }
        String err = section.checkInRange(this.getShape());
        if (err != null) {
            throw new InvalidRangeException(err);
        }
        Range r = section.getRange(0);
        StructureMembers smembers = this.makeStructureMembers();
        ArrayStructureMA asma = new ArrayStructureMA(smembers, section.getShape());
        for (Variable v : this.orgVariables) {
            ArrayList<Range> vsection = new ArrayList<Range>((Collection<Range>)v.getRanges());
            vsection.set(0, r);
            Array data = v.read(vsection);
            StructureMembers.Member m = smembers.findMember(v.getShortName());
            m.setDataArray(data);
        }
        return asma;
    }

    protected StructurePseudoDS(Builder<?> builder, Group parentGroup) {
        super((StructureDS.Builder<?>)builder, parentGroup);
        this.orgVariables = ((Builder)builder).orgVariables;
    }

    @Override
    public Builder<?> toBuilder() {
        return this.addLocalFieldsToBuilder(StructurePseudoDS.builder());
    }

    protected Builder<?> addLocalFieldsToBuilder(Builder<? extends Builder<?>> b) {
        b.addOriginalVariables(this.orgVariables);
        return (Builder)super.addLocalFieldsToBuilder((StructureDS.Builder<? extends StructureDS.Builder<?>>)b);
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public static abstract class Builder<T extends Builder<T>>
    extends StructureDS.Builder<T> {
        private final List<Variable> orgVariables = new ArrayList<Variable>();
        private boolean built;

        public T addOriginalVariable(Variable orgVar) {
            this.orgVariables.add(orgVar);
            return (T)((Builder)this.self());
        }

        public T addOriginalVariables(List<Variable> orgVars) {
            this.orgVariables.addAll(orgVars);
            return (T)((Builder)this.self());
        }

        @Override
        public StructurePseudoDS build(Group parentGroup) {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            this.setArrayType(ArrayType.STRUCTURE);
            return new StructurePseudoDS(this, parentGroup);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }
}

