/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset;

import java.util.Formatter;
import javax.annotation.Nullable;
import ucar.nc2.AttributeContainer;
import ucar.nc2.AttributeContainerMutable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.internal.dataset.CoordTransformFactory;
import ucar.nc2.internal.dataset.transform.vertical.VerticalCTBuilder;

public class TransformBuilder {
    public String name;
    private AttributeContainer ctvAttributes = new AttributeContainerMutable("");
    private CoordinateTransform preBuilt;
    private VerticalCTBuilder vertCTBuilder;
    private boolean built;

    public TransformBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public TransformBuilder setCtvAttributes(AttributeContainer ctv) {
        this.ctvAttributes = ctv;
        return this;
    }

    public TransformBuilder setPreBuilt(CoordinateTransform preBuilt) {
        this.preBuilt = preBuilt;
        this.name = preBuilt.getName();
        return this;
    }

    public TransformBuilder setVertCTBuilder(VerticalCTBuilder vertCTBuilder) {
        this.vertCTBuilder = vertCTBuilder;
        this.name = vertCTBuilder.getTransformName();
        return this;
    }

    @Nullable
    public CoordinateTransform build(NetcdfDataset ncd) {
        if (this.built) {
            throw new IllegalStateException("already built " + this.name);
        }
        this.built = true;
        if (this.preBuilt != null) {
            return this.preBuilt;
        }
        if (this.vertCTBuilder != null) {
            return this.vertCTBuilder.makeVerticalCT(ncd, this.ctvAttributes).build();
        }
        CoordinateTransform.Builder<?> ctb = CoordTransformFactory.makeCoordinateTransform(ncd, this.ctvAttributes, new Formatter(), new Formatter());
        if (ctb == null) {
            return null;
        }
        if (this.name != null) {
            ctb.setName(this.name);
        }
        ctb.setCtvAttributes(this.ctvAttributes);
        return ctb.build();
    }
}

