/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.conv;

import java.io.IOException;
import java.util.NoSuchElementException;
import ucar.ma2.ArrayByte;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.spi.CoordSystemBuilderFactory;
import ucar.nc2.internal.dataset.CoordSystemBuilder;
import ucar.nc2.internal.dataset.conv.AWIPSConvention;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.geoloc.projection.Mercator;

public class AWIPSSatConvention
extends AWIPSConvention {
    private static final String CONVENTION_NAME = "AWIPS-Sat";
    private static final boolean debugProj = false;

    private AWIPSSatConvention(NetcdfDataset.Builder<?> datasetBuilder) {
        super(datasetBuilder);
        this.conventionName = CONVENTION_NAME;
    }

    @Override
    public void augmentDataset(CancelTask cancelTask) throws IOException {
        if (this.rootGroup.findVariableLocal("x").isPresent()) {
            return;
        }
        int nx = this.rootGroup.findDimension("x").map(Dimension::getLength).orElseThrow(() -> new RuntimeException("missing dimension x"));
        int ny = this.rootGroup.findDimension("y").map(Dimension::getLength).orElseThrow(() -> new RuntimeException("missing dimension y"));
        String projName = this.rootGroup.getAttributeContainer().findAttributeString("projName", "none");
        if (projName.equalsIgnoreCase("CYLINDRICAL_EQUIDISTANT")) {
            this.makeLatLonProjection(nx, ny);
            this.datasetBuilder.replaceCoordinateAxis(this.rootGroup, this.makeLonCoordAxis("x"));
            this.datasetBuilder.replaceCoordinateAxis(this.rootGroup, this.makeLatCoordAxis("y"));
        } else {
            if (projName.equalsIgnoreCase("LAMBERT_CONFORMAL")) {
                this.projCT = this.makeLCProjection(projName, nx, ny);
            }
            if (projName.equalsIgnoreCase("MERCATOR")) {
                this.projCT = this.makeMercatorProjection(projName, nx, ny);
            }
            this.datasetBuilder.replaceCoordinateAxis(this.rootGroup, this.makeXCoordAxis("x"));
            this.datasetBuilder.replaceCoordinateAxis(this.rootGroup, this.makeYCoordAxis("y"));
        }
        VariableDS.Builder datav = (VariableDS.Builder)this.rootGroup.findVariableLocal("image").orElseThrow(() -> new RuntimeException("must have varible 'image'"));
        String long_name = this.rootGroup.getAttributeContainer().findAttributeString("channel", null);
        if (null != long_name) {
            datav.addAttribute(new Attribute("long_name", long_name));
        }
        ArrayByte.D1 missing_values = new ArrayByte.D1(2, true);
        missing_values.set(0, (byte)0);
        missing_values.set(1, (byte)-127);
        datav.addAttribute(Attribute.fromArray("missing_value", missing_values));
        if (this.projCT != null) {
            VariableDS.Builder<?> v = this.makeCoordinateTransformVariable(this.projCT);
            v.addAttribute(new Attribute("_CoordinateAxes", "x y"));
            this.rootGroup.addVariable(v);
        }
    }

    @Override
    protected AxisType getAxisType(VariableDS.Builder<?> v) {
        String units = v.getUnits();
        if (units.equalsIgnoreCase("degrees_east")) {
            return AxisType.Lon;
        }
        if (units.equalsIgnoreCase("degrees_north")) {
            return AxisType.Lat;
        }
        return super.getAxisType(v);
    }

    private void makeLatLonProjection(int nx, int ny) throws NoSuchElementException {
        double lat0 = this.findAttributeDouble("lat00");
        double lon0 = this.findAttributeDouble("lon00");
        double latEnd = this.findAttributeDouble("latNxNy");
        double lonEnd = this.findAttributeDouble("lonNxNy");
        if (lonEnd < lon0) {
            lonEnd += 360.0;
        }
        this.startx = lon0;
        this.starty = lat0;
        this.dx = (lonEnd - lon0) / (double)nx;
        this.dy = (latEnd - lat0) / (double)ny;
    }

    private ProjectionCT makeLCProjection(String name, int nx, int ny) throws NoSuchElementException {
        double centralLat = this.findAttributeDouble("centralLat");
        double centralLon = this.findAttributeDouble("centralLon");
        double rotation = this.findAttributeDouble("rotation");
        LambertConformal proj = new LambertConformal(rotation, centralLon, centralLat, centralLat);
        double lat0 = this.findAttributeDouble("lat00");
        double lon0 = this.findAttributeDouble("lon00");
        ProjectionPoint start = proj.latLonToProj(LatLonPoint.create(lat0, lon0));
        this.startx = start.getX();
        this.starty = start.getY();
        double latN = this.findAttributeDouble("latNxNy");
        double lonN = this.findAttributeDouble("lonNxNy");
        ProjectionPoint end = proj.latLonToProj(LatLonPoint.create(latN, lonN));
        this.dx = (end.getX() - this.startx) / (double)nx;
        this.dy = (end.getY() - this.starty) / (double)ny;
        return new ProjectionCT(name, "FGDC", proj);
    }

    private ProjectionCT makeMercatorProjection(String name, int nx, int ny) throws NoSuchElementException {
        double latDxDy = this.findAttributeDouble("latDxDy");
        double lonDxDy = this.findAttributeDouble("lonDxDy");
        Mercator proj = new Mercator(lonDxDy, latDxDy);
        double lat0 = this.findAttributeDouble("lat00");
        double lon0 = this.findAttributeDouble("lon00");
        ProjectionPoint start = proj.latLonToProj(LatLonPoint.create(lat0, lon0));
        this.startx = start.getX();
        this.starty = start.getY();
        double latN = this.findAttributeDouble("latNxNy");
        double lonN = this.findAttributeDouble("lonNxNy");
        ProjectionPoint end = proj.latLonToProj(LatLonPoint.create(latN, lonN));
        this.dx = (end.getX() - this.startx) / (double)nx;
        this.dy = (end.getY() - this.starty) / (double)ny;
        return new ProjectionCT(name, "FGDC", proj);
    }

    private CoordinateAxis.Builder<?> makeLonCoordAxis(String xname) {
        CoordinateAxis1D.Builder v = (CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)CoordinateAxis1D.builder().setName(xname)).setDataType(DataType.DOUBLE)).setParentGroupBuilder(this.rootGroup)).setDimensionsByName(xname)).setUnits("degrees_east")).setDesc("longitude");
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
        v.setAutoGen(this.startx, this.dx);
        this.parseInfo.format("Created Lon Coordinate Axis = %s%n", xname);
        return v;
    }

    private CoordinateAxis.Builder<?> makeLatCoordAxis(String yname) {
        CoordinateAxis1D.Builder v = (CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)CoordinateAxis1D.builder().setName(yname)).setDataType(DataType.DOUBLE)).setParentGroupBuilder(this.rootGroup)).setDimensionsByName(yname)).setUnits("degrees_north")).setDesc("latitude");
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
        v.setAutoGen(this.starty, this.dy);
        this.parseInfo.format("Created Lat Coordinate Axis = %s%n", yname);
        return v;
    }

    public static class Factory
    implements CoordSystemBuilderFactory {
        @Override
        public String getConventionName() {
            return AWIPSSatConvention.CONVENTION_NAME;
        }

        @Override
        public boolean isMine(NetcdfFile ncfile) {
            return null != ncfile.findGlobalAttribute("projName") && null != ncfile.findGlobalAttribute("lon00") && null != ncfile.findGlobalAttribute("lat00") && null != ncfile.findGlobalAttribute("lonNxNy") && null != ncfile.findGlobalAttribute("latNxNy") && null != ncfile.findGlobalAttribute("centralLon") && null != ncfile.findGlobalAttribute("centralLat") && null != ncfile.findDimension("x") && null != ncfile.findDimension("y") && null != ncfile.findVariable("image");
        }

        @Override
        public CoordSystemBuilder open(NetcdfDataset.Builder<?> datasetBuilder) {
            return new AWIPSSatConvention(datasetBuilder);
        }
    }
}

