/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.conv;

import java.io.IOException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.spi.CoordSystemBuilderFactory;
import ucar.nc2.internal.dataset.CoordSystemBuilder;
import ucar.nc2.internal.dataset.conv.CF1Convention;
import ucar.nc2.internal.ncml.NcmlReader;
import ucar.nc2.util.CancelTask;

public class CEDRICRadarConvention
extends CF1Convention {
    private static final String CONVENTION_NAME = "CEDRICRadar";

    CEDRICRadarConvention(NetcdfDataset.Builder<?> datasetBuilder) {
        super(datasetBuilder);
        this.conventionName = CONVENTION_NAME;
    }

    @Override
    protected void augmentDataset(CancelTask cancelTask) throws IOException {
        NcmlReader.wrapNcmlResource(this.datasetBuilder, "resources/nj22/coords/CEDRICRadar.ncml", cancelTask);
        VariableDS.Builder lat = (VariableDS.Builder)this.rootGroup.findVariableLocal("radar_latitude").orElseThrow(() -> new IllegalStateException("Must have radar_latitude variable"));
        VariableDS.Builder lon = (VariableDS.Builder)this.rootGroup.findVariableLocal("radar_longitude").orElseThrow(() -> new IllegalStateException("Must have radar_longitude variable"));
        float latv = (float)lat.orgVar.readScalarDouble();
        float lonv = (float)lon.orgVar.readScalarDouble();
        VariableDS.Builder pv = (VariableDS.Builder)this.rootGroup.findVariableLocal("Projection").orElseThrow(() -> new IllegalStateException("Must have Projection variable"));
        pv.addAttribute(new Attribute("longitude_of_projection_origin", Float.valueOf(lonv)));
        pv.addAttribute(new Attribute("latitude_of_projection_origin", Float.valueOf(latv)));
        super.augmentDataset(cancelTask);
    }

    public static class Factory
    implements CoordSystemBuilderFactory {
        @Override
        public String getConventionName() {
            return CEDRICRadarConvention.CONVENTION_NAME;
        }

        @Override
        public boolean isMine(NetcdfFile ncfile) {
            Dimension s = ncfile.findDimension("cedric_general_scaling_factor");
            Variable v = ncfile.findVariable("cedric_run_date");
            return v != null && s != null;
        }

        @Override
        public CoordSystemBuilder open(NetcdfDataset.Builder<?> datasetBuilder) {
            return new CEDRICRadarConvention(datasetBuilder);
        }
    }
}

