/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.conv;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.spi.CoordSystemBuilderFactory;
import ucar.nc2.internal.dataset.CoordSystemBuilder;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.projection.LambertConformal;

public class IFPSConvention
extends CoordSystemBuilder {
    private static final String CONVENTION_NAME = "IFPS";
    private Variable.Builder<?> projVar;

    private IFPSConvention(NetcdfDataset.Builder<?> datasetBuilder) {
        super(datasetBuilder);
        this.conventionName = CONVENTION_NAME;
    }

    @Override
    public void augmentDataset(CancelTask cancelTask) throws IOException {
        if (this.rootGroup.findVariableLocal("xCoord").isPresent()) {
            return;
        }
        this.parseInfo.format("IFPS augmentDataset %n", new Object[0]);
        VariableDS.Builder lonVar = (VariableDS.Builder)this.rootGroup.findVariableLocal("longitude").orElseThrow(() -> new IllegalStateException("Cant find variable longitude"));
        lonVar.setUnits("degrees_east");
        lonVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
        VariableDS.Builder latVar = (VariableDS.Builder)this.rootGroup.findVariableLocal("latitude").orElseThrow(() -> new IllegalStateException("Cant find variable latitude"));
        latVar.setUnits("degrees_north");
        latVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
        this.projVar = latVar;
        String projName = this.projVar.getAttributeContainer().findAttributeString("projectionType", null);
        if ("LAMBERT_CONFORMAL".equals(projName)) {
            Projection proj = this.makeLCProjection();
            this.makeXYcoords(proj, latVar, lonVar);
        }
        for (Variable.Builder ncvar : ImmutableList.copyOf(this.rootGroup.vbuilders)) {
            if (!(ncvar.getRank() <= 2 || "DIM_0".equals(ncvar.getFirstDimensionName()) || ncvar.shortName.endsWith("History") || ncvar.shortName.startsWith("Tool"))) {
                this.createTimeCoordinate((VariableDS.Builder)ncvar);
                continue;
            }
            if (!ncvar.shortName.equals("Topo")) continue;
            ncvar.addAttribute(new Attribute("long_name", "Topography"));
            ncvar.addAttribute(new Attribute("units", "ft"));
        }
    }

    private void createTimeCoordinate(VariableDS.Builder<?> ncVar) {
        Attribute timesAtt = ncVar.getAttributeContainer().findAttribute("validTimes");
        if (timesAtt == null || timesAtt.getValues() == null) {
            return;
        }
        Array timesArray = timesAtt.getValues();
        try {
            int n = (int)timesArray.getSize();
            ArrayList<Range> list = new ArrayList<Range>();
            list.add(new Range(0, n - 1, 2));
            timesArray = timesArray.section(list);
        }
        catch (InvalidRangeException e) {
            throw new IllegalStateException(e);
        }
        DataType dtype = DataType.getType(timesArray);
        int nTimesAtt = (int)timesArray.getSize();
        Dimension dimTime = ncVar.orgVar.getDimension(0);
        int nTimesDim = dimTime.getLength();
        if (nTimesDim != nTimesAtt) {
            this.parseInfo.format(" **error ntimes in attribute (%d) doesnt match dimension length (%d) for variable %s%n", nTimesAtt, nTimesDim, ncVar.getFullName());
            return;
        }
        String dimName = ncVar.shortName + "_timeCoord";
        Dimension newDim = new Dimension(dimName, nTimesDim);
        this.rootGroup.addDimension(newDim);
        String units = "seconds since 1970-1-1 00:00:00";
        String desc = "time coordinate for " + ncVar.shortName;
        CoordinateAxis1D.Builder timeCoord = (CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)CoordinateAxis1D.builder().setName(dimName)).setDataType(dtype)).setParentGroupBuilder(this.rootGroup)).setDimensionsByName(dimName)).setUnits(units)).setDesc(desc);
        timeCoord.setSourceData(timesArray);
        timeCoord.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        this.datasetBuilder.replaceCoordinateAxis(this.rootGroup, timeCoord);
        this.parseInfo.format(" added coordinate variable %s%n", dimName);
        ArrayList<Dimension> newDims = new ArrayList<Dimension>((Collection<Dimension>)ncVar.getDimensions());
        newDims.set(0, newDim);
        ncVar.setDimensions(newDims);
        ncVar.addAttribute(new Attribute("_CoordinateAxes", dimName + " yCoord xCoord"));
        Attribute att = ncVar.getAttributeContainer().findAttribute("fillValue");
        if (att != null) {
            ncVar.addAttribute(new Attribute("_FillValue", att.getNumericValue()));
        }
        if (null != (att = ncVar.getAttributeContainer().findAttribute("descriptiveName"))) {
            ncVar.addAttribute(new Attribute("long_name", att.getStringValue()));
        }
    }

    protected String getZisPositive() {
        return "up";
    }

    private Projection makeLCProjection() {
        Attribute latLonOrigin = this.projVar.getAttributeContainer().findAttributeIgnoreCase("latLonOrigin");
        if (latLonOrigin == null || latLonOrigin.isString()) {
            throw new IllegalStateException();
        }
        double centralLon = latLonOrigin.getNumericValue(0).doubleValue();
        double centralLat = latLonOrigin.getNumericValue(1).doubleValue();
        double par1 = this.findAttributeDouble("stdParallelOne");
        double par2 = this.findAttributeDouble("stdParallelTwo");
        LambertConformal lc = new LambertConformal(centralLat, centralLon, par1, par2);
        ProjectionCT ct = new ProjectionCT("lambertConformalProjection", "FGDC", lc);
        VariableDS.Builder<?> ctVar = this.makeCoordinateTransformVariable(ct);
        ctVar.addAttribute(new Attribute("_CoordinateAxes", "xCoord yCoord"));
        this.rootGroup.addVariable(ctVar);
        return lc;
    }

    private void makeXYcoords(Projection proj, VariableDS.Builder<?> latVar, VariableDS.Builder<?> lonVar) throws IOException {
        ProjectionPoint pp;
        LatLonPoint latlon;
        double lon;
        double lat;
        int i;
        Array latData = latVar.orgVar.read();
        Array lonData = lonVar.orgVar.read();
        Dimension y_dim = latVar.orgVar.getDimension(0);
        Dimension x_dim = latVar.orgVar.getDimension(1);
        Array xData = Array.factory(DataType.FLOAT, new int[]{x_dim.getLength()});
        Array yData = Array.factory(DataType.FLOAT, new int[]{y_dim.getLength()});
        Index latlonIndex = latData.getIndex();
        Index xIndex = xData.getIndex();
        Index yIndex = yData.getIndex();
        for (i = 0; i < x_dim.getLength(); ++i) {
            lat = latData.getDouble(latlonIndex.set1(i));
            lon = lonData.getDouble(latlonIndex);
            latlon = LatLonPoint.create(lat, lon);
            pp = proj.latLonToProj(latlon);
            xData.setDouble(xIndex.set(i), pp.getX());
        }
        for (i = 0; i < y_dim.getLength(); ++i) {
            lat = latData.getDouble(latlonIndex.set0(i));
            lon = lonData.getDouble(latlonIndex);
            latlon = LatLonPoint.create(lat, lon);
            pp = proj.latLonToProj(latlon);
            yData.setDouble(yIndex.set(i), pp.getY());
        }
        Object xaxis = ((VariableDS.Builder)((VariableDS.Builder)((VariableDS.Builder)((VariableDS.Builder)((VariableDS.Builder)VariableDS.builder().setName("xCoord")).setDataType(DataType.FLOAT)).setParentGroupBuilder(this.rootGroup)).setDimensionsByName(x_dim.getShortName())).setUnits("km")).setDesc("x on projection");
        ((Variable.Builder)xaxis).addAttribute(new Attribute("units", "km"));
        ((Variable.Builder)xaxis).addAttribute(new Attribute("long_name", "x on projection"));
        ((Variable.Builder)xaxis).addAttribute(new Attribute("_CoordinateAxisType", "GeoX"));
        Object yaxis = ((VariableDS.Builder)((VariableDS.Builder)((VariableDS.Builder)((VariableDS.Builder)((VariableDS.Builder)VariableDS.builder().setName("yCoord")).setDataType(DataType.FLOAT)).setParentGroupBuilder(this.rootGroup)).setDimensionsByName(y_dim.getShortName())).setUnits("km")).setDesc("y on projection");
        ((Variable.Builder)yaxis).addAttribute(new Attribute("units", "km"));
        ((Variable.Builder)yaxis).addAttribute(new Attribute("long_name", "y on projection"));
        ((Variable.Builder)yaxis).addAttribute(new Attribute("_CoordinateAxisType", "GeoY"));
        ((Variable.Builder)xaxis).setSourceData(xData);
        ((Variable.Builder)yaxis).setSourceData(yData);
        this.rootGroup.addVariable((Variable.Builder<?>)xaxis);
        this.rootGroup.addVariable((Variable.Builder<?>)yaxis);
    }

    private double findAttributeDouble(String attname) {
        return this.projVar.getAttributeContainer().findAttributeDouble(attname, Double.NaN);
    }

    public static class Factory
    implements CoordSystemBuilderFactory {
        @Override
        public String getConventionName() {
            return IFPSConvention.CONVENTION_NAME;
        }

        @Override
        public boolean isMine(NetcdfFile ncfile) {
            Variable v = ncfile.findVariable("latitude");
            if (null == ncfile.findVariable("longitude") || null == v) {
                return false;
            }
            boolean geoVarsCheck = null != v.findAttributeString("projectionType", null);
            Attribute ff = ncfile.findGlobalAttributeIgnoreCase("fileFormatVersion");
            if (ff == null || ff.getStringValue() == null) {
                return false;
            }
            String ffValue = ff.getStringValue();
            boolean fileFormatCheck = ffValue.equalsIgnoreCase("20030117") || ffValue.equalsIgnoreCase("20010816");
            return geoVarsCheck && fileFormatCheck;
        }

        @Override
        public CoordSystemBuilder open(NetcdfDataset.Builder<?> datasetBuilder) {
            return new IFPSConvention(datasetBuilder);
        }
    }
}

