/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.conv;

import java.io.IOException;
import java.util.StringTokenizer;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.spi.CoordSystemBuilderFactory;
import ucar.nc2.internal.dataset.CoordSystemBuilder;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.util.CancelTask;

public class UnidataObsConvention
extends CoordSystemBuilder {
    private static final String CONVENTION_NAME = "Unidata Observation Dataset v1.0";

    UnidataObsConvention(NetcdfDataset.Builder<?> datasetBuilder) {
        super(datasetBuilder);
        this.conventionName = CONVENTION_NAME;
    }

    @Override
    protected void augmentDataset(CancelTask cancelTask) throws IOException {
        VariableDS.Builder<?> v;
        String vname;
        if (!(this.hasAxisType(AxisType.Lat) || this.addAxisType("latitude", AxisType.Lat) || this.addAxisType(vname = this.rootGroup.getAttributeContainer().findAttributeString("latitude_coordinate", null), AxisType.Lat) || (v = this.hasUnits("degrees_north,degrees_N,degreesN,degree_north,degree_N,degreeN")) == null)) {
            this.addAxisType(v, AxisType.Lat);
        }
        if (!(this.hasAxisType(AxisType.Lon) || this.addAxisType("longitude", AxisType.Lon) || this.addAxisType(vname = this.rootGroup.getAttributeContainer().findAttributeString("longitude_coordinate", null), AxisType.Lon) || (v = this.hasUnits("degrees_east,degrees_E,degreesE,degree_east,degree_E,degreeE")) == null)) {
            this.addAxisType(v, AxisType.Lon);
        }
        if (!(this.hasAxisType(AxisType.Height) || this.addAxisType("altitude", AxisType.Height) || this.addAxisType("depth", AxisType.Height) || this.addAxisType(vname = this.rootGroup.getAttributeContainer().findAttributeString("altitude_coordinate", null), AxisType.Height))) {
            for (Variable.Builder<?> v2 : this.rootGroup.vbuilders) {
                String positive = v2.getAttributeContainer().findAttributeString("positive", null);
                if (positive == null) continue;
                this.addAxisType(v2, AxisType.Height);
                break;
            }
        }
        if (!(this.hasAxisType(AxisType.Time) || this.addAxisType("time", AxisType.Time) || this.addAxisType(vname = this.rootGroup.getAttributeContainer().findAttributeString("time_coordinate", null), AxisType.Time))) {
            for (Variable.Builder<?> v2 : this.rootGroup.vbuilders) {
                String unit = ((VariableDS.Builder)v2).getUnits();
                if (unit == null || !SimpleUnit.isDateUnit(unit)) continue;
                this.addAxisType(v2, AxisType.Time);
                break;
            }
        }
    }

    private boolean hasAxisType(AxisType a) {
        for (Variable.Builder<?> v : this.rootGroup.vbuilders) {
            String axisType = v.getAttributeContainer().findAttributeString("CoordinateAxisType", null);
            if (axisType == null || !axisType.equals(a.toString())) continue;
            return true;
        }
        return false;
    }

    private VariableDS.Builder<?> hasUnits(String unitList) {
        StringTokenizer stoker = new StringTokenizer(unitList, ",");
        while (stoker.hasMoreTokens()) {
            String unit = stoker.nextToken();
            for (Variable.Builder<?> v : this.rootGroup.vbuilders) {
                VariableDS.Builder ve = (VariableDS.Builder)v;
                String hasUnit = ve.getUnits();
                if (hasUnit == null || !hasUnit.equalsIgnoreCase(unit)) continue;
                return ve;
            }
        }
        return null;
    }

    private boolean addAxisType(String vname, AxisType a) {
        if (vname == null) {
            return false;
        }
        this.rootGroup.findVariableLocal(vname).ifPresent(v -> v.addAttribute(new Attribute("_CoordinateAxisType", a.toString())));
        return this.rootGroup.findVariableLocal(vname).isPresent();
    }

    private void addAxisType(Variable.Builder<?> v, AxisType a) {
        v.addAttribute(new Attribute("_CoordinateAxisType", a.toString()));
    }

    public static class Factory
    implements CoordSystemBuilderFactory {
        @Override
        public String getConventionName() {
            return UnidataObsConvention.CONVENTION_NAME;
        }

        @Override
        public CoordSystemBuilder open(NetcdfDataset.Builder<?> datasetBuilder) {
            return new UnidataObsConvention(datasetBuilder);
        }
    }
}

