/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.transform.horiz;

import java.util.Formatter;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.internal.dataset.transform.horiz.TransformBuilders;
import ucar.unidata.geoloc.Earth;

public abstract class AbstractProjectionCT {
    private static final Logger log = LoggerFactory.getLogger(AbstractProjectionCT.class);
    protected double lat0;
    protected double lon0;
    protected double false_easting;
    protected double false_northing;
    protected double earth_radius;
    protected Earth earth;
    private Formatter errBuffer;

    public abstract String getTransformName();

    public void setErrorBuffer(Formatter errBuffer) {
        this.errBuffer = errBuffer;
    }

    void readStandardParams(AttributeContainer ctv, String units) {
        this.lon0 = ctv.findAttributeDouble("longitude_of_central_meridian", Double.NaN);
        if (Double.isNaN(this.lon0)) {
            this.lon0 = ctv.findAttributeDouble("longitude_of_projection_origin", Double.NaN);
        }
        this.lat0 = ctv.findAttributeDouble("latitude_of_projection_origin", Double.NaN);
        this.false_easting = ctv.findAttributeDouble("false_easting", 0.0);
        this.false_northing = ctv.findAttributeDouble("false_northing", 0.0);
        if (this.false_easting != 0.0 || this.false_northing != 0.0) {
            double scalef = TransformBuilders.getFalseEastingScaleFactor(units);
            this.false_easting *= scalef;
            this.false_northing *= scalef;
        }
        double semi_major_axis = ctv.findAttributeDouble("semi_major_axis", Double.NaN);
        double semi_minor_axis = ctv.findAttributeDouble("semi_minor_axis", Double.NaN);
        double inverse_flattening = ctv.findAttributeDouble("inverse_flattening", 0.0);
        this.earth_radius = TransformBuilders.getEarthRadiusInKm(ctv);
        if (!(Double.isNaN(semi_major_axis) || Double.isNaN(semi_minor_axis) && inverse_flattening == 0.0)) {
            this.earth = new Earth(semi_major_axis, semi_minor_axis, inverse_flattening);
        }
    }

    double[] readAttributeDouble2(Attribute att) {
        if (att == null) {
            return null;
        }
        double[] val = new double[2];
        if (att.isString()) {
            StringTokenizer stoke = new StringTokenizer(att.getStringValue());
            val[0] = Double.parseDouble(stoke.nextToken());
            val[1] = stoke.hasMoreTokens() ? Double.parseDouble(stoke.nextToken()) : val[0];
        } else {
            val[0] = att.getNumericValue().doubleValue();
            val[1] = att.getLength() > 1 ? att.getNumericValue(1).doubleValue() : val[0];
        }
        return val;
    }
}

