/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.transform.horiz;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.AttributeContainer;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.internal.dataset.transform.horiz.AbstractProjectionCT;
import ucar.nc2.internal.dataset.transform.horiz.HorizTransformBuilderIF;
import ucar.nc2.units.SimpleUnit;

public class Geostationary
extends AbstractProjectionCT
implements HorizTransformBuilderIF {
    private static final Logger logger = LoggerFactory.getLogger(Geostationary.class);
    private static final double defaultScaleFactor = -1.0;

    @Override
    public String getTransformName() {
        return "geostationary";
    }

    public TransformType getTransformType() {
        return TransformType.Projection;
    }

    private double getScaleFactor(String geoCoordinateUnits) {
        double scaleFactor = -1.0;
        String neededMapCoordinateUnit = "radian";
        if (SimpleUnit.isCompatible(geoCoordinateUnits, neededMapCoordinateUnit)) {
            scaleFactor = SimpleUnit.getConversionFactor(geoCoordinateUnits, neededMapCoordinateUnit);
        }
        logger.debug("geoCoordinateUnits {}, scaleFactor {}", (Object)geoCoordinateUnits, (Object)scaleFactor);
        return scaleFactor;
    }

    @Override
    public ProjectionCT.Builder<?> makeCoordinateTransform(AttributeContainer ctv, String geoCoordinateUnits) {
        double flattening;
        this.readStandardParams(ctv, geoCoordinateUnits);
        double subLonDegrees = ctv.findAttributeDouble("longitude_of_projection_origin", Double.NaN);
        if (Double.isNaN(subLonDegrees)) {
            throw new IllegalArgumentException("Must specify longitude_of_projection_origin");
        }
        double perspective_point_height = ctv.findAttributeDouble("perspective_point_height", Double.NaN);
        if (Double.isNaN(perspective_point_height)) {
            throw new IllegalArgumentException("Must specify perspective_point_height");
        }
        double semi_major_axis = ctv.findAttributeDouble("semi_major_axis", Double.NaN);
        if (Double.isNaN(semi_major_axis)) {
            throw new IllegalArgumentException("Must specify semi_major_axis");
        }
        double semi_minor_axis = ctv.findAttributeDouble("semi_minor_axis", Double.NaN);
        double inv_flattening = ctv.findAttributeDouble("inverse_flattening", Double.NaN);
        if (Double.isNaN(semi_minor_axis) && Double.isNaN(inv_flattening)) {
            throw new IllegalArgumentException("Must specify semi_minor_axis and/or inverse_flattening");
        }
        if (Double.isNaN(semi_minor_axis)) {
            flattening = 1.0 / inv_flattening;
            semi_minor_axis = semi_major_axis * (1.0 - flattening);
        } else if (Double.isNaN(inv_flattening)) {
            if (semi_minor_axis != semi_major_axis) {
                flattening = (semi_major_axis - semi_minor_axis) / semi_major_axis;
                inv_flattening = 1.0 / flattening;
            }
        } else assert (!Double.isNaN(semi_minor_axis) && !Double.isNaN(inv_flattening));
        String sweep_angle = ctv.findAttributeString("sweep_angle_axis", null);
        String fixed_angle = ctv.findAttributeString("fixed_angle_axis", null);
        if (sweep_angle == null && fixed_angle == null) {
            throw new IllegalArgumentException("Must specify sweep_angle_axis or fixed_angle_axis");
        }
        boolean isSweepX = sweep_angle != null ? sweep_angle.equals("x") : fixed_angle.equals("y");
        double geoCoordinateScaleFactor = this.getScaleFactor(geoCoordinateUnits);
        ucar.unidata.geoloc.projection.sat.Geostationary proj = new ucar.unidata.geoloc.projection.sat.Geostationary(subLonDegrees, perspective_point_height, semi_minor_axis, semi_major_axis, inv_flattening, isSweepX, geoCoordinateScaleFactor);
        return ((ProjectionCT.Builder)((ProjectionCT.Builder)ProjectionCT.builder().setName(ctv.getName())).setAuthority("FGDC")).setProjection(proj);
    }
}

