/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.transform.horiz;

import ucar.nc2.AttributeContainer;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.internal.dataset.transform.horiz.AbstractProjectionCT;
import ucar.nc2.internal.dataset.transform.horiz.HorizTransformBuilderIF;
import ucar.nc2.internal.dataset.transform.horiz.TransformBuilders;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.projection.AbstractProjection;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.geoloc.projection.proj4.LambertConformalConicEllipse;

public class LambertConformalConic
extends AbstractProjectionCT
implements HorizTransformBuilderIF {
    @Override
    public String getTransformName() {
        return "lambert_conformal_conic";
    }

    @Override
    public ProjectionCT.Builder<?> makeCoordinateTransform(AttributeContainer ctv, String geoCoordinateUnits) {
        AbstractProjection proj;
        double[] pars = this.readAttributeDouble2(ctv.findAttribute("standard_parallel"));
        if (pars == null) {
            return null;
        }
        double lon0 = ctv.findAttributeDouble("longitude_of_central_meridian", Double.NaN);
        double lat0 = ctv.findAttributeDouble("latitude_of_projection_origin", Double.NaN);
        double false_easting = ctv.findAttributeDouble("false_easting", 0.0);
        double false_northing = ctv.findAttributeDouble("false_northing", 0.0);
        if (false_easting != 0.0 || false_northing != 0.0) {
            double scalef = TransformBuilders.getFalseEastingScaleFactor(geoCoordinateUnits);
            false_easting *= scalef;
            false_northing *= scalef;
        }
        double earth_radius = TransformBuilders.getEarthRadiusInKm(ctv);
        double semi_major_axis = ctv.findAttributeDouble("semi_major_axis", Double.NaN);
        double semi_minor_axis = ctv.findAttributeDouble("semi_minor_axis", Double.NaN);
        double inverse_flattening = ctv.findAttributeDouble("inverse_flattening", 0.0);
        if (!(Double.isNaN(semi_major_axis) || Double.isNaN(semi_minor_axis) && inverse_flattening == 0.0)) {
            Earth earth = new Earth(semi_major_axis, semi_minor_axis, inverse_flattening);
            proj = new LambertConformalConicEllipse(lat0, lon0, pars[0], pars[1], false_easting, false_northing, earth);
        } else {
            proj = new LambertConformal(lat0, lon0, pars[0], pars[1], false_easting, false_northing, earth_radius);
        }
        return ((ProjectionCT.Builder)((ProjectionCT.Builder)ProjectionCT.builder().setName(ctv.getName())).setAuthority("FGDC")).setProjection(proj);
    }
}

