/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.transform.horiz;

import ucar.nc2.AttributeContainer;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.internal.dataset.transform.horiz.AbstractProjectionCT;
import ucar.nc2.internal.dataset.transform.horiz.HorizTransformBuilderIF;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.projection.proj4.CylindricalEqualAreaProjection;

public class LambertCylindricalEqualArea
extends AbstractProjectionCT
implements HorizTransformBuilderIF {
    @Override
    public String getTransformName() {
        return "lambert_cylindrical_equal_area";
    }

    @Override
    public ProjectionCT.Builder<?> makeCoordinateTransform(AttributeContainer ctv, String geoCoordinateUnits) {
        double par = ctv.findAttributeDouble("standard_parallel", Double.NaN);
        this.readStandardParams(ctv, geoCoordinateUnits);
        if (this.earth == null) {
            this.earth = this.earth_radius > 0.0 ? new Earth(this.earth_radius * 1000.0) : new Earth();
        }
        CylindricalEqualAreaProjection proj = new CylindricalEqualAreaProjection(this.lon0, par, this.false_easting, this.false_northing, this.earth);
        return ((ProjectionCT.Builder)((ProjectionCT.Builder)ProjectionCT.builder().setName(ctv.getName())).setAuthority("FGDC")).setProjection(proj);
    }
}

