/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.transform.horiz;

import ucar.nc2.AttributeContainer;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.internal.dataset.transform.horiz.AbstractProjectionCT;
import ucar.nc2.internal.dataset.transform.horiz.HorizTransformBuilderIF;

public class Mercator
extends AbstractProjectionCT
implements HorizTransformBuilderIF {
    @Override
    public String getTransformName() {
        return "mercator";
    }

    @Override
    public ProjectionCT.Builder<?> makeCoordinateTransform(AttributeContainer ctv, String geoCoordinateUnits) {
        double par = ctv.findAttributeDouble("standard_parallel", Double.NaN);
        if (Double.isNaN(par)) {
            double scale = ctv.findAttributeDouble("scale_factor_at_projection_origin", Double.NaN);
            if (Double.isNaN(scale)) {
                throw new IllegalArgumentException("Mercator projection must have attribute standard_parallel or scale_factor_at_projection_origin");
            }
            par = ucar.unidata.geoloc.projection.Mercator.convertScaleToStandardParallel(scale);
        }
        this.readStandardParams(ctv, geoCoordinateUnits);
        ucar.unidata.geoloc.projection.Mercator proj = new ucar.unidata.geoloc.projection.Mercator(this.lon0, par, this.false_easting, this.false_northing, this.earth_radius);
        return ((ProjectionCT.Builder)((ProjectionCT.Builder)ProjectionCT.builder().setName(ctv.getName())).setAuthority("FGDC")).setProjection(proj);
    }
}

