/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.transform.horiz;

import ucar.nc2.AttributeContainer;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.internal.dataset.transform.horiz.AbstractProjectionCT;
import ucar.nc2.internal.dataset.transform.horiz.HorizTransformBuilderIF;
import ucar.nc2.internal.dataset.transform.horiz.TransformBuilders;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.projection.AbstractProjection;
import ucar.unidata.geoloc.projection.Stereographic;
import ucar.unidata.geoloc.projection.proj4.StereographicAzimuthalProjection;

public class PolarStereographic
extends AbstractProjectionCT
implements HorizTransformBuilderIF {
    @Override
    public String getTransformName() {
        return "polar_stereographic";
    }

    @Override
    public ProjectionCT.Builder<?> makeCoordinateTransform(AttributeContainer ctv, String geoCoordinateUnits) {
        AbstractProjection proj;
        double lon0 = ctv.findAttributeDouble("straight_vertical_longitude_from_pole", Double.NaN);
        if (Double.isNaN(lon0)) {
            lon0 = ctv.findAttributeDouble("longitude_of_projection_origin", Double.NaN);
        }
        if (Double.isNaN(lon0)) {
            throw new IllegalArgumentException("No longitude parameter");
        }
        double lat0 = ctv.findAttributeDouble("latitude_of_projection_origin", 90.0);
        double latD = 60.0;
        double scale = ctv.findAttributeDouble("scale_factor_at_projection_origin", Double.NaN);
        if (Double.isNaN(scale)) {
            double stdpar = ctv.findAttributeDouble("standard_parallel", Double.NaN);
            if (!Double.isNaN(stdpar)) {
                double sin = Math.abs(Math.sin(Math.toRadians(Math.abs(stdpar))));
                scale = (1.0 + sin) / 2.0;
                latD = stdpar;
            } else {
                scale = 0.9330127018922193;
            }
        } else {
            double temp = 2.0 * scale - 1.0;
            latD = Math.toDegrees(Math.asin(temp));
        }
        double false_easting = ctv.findAttributeDouble("false_easting", 0.0);
        double false_northing = ctv.findAttributeDouble("false_northing", 0.0);
        if (false_easting != 0.0 || false_northing != 0.0) {
            double scalef = TransformBuilders.getFalseEastingScaleFactor(geoCoordinateUnits);
            false_easting *= scalef;
            false_northing *= scalef;
        }
        double earth_radius = TransformBuilders.getEarthRadiusInKm(ctv);
        double semi_major_axis = ctv.findAttributeDouble("semi_major_axis", Double.NaN);
        double semi_minor_axis = ctv.findAttributeDouble("semi_minor_axis", Double.NaN);
        double inverse_flattening = ctv.findAttributeDouble("inverse_flattening", 0.0);
        if (!(Double.isNaN(semi_major_axis) || Double.isNaN(semi_minor_axis) && inverse_flattening == 0.0)) {
            Earth earth = new Earth(semi_major_axis, semi_minor_axis, inverse_flattening);
            proj = new StereographicAzimuthalProjection(lat0, lon0, scale, latD, false_easting, false_northing, earth);
        } else {
            proj = new Stereographic(lat0, lon0, scale, false_easting, false_northing, earth_radius);
        }
        return ((ProjectionCT.Builder)((ProjectionCT.Builder)ProjectionCT.builder().setName(ctv.getName())).setAuthority("FGDC")).setProjection(proj);
    }
}

