/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.transform.horiz;

import ucar.nc2.AttributeContainer;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.internal.dataset.transform.horiz.AbstractProjectionCT;
import ucar.nc2.internal.dataset.transform.horiz.HorizTransformBuilderIF;
import ucar.unidata.geoloc.Earth;

public class PolyconicProjection
extends AbstractProjectionCT
implements HorizTransformBuilderIF {
    @Override
    public ProjectionCT.Builder<?> makeCoordinateTransform(AttributeContainer ctv, String geoCoordinateUnits) {
        ucar.unidata.geoloc.projection.proj4.PolyconicProjection proj;
        double lon0 = ctv.findAttributeDouble("longitude_of_central_meridian", Double.NaN);
        double lat0 = ctv.findAttributeDouble("latitude_of_projection_origin", Double.NaN);
        double semi_major_axis = ctv.findAttributeDouble("semi_major_axis", Double.NaN);
        double semi_minor_axis = ctv.findAttributeDouble("semi_minor_axis", Double.NaN);
        double inverse_flattening = ctv.findAttributeDouble("inverse_flattening", 0.0);
        if (!(Double.isNaN(semi_major_axis) || Double.isNaN(semi_minor_axis) && inverse_flattening == 0.0)) {
            Earth earth = new Earth(semi_major_axis, semi_minor_axis, inverse_flattening);
            proj = new ucar.unidata.geoloc.projection.proj4.PolyconicProjection(lat0, lon0, earth);
        } else {
            proj = new ucar.unidata.geoloc.projection.proj4.PolyconicProjection(lat0, lon0);
        }
        return ((ProjectionCT.Builder)((ProjectionCT.Builder)ProjectionCT.builder().setName(ctv.getName())).setAuthority("FGDC")).setProjection(proj);
    }

    @Override
    public String getTransformName() {
        return "polyconic";
    }
}

