/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.transform.horiz;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.AttributeContainer;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.internal.dataset.transform.horiz.AlbersEqualArea;
import ucar.nc2.internal.dataset.transform.horiz.AzimuthalEquidistant;
import ucar.nc2.internal.dataset.transform.horiz.FlatEarth;
import ucar.nc2.internal.dataset.transform.horiz.Geostationary;
import ucar.nc2.internal.dataset.transform.horiz.HorizTransformBuilderIF;
import ucar.nc2.internal.dataset.transform.horiz.LambertAzimuthal;
import ucar.nc2.internal.dataset.transform.horiz.LambertConformalConic;
import ucar.nc2.internal.dataset.transform.horiz.LambertCylindricalEqualArea;
import ucar.nc2.internal.dataset.transform.horiz.LatLon;
import ucar.nc2.internal.dataset.transform.horiz.MSGnavigation;
import ucar.nc2.internal.dataset.transform.horiz.Mercator;
import ucar.nc2.internal.dataset.transform.horiz.Orthographic;
import ucar.nc2.internal.dataset.transform.horiz.PolarStereographic;
import ucar.nc2.internal.dataset.transform.horiz.PolyconicProjection;
import ucar.nc2.internal.dataset.transform.horiz.RotatedLatLon;
import ucar.nc2.internal.dataset.transform.horiz.RotatedPole;
import ucar.nc2.internal.dataset.transform.horiz.Sinusoidal;
import ucar.nc2.internal.dataset.transform.horiz.Stereographic;
import ucar.nc2.internal.dataset.transform.horiz.TransverseMercator;
import ucar.nc2.internal.dataset.transform.horiz.UTM;
import ucar.nc2.internal.dataset.transform.horiz.VerticalPerspective;
import ucar.unidata.geoloc.Projection;

public class ProjectionFactory {
    private static final Logger log = LoggerFactory.getLogger(ProjectionFactory.class);
    private static final List<Transform> transformList = new ArrayList<Transform>();
    private static boolean userMode = false;
    private static final boolean loadWarnings = false;

    public static void registerTransform(String transformName, Class<?> c) {
        if (!HorizTransformBuilderIF.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("Class " + c.getName() + " must implement HorizTransformBuilderIF");
        }
        try {
            c.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("CoordTransBuilderIF Class " + c.getName() + " cannot instantiate, probably need default Constructor");
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("CoordTransBuilderIF Class " + c.getName() + " is not accessible");
        }
        if (userMode) {
            transformList.add(0, new Transform(transformName, c));
        } else {
            transformList.add(new Transform(transformName, c));
        }
    }

    public static void registerTransform(String transformName, String className) throws ClassNotFoundException {
        Class<?> c = Class.forName(className);
        ProjectionFactory.registerTransform(transformName, c);
    }

    public static void registerTransformMaybe(String transformName, String className) {
        Class<?> c;
        try {
            c = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return;
        }
        ProjectionFactory.registerTransform(transformName, c);
    }

    @Nullable
    public static Projection makeProjection(AttributeContainer ctv, String geoUnits, Formatter parseInfo) {
        Object builderObject;
        String transform_name = ctv.findAttributeString("transform_name", null);
        if (null == transform_name) {
            transform_name = ctv.findAttributeString("Projection_Name", null);
        }
        if (null == transform_name) {
            transform_name = ctv.findAttributeString("grid_mapping_name", null);
        }
        if (null == transform_name) {
            transform_name = ctv.findAttributeString("standard_name", null);
        }
        if (null == transform_name) {
            transform_name = ctv.findAttributeString("units", null);
        }
        if (null == transform_name) {
            parseInfo.format("**Failed to find Coordinate Transform name from Variable= %s%n", ctv);
            return null;
        }
        transform_name = transform_name.trim();
        Class<?> builderClass = null;
        for (Transform transform : transformList) {
            if (!transform.transName.equals(transform_name)) continue;
            builderClass = transform.transClass;
            break;
        }
        if (null == builderClass) {
            parseInfo.format("**Failed to find CoordTransBuilder name= %s from Variable= %s%n", transform_name, ctv);
            return null;
        }
        try {
            builderObject = builderClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("Cant create new instance " + builderClass.getName(), (Throwable)e);
            return null;
        }
        HorizTransformBuilderIF horizBuilder = (HorizTransformBuilderIF)builderObject;
        horizBuilder.setErrorBuffer(parseInfo);
        ProjectionCT.Builder<?> ct = horizBuilder.makeCoordinateTransform(ctv, geoUnits);
        if (ct != null) {
            ct.setTransformType(TransformType.Projection);
        }
        if (ct != null) {
            parseInfo.format(" Made Coordinate transform %s from variable %s: %s%n", transform_name, ctv.getName(), builderObject.getClass().getName());
        } else {
            parseInfo.format(" Failed to make Coordinate transform %s from variable %s: %s%n", transform_name, ctv.getName(), builderObject.getClass().getName());
        }
        return ct.build().getProjection();
    }

    static {
        ProjectionFactory.registerTransform("albers_conical_equal_area", AlbersEqualArea.class);
        ProjectionFactory.registerTransform("azimuthal_equidistant", AzimuthalEquidistant.class);
        ProjectionFactory.registerTransform("flat_earth", FlatEarth.class);
        ProjectionFactory.registerTransform("geostationary", Geostationary.class);
        ProjectionFactory.registerTransform("lambert_azimuthal_equal_area", LambertAzimuthal.class);
        ProjectionFactory.registerTransform("lambert_conformal_conic", LambertConformalConic.class);
        ProjectionFactory.registerTransform("lambert_cylindrical_equal_area", LambertCylindricalEqualArea.class);
        ProjectionFactory.registerTransform("latitude_longitude", LatLon.class);
        ProjectionFactory.registerTransformMaybe("mcidas_area", "ucar.nc2.iosp.mcidas.McIDASAreaTransformBuilder");
        ProjectionFactory.registerTransform("mercator", Mercator.class);
        ProjectionFactory.registerTransform("MSGnavigation", MSGnavigation.class);
        ProjectionFactory.registerTransform("orthographic", Orthographic.class);
        ProjectionFactory.registerTransform("polar_stereographic", PolarStereographic.class);
        ProjectionFactory.registerTransform("polyconic", PolyconicProjection.class);
        ProjectionFactory.registerTransform("rotated_latitude_longitude", RotatedPole.class);
        ProjectionFactory.registerTransform("rotated_latlon_grib", RotatedLatLon.class);
        ProjectionFactory.registerTransform("sinusoidal", Sinusoidal.class);
        ProjectionFactory.registerTransform("stereographic", Stereographic.class);
        ProjectionFactory.registerTransform("transverse_mercator", TransverseMercator.class);
        ProjectionFactory.registerTransform("UTM", UTM.class);
        ProjectionFactory.registerTransform("vertical_perspective", VerticalPerspective.class);
        userMode = true;
    }

    private static class Transform {
        String transName;
        Class<?> transClass;

        Transform(String transName, Class<?> transClass) {
            this.transName = transName;
            this.transClass = transClass;
        }
    }
}

