/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.transform.horiz;

import ucar.nc2.AttributeContainer;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.internal.dataset.transform.horiz.AbstractProjectionCT;
import ucar.nc2.internal.dataset.transform.horiz.HorizTransformBuilderIF;
import ucar.nc2.internal.dataset.transform.horiz.TransformBuilders;

public class Sinusoidal
extends AbstractProjectionCT
implements HorizTransformBuilderIF {
    @Override
    public String getTransformName() {
        return "sinusoidal";
    }

    @Override
    public ProjectionCT.Builder<?> makeCoordinateTransform(AttributeContainer ctv, String geoCoordinateUnits) {
        double centralMeridian = ctv.findAttributeDouble("longitude_of_central_meridian", Double.NaN);
        double false_easting = ctv.findAttributeDouble("false_easting", 0.0);
        double false_northing = ctv.findAttributeDouble("false_northing", 0.0);
        double earth_radius = TransformBuilders.getEarthRadiusInKm(ctv);
        if (false_easting != 0.0 || false_northing != 0.0) {
            double scalef = TransformBuilders.getFalseEastingScaleFactor(geoCoordinateUnits);
            false_easting *= scalef;
            false_northing *= scalef;
        }
        ucar.unidata.geoloc.projection.Sinusoidal proj = new ucar.unidata.geoloc.projection.Sinusoidal(centralMeridian, false_easting, false_northing, earth_radius);
        return ((ProjectionCT.Builder)((ProjectionCT.Builder)ProjectionCT.builder().setName(ctv.getName())).setAuthority("FGDC")).setProjection(proj);
    }
}

